/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ui.wizard.ecore2xtext;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.xtext.ui.util.IJdtHelper;
import org.eclipse.xtext.xtext.ui.wizard.ecore2xtext.EPackageChooser;
import org.eclipse.xtext.xtext.ui.wizard.ecore2xtext.EPackageInfo;
import org.eclipse.xtext.xtext.ui.wizard.ecore2xtext.Messages;

public class WizardSelectImportedEPackagePage
extends WizardPage {
    private Set<EPackageInfo> ePackageInfos = new HashSet<EPackageInfo>();
    private EPackageInfo defaultEPackageInfo;
    private ComboViewer rootElementComboViewer;
    private TableViewer importedEPackagesViewer;
    private final IJdtHelper jdtHelper;

    public WizardSelectImportedEPackagePage(String pageName, IStructuredSelection selection, IJdtHelper jdtHelper) {
        super(pageName);
        this.jdtHelper = jdtHelper;
        this.setTitle(Messages.WizardSelectImportedEPackagePage_WindowTitle);
        this.setDescription(Messages.WizardSelectImportedEPackagePage_Description);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite, 0);
        label.setText(Messages.WizardSelectImportedEPackagePage_ListTitle);
        label.setLayoutData((Object)new GridData(16384, 128, false, false, 2, 1));
        this.importedEPackagesViewer = new TableViewer(composite, 2048);
        this.importedEPackagesViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 1, 3));
        this.importedEPackagesViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return Iterables.toArray((Iterable)WizardSelectImportedEPackagePage.this.ePackageInfos, EPackageInfo.class);
            }
        });
        this.importedEPackagesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof EPackageInfo) {
                    String label = ((EPackageInfo)element).getEPackageJavaFQN();
                    if (element == WizardSelectImportedEPackagePage.this.getDefaultEPackageInfo()) {
                        return String.valueOf(label) + Messages.WizardSelectImportedEPackagePage_DefaultMarker;
                    }
                    return label;
                }
                return element.toString();
            }
        });
        Button addButton = new Button(composite, 8);
        addButton.setText(Messages.WizardSelectImportedEPackagePage_AddButtonText);
        addButton.setLayoutData((Object)new GridData(4, 1024, false, false, 1, 1));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardSelectImportedEPackagePage.this.addEPackageInfos(new EPackageChooser(WizardSelectImportedEPackagePage.this.getShell(), WizardSelectImportedEPackagePage.this.jdtHelper).open());
            }
        });
        Button defaultButton = new Button(composite, 8);
        defaultButton.setText(Messages.WizardSelectImportedEPackagePage_SetDefault);
        defaultButton.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        defaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object firstElement;
                IStructuredSelection structuredSelection;
                ISelection selection = WizardSelectImportedEPackagePage.this.importedEPackagesViewer.getSelection();
                if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && (firstElement = structuredSelection.getFirstElement()) instanceof EPackageInfo) {
                    WizardSelectImportedEPackagePage.this.defaultEPackageInfo = (EPackageInfo)firstElement;
                }
                WizardSelectImportedEPackagePage.this.updateUI();
            }
        });
        Button removeButton = new Button(composite, 8);
        removeButton.setText(Messages.WizardSelectImportedEPackagePage_RemoveButtonText);
        removeButton.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = WizardSelectImportedEPackagePage.this.importedEPackagesViewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    for (Object ePackageInfo : (IStructuredSelection)selection) {
                        WizardSelectImportedEPackagePage.this.ePackageInfos.remove(ePackageInfo);
                        if (WizardSelectImportedEPackagePage.this.defaultEPackageInfo != ePackageInfo) continue;
                        WizardSelectImportedEPackagePage.this.defaultEPackageInfo = null;
                    }
                }
                WizardSelectImportedEPackagePage.this.updateUI();
            }
        });
        Label entryRuleLabel = new Label(composite, 0);
        entryRuleLabel.setText(Messages.WizardSelectImportedEPackagePage_entryRuleLabelText);
        entryRuleLabel.setLayoutData((Object)new GridData(16384, 128, false, false, 2, 1));
        CCombo rootElementComboBoxCellEditor = new CCombo(composite, 2060);
        GridData layoutData = new GridData(4, 0x1000000, true, false, 1, 1);
        layoutData.heightHint = 20;
        rootElementComboBoxCellEditor.setLayoutData((Object)layoutData);
        rootElementComboBoxCellEditor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardSelectImportedEPackagePage.this.validatePage();
            }
        });
        this.rootElementComboViewer = new ComboViewer(rootElementComboBoxCellEditor);
        this.rootElementComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return element instanceof EClass ? String.valueOf(((EClass)element).getName()) + " - " + ((EClass)element).getEPackage().getName() : super.getText(element);
            }
        });
        this.rootElementComboViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                Iterable eClasses = Iterables.filter((Iterable)Iterables.concat((Iterable)Iterables.transform((Iterable)WizardSelectImportedEPackagePage.this.ePackageInfos, (Function)new Function<EPackageInfo, List<EClassifier>>(){

                    public List<EClassifier> apply(EPackageInfo from) {
                        return from.getEPackage().getEClassifiers();
                    }
                })), EClass.class);
                ArrayList result = Lists.newArrayList((Iterable)eClasses);
                Collections.sort(result, new Comparator<EClass>(){

                    @Override
                    public int compare(EClass o1, EClass o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                return Iterables.toArray((Iterable)result, EClass.class);
            }
        });
        this.updateUI();
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)this.getControl());
    }

    public Collection<EPackageInfo> getEPackageInfos() {
        return this.ePackageInfos;
    }

    private void addEPackageInfos(List<EPackageInfo> newEPackageInfos) {
        Iterator<EPackageInfo> i = newEPackageInfos.iterator();
        block0: while (i.hasNext()) {
            EPackage newEPackage = i.next().getEPackage();
            for (EPackageInfo ePackageInfo : this.ePackageInfos) {
                EPackage ePackage = ePackageInfo.getEPackage();
                if (!ePackage.getNsURI().equals(newEPackage.getNsURI())) continue;
                i.remove();
                continue block0;
            }
        }
        this.ePackageInfos.addAll(newEPackageInfos);
        this.updateUI();
    }

    private void updateUI() {
        this.importedEPackagesViewer.setInput(this.ePackageInfos);
        ISelection selection = this.rootElementComboViewer.getSelection();
        this.rootElementComboViewer.setInput(this.ePackageInfos);
        if (selection.isEmpty()) {
            Object firstEClass = this.rootElementComboViewer.getElementAt(0);
            if (firstEClass != null) {
                this.rootElementComboViewer.setSelection((ISelection)new StructuredSelection(firstEClass));
            }
        } else {
            this.rootElementComboViewer.setSelection(selection);
        }
        this.importedEPackagesViewer.refresh();
        this.validatePage();
    }

    private void validatePage() {
        this.setPageComplete(!this.ePackageInfos.isEmpty() && this.getRootElementClass() != null);
    }

    public EClass getRootElementClass() {
        ISelection selection = this.rootElementComboViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            return (EClass)((IStructuredSelection)selection).getFirstElement();
        }
        return null;
    }

    public EPackageInfo getDefaultEPackageInfo() {
        if (this.defaultEPackageInfo == null && !this.ePackageInfos.isEmpty()) {
            this.defaultEPackageInfo = this.ePackageInfos.iterator().next();
        }
        return this.defaultEPackageInfo;
    }
}

