/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.idea.config;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import java.util.List;
import org.eclipse.xtend.core.idea.config.MavenArtifact;
import org.eclipse.xtend.core.idea.config.XtendLibraryConfigurator;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.idea.util.PlatformUtil;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public class MavenUtility {
    public void addXtendLibMavenDependency(Module module, final boolean isTestScope) {
        boolean _not;
        boolean _isMavenizedModule = this.isMavenizedModule(module);
        boolean bl = _not = !_isMavenizedModule;
        if (_not) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"Can't add maven dependency to a non maven module ");
            String _name = module.getName();
            _builder.append((Object)_name, "");
            throw new IllegalArgumentException(_builder.toString());
        }
        Project project = module.getProject();
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance((Project)project);
        MavenProject mavenProject = mavenProjectsManager.findProject(module);
        if (mavenProject == null) {
            return;
        }
        VirtualFile _file = mavenProject.getFile();
        final MavenDomProjectModel model = MavenDomUtil.getMavenDomProjectModel((Project)project, (VirtualFile)_file);
        if (model == null) {
            return;
        }
        XmlFile _file_1 = DomUtil.getFile((DomElement)model);
        List _newImmutableList = CollectionLiterals.newImmutableList((Object[])new PsiFile[]{_file_1});
        new WriteCommandAction.Simple(project, "Add Xtend lib Maven Dependency", (PsiFile[])Conversions.unwrapArray((Object)_newImmutableList, PsiFile.class)){

            protected void run() throws Throwable {
                MavenArtifact _xtendLibMavenId = XtendLibraryConfigurator.xtendLibMavenId();
                String _groupId = _xtendLibMavenId.getGroupId();
                MavenArtifact _xtendLibMavenId_1 = XtendLibraryConfigurator.xtendLibMavenId();
                String _artifactId = _xtendLibMavenId_1.getArtifactId();
                MavenArtifact _xtendLibMavenId_2 = XtendLibraryConfigurator.xtendLibMavenId();
                String _version = _xtendLibMavenId_2.getVersion();
                MavenId _mavenId = new MavenId(_groupId, _artifactId, _version);
                MavenDomDependency dependency = MavenDomUtil.createDomDependency((MavenDomProjectModel)model, null, (MavenId)_mavenId);
                if (isTestScope) {
                    GenericDomValue _scope = dependency.getScope();
                    _scope.setStringValue("test");
                }
            }
        }.execute();
    }

    public boolean isMavenizedModule(Module module) {
        PlatformUtil _platformUtil = new PlatformUtil();
        boolean _isMavenInstalled = _platformUtil.isMavenInstalled();
        if (_isMavenInstalled) {
            Project _project = module.getProject();
            MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance((Project)_project);
            boolean _xifexpression = false;
            _xifexpression = mavenProjectsManager != null ? mavenProjectsManager.isMavenizedModule(module) : false;
            return _xifexpression;
        }
        return false;
    }
}

