/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.idea.config;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.List;
import org.eclipse.xtend.core.idea.config.GradleBuildFileUtility;
import org.eclipse.xtend.core.idea.facet.XtendFacetConfiguration;
import org.eclipse.xtend.core.idea.lang.XtendLanguage;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.idea.config.XtextProjectConfigurator;
import org.eclipse.xtext.idea.facet.AbstractFacetConfiguration;
import org.eclipse.xtext.xbase.idea.facet.XbaseGeneratorConfigurationState;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class XtendProjectConfigurator
extends XtextProjectConfigurator {
    @Inject
    @Extension
    private GradleBuildFileUtility _gradleBuildFileUtility;

    public void setupOutputConfiguration(ModifiableRootModel rootModel, XtendFacetConfiguration conf) {
        Module module = rootModel.getModule();
        GroovyFile buildFile = this._gradleBuildFileUtility.locateBuildFile(module);
        if (this._gradleBuildFileUtility.isGradleedModule(module) && buildFile != null) {
            XbaseGeneratorConfigurationState _state = conf.getState();
            this.presetGradleOutputDirectories(_state, rootModel);
        } else {
            XbaseGeneratorConfigurationState _state_1 = conf.getState();
            this.presetPlainJavaOutputDirectories(_state_1, rootModel);
        }
    }

    public XtendFacetConfiguration createOrGetXtendFacetConf(Module module) {
        String _iD = XtendLanguage.INSTANCE.getID();
        AbstractFacetConfiguration _createOrGetFacetConf = this.createOrGetFacetConf(module, _iD);
        return (XtendFacetConfiguration)_createOrGetFacetConf;
    }

    public void presetGradleOutputDirectories(XbaseGeneratorConfigurationState state, final ModifiableRootModel rootModel) {
        Functions.Function1<SourceFolder, Boolean> _function = new Functions.Function1<SourceFolder, Boolean>(){

            public Boolean apply(SourceFolder it) {
                return !it.isTestSource() && it.getUrl().endsWith("xtend-gen");
            }
        };
        VirtualFile existingXtendGen = this.findSourceFolder(rootModel, (Functions.Function1<? super SourceFolder, ? extends Boolean>)_function);
        Functions.Function1<SourceFolder, Boolean> _function_1 = new Functions.Function1<SourceFolder, Boolean>(){

            public Boolean apply(SourceFolder it) {
                return it.isTestSource() && it.getUrl().endsWith("xtend-gen");
            }
        };
        VirtualFile existingXtendTestGen = this.findSourceFolder(rootModel, (Functions.Function1<? super SourceFolder, ? extends Boolean>)_function_1);
        if (existingXtendGen != null || existingXtendTestGen != null) {
            VirtualFile _elvis = null;
            _elvis = existingXtendGen != null ? existingXtendGen : existingXtendTestGen;
            String _path = _elvis.getPath();
            state.setOutputDirectory(_path);
            VirtualFile _elvis_1 = null;
            _elvis_1 = existingXtendTestGen != null ? existingXtendTestGen : existingXtendGen;
            String _path_1 = _elvis_1.getPath();
            state.setTestOutputDirectory(_path_1);
            return;
        }
        VirtualFile[] _contentRoots = rootModel.getContentRoots();
        VirtualFile _head = (VirtualFile)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)_contentRoots)));
        String parentPath = _head.getPath();
        Module _module = rootModel.getModule();
        boolean _isAndroidGradleModule = this._gradleBuildFileUtility.isAndroidGradleModule(_module);
        if (_isAndroidGradleModule) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)parentPath, "");
            _builder.append((Object)"/build/generated/source/xtend/debug");
            state.setOutputDirectory(_builder.toString());
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)parentPath, "");
            _builder_1.append((Object)"/build/generated/source/xtend/androidTest/debug");
            state.setTestOutputDirectory(_builder_1.toString());
        } else {
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append((Object)parentPath, "");
            _builder_2.append((Object)"/build/xtend-gen/main");
            state.setOutputDirectory(_builder_2.toString());
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append((Object)parentPath, "");
            _builder_3.append((Object)"/build/xtend-gen/test");
            state.setTestOutputDirectory(_builder_3.toString());
        }
        Module _module_1 = rootModel.getModule();
        final GroovyFile buildFile = this._gradleBuildFileUtility.locateBuildFile(_module_1);
        if (buildFile != null) {
            Project _project = rootModel.getProject();
            List _newImmutableList = CollectionLiterals.newImmutableList((Object[])new PsiFile[]{buildFile});
            new WriteCommandAction.Simple(_project, "Gradle: Xtend Configuration", (PsiFile[])Conversions.unwrapArray((Object)_newImmutableList, PsiFile.class)){

                protected void run() throws Throwable {
                    Module _module = rootModel.getModule();
                    XtendProjectConfigurator.this._gradleBuildFileUtility.setupGradleBuild(_module, buildFile);
                }
            }.execute();
        }
    }

    public void presetPlainJavaOutputDirectories(XbaseGeneratorConfigurationState state, ModifiableRootModel model) {
        Functions.Function1<SourceFolder, Boolean> _function = new Functions.Function1<SourceFolder, Boolean>(){

            public Boolean apply(SourceFolder it) {
                boolean _not;
                boolean _and = false;
                boolean _isTestSource = it.isTestSource();
                boolean bl = _not = !_isTestSource;
                if (!_not) {
                    _and = false;
                } else {
                    VirtualFile _file = it.getFile();
                    boolean _exists = false;
                    if (_file != null) {
                        _exists = _file.exists();
                    }
                    _and = _exists;
                }
                return _and;
            }
        };
        VirtualFile mainSrc = this.findSourceFolder(model, (Functions.Function1<? super SourceFolder, ? extends Boolean>)_function);
        Functions.Function1<SourceFolder, Boolean> _function_1 = new Functions.Function1<SourceFolder, Boolean>(){

            public Boolean apply(SourceFolder it) {
                boolean _and = false;
                boolean _isTestSource = it.isTestSource();
                if (!_isTestSource) {
                    _and = false;
                } else {
                    VirtualFile _file = it.getFile();
                    boolean _exists = false;
                    if (_file != null) {
                        _exists = _file.exists();
                    }
                    _and = _exists;
                }
                return _and;
            }
        };
        VirtualFile testSrc = this.findSourceFolder(model, (Functions.Function1<? super SourceFolder, ? extends Boolean>)_function_1);
        if (mainSrc == null && testSrc == null) {
            VirtualFile contentRoot = this.findBestContentRoot(model);
            String _path = contentRoot.getPath();
            String _plus = _path + Character.valueOf('/');
            String _plus_1 = _plus + "xtend-gen";
            state.setOutputDirectory(_plus_1);
            String _outputDirectory = state.getOutputDirectory();
            state.setTestOutputDirectory(_outputDirectory);
        } else {
            String _siblingPath = this.siblingPath((VirtualFile)ObjectExtensions.operator_elvis((Object)mainSrc, (Object)testSrc), "xtend-gen");
            state.setOutputDirectory(_siblingPath);
            String _siblingPath_1 = this.siblingPath((VirtualFile)ObjectExtensions.operator_elvis((Object)testSrc, (Object)mainSrc), "xtend-gen");
            state.setTestOutputDirectory(_siblingPath_1);
        }
    }

    public void createOutputFolders(ModifiableRootModel rootModel, XbaseGeneratorConfigurationState state) {
        try {
            String _testOutputDirectory;
            String _outputDirectory_1;
            boolean _notEquals_1;
            boolean _notEquals;
            String _outputDirectory = state.getOutputDirectory();
            VirtualFile xtendGenMain = VfsUtil.createDirectoryIfMissing((String)_outputDirectory);
            boolean bl = _notEquals = !Objects.equal((Object)xtendGenMain, null);
            if (_notEquals) {
                this.addAsSourceFolder(rootModel, xtendGenMain, JavaSourceRootType.SOURCE);
            }
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)(_outputDirectory_1 = state.getOutputDirectory()), (Object)(_testOutputDirectory = state.getTestOutputDirectory()));
            if (_notEquals_1) {
                boolean _notEquals_2;
                String _testOutputDirectory_1 = state.getTestOutputDirectory();
                VirtualFile xtendGenTest = VfsUtil.createDirectoryIfMissing((String)_testOutputDirectory_1);
                boolean bl3 = _notEquals_2 = !Objects.equal((Object)xtendGenTest, null);
                if (_notEquals_2) {
                    this.addAsSourceFolder(rootModel, xtendGenTest, JavaSourceRootType.TEST_SOURCE);
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private VirtualFile findBestContentRoot(ModifiableRootModel model) {
        boolean _greaterThan;
        boolean _equals;
        final Module module = model.getModule();
        VirtualFile[] roots = model.getContentRoots();
        int _size = ((List)Conversions.doWrapArray((Object)roots)).size();
        boolean bl = _equals = _size == 1;
        if (_equals) {
            return roots[0];
        }
        int _size_1 = ((List)Conversions.doWrapArray((Object)roots)).size();
        boolean bl2 = _greaterThan = _size_1 > 1;
        if (_greaterThan) {
            boolean _tripleNotEquals;
            VirtualFile _moduleFile = module.getModuleFile();
            boolean bl3 = _tripleNotEquals = _moduleFile != null;
            if (_tripleNotEquals) {
                Functions.Function1<VirtualFile, Boolean> _function = new Functions.Function1<VirtualFile, Boolean>(){

                    public Boolean apply(VirtualFile it) {
                        VirtualFile _moduleFile = module.getModuleFile();
                        boolean _isAncestor = VfsUtil.isAncestor((VirtualFile)it, (VirtualFile)_moduleFile, (boolean)true);
                        return !_isAncestor;
                    }
                };
                return (VirtualFile)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)roots)), (Functions.Function1)_function);
            }
            return (VirtualFile)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)roots)));
        }
        Project _project = model.getProject();
        return _project.getBaseDir();
    }

    private VirtualFile findSourceFolder(ModifiableRootModel rootModel, final Functions.Function1<? super SourceFolder, ? extends Boolean> fun) {
        ContentEntry[] _contentEntries = rootModel.getContentEntries();
        Functions.Function1<ContentEntry, Boolean> _function = new Functions.Function1<ContentEntry, Boolean>(){

            public Boolean apply(ContentEntry it) {
                SourceFolder[] _sourceFolders = it.getSourceFolders();
                Functions.Function1<SourceFolder, Boolean> _function = new Functions.Function1<SourceFolder, Boolean>(){

                    public Boolean apply(SourceFolder it) {
                        return (Boolean)fun.apply((Object)it);
                    }
                };
                SourceFolder _findFirst = (SourceFolder)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)_sourceFolders)), (Functions.Function1)_function);
                return _findFirst != null;
            }
        };
        ContentEntry contnentRoot = (ContentEntry)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)_contentEntries)), (Functions.Function1)_function);
        if (contnentRoot != null) {
            SourceFolder[] _sourceFolders = contnentRoot.getSourceFolders();
            SourceFolder _findFirst = (SourceFolder)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)_sourceFolders)), fun);
            return _findFirst.getFile();
        }
        return null;
    }

    public void addAsSourceFolder(ModifiableRootModel rootModel, final VirtualFile xtendGenMain, JavaSourceRootType type) {
        ContentEntry[] _contentEntries = rootModel.getContentEntries();
        Functions.Function1<ContentEntry, Boolean> _function = new Functions.Function1<ContentEntry, Boolean>(){

            public Boolean apply(ContentEntry it) {
                VirtualFile _file = it.getFile();
                return VfsUtil.isAncestor((VirtualFile)_file, (VirtualFile)xtendGenMain, (boolean)true);
            }
        };
        ContentEntry contentRoot = (ContentEntry)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)_contentEntries)), (Functions.Function1)_function);
        if (contentRoot != null) {
            ExcludeFolder[] _excludeFolders = contentRoot.getExcludeFolders();
            Functions.Function1<ExcludeFolder, Boolean> _function_1 = new Functions.Function1<ExcludeFolder, Boolean>(){

                public Boolean apply(ExcludeFolder it) {
                    return it.getFile() != null && VfsUtil.isAncestor((VirtualFile)it.getFile(), (VirtualFile)xtendGenMain, (boolean)true);
                }
            };
            ExcludeFolder excludedParent = (ExcludeFolder)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)_excludeFolders)), (Functions.Function1)_function_1);
            if (excludedParent != null) {
                contentRoot.removeExcludeFolder(excludedParent);
            }
            JpsJavaExtensionService _instance = JpsJavaExtensionService.getInstance();
            JavaSourceRootProperties properties = _instance.createSourceRootProperties("", true);
            SourceFolder[] _sourceFolders = contentRoot.getSourceFolders();
            Functions.Function1<SourceFolder, Boolean> _function_2 = new Functions.Function1<SourceFolder, Boolean>(){

                public Boolean apply(SourceFolder it) {
                    String _url = it.getUrl();
                    String _url_1 = xtendGenMain.getUrl();
                    return VfsUtil.isEqualOrAncestor((String)_url, (String)_url_1);
                }
            };
            SourceFolder existingSrc = (SourceFolder)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)_sourceFolders)), (Functions.Function1)_function_2);
            if (existingSrc != null) {
                JpsModuleSourceRoot _jpsElement = existingSrc.getJpsElement();
                JpsElement props = _jpsElement.getProperties();
                if (props instanceof JavaSourceRootProperties) {
                    ((JavaSourceRootProperties)props).applyChanges(properties);
                }
            } else {
                contentRoot.addSourceFolder(xtendGenMain, (JpsModuleSourceRootType)type, (JpsElement)properties);
            }
        }
    }

    private String siblingPath(VirtualFile sibling, String path) {
        VirtualFile _parent = sibling.getParent();
        String _path = _parent.getPath();
        String _plus = _path + Character.valueOf('/');
        return _plus + path;
    }
}

