/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.idea.javaconverter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.SequentialTask;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.xtend.core.formatting2.FormatterFacade;
import org.eclipse.xtend.core.idea.lang.XtendLanguage;
import org.eclipse.xtend.core.javaconverter.JavaConverter;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ConvertJavaCodeHandler
implements RefactoringActionHandler {
    @Inject
    private Provider<JavaConverter> jcProvider;
    @Inject
    private FormatterFacade formatter;

    public ConvertJavaCodeHandler() {
        XtendLanguage.INSTANCE.injectMembers(this);
    }

    public void invoke(Project project, Editor editor, PsiFile file, DataContext dataContext) {
        List _newImmutableList = CollectionLiterals.newImmutableList((Object[])new PsiElement[]{file});
        this.invoke(project, (PsiElement[])Conversions.unwrapArray((Object)_newImmutableList, PsiElement.class), dataContext);
    }

    public void invoke(Project project, PsiElement[] elements, DataContext dataContext) {
        Iterable<PsiJavaFile> _collectJavaFiles = ConvertJavaCodeHandler.collectJavaFiles(elements);
        List _list = IterableExtensions.toList(_collectJavaFiles);
        Project _data = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        this.runJavaConverter(_list, _data);
    }

    public static Iterable<PsiJavaFile> collectJavaFiles(PsiElement[] elements) {
        Functions.Function1<PsiElement, Iterable<PsiJavaFile>> _function = new Functions.Function1<PsiElement, Iterable<PsiJavaFile>>(){

            public Iterable<PsiJavaFile> apply(PsiElement it) {
                ImmutableList _xifexpression = null;
                if (it instanceof PsiJavaFile) {
                    _xifexpression = ImmutableList.of((Object)((PsiJavaFile)it));
                } else {
                    ImmutableList _xifexpression_1 = null;
                    PsiFile _containingFile = it.getContainingFile();
                    if (_containingFile instanceof PsiJavaFile) {
                        PsiFile _containingFile_1 = it.getContainingFile();
                        _xifexpression_1 = ImmutableList.of((Object)((PsiJavaFile)_containingFile_1));
                    } else {
                        Iterable<PsiJavaFile> _xifexpression_2 = null;
                        if (it instanceof PsiDirectory) {
                            PsiElement[] _children = ((PsiDirectory)it).getChildren();
                            _xifexpression_2 = ConvertJavaCodeHandler.collectJavaFiles(_children);
                        }
                        _xifexpression_1 = _xifexpression_2;
                    }
                    _xifexpression = _xifexpression_1;
                }
                return _xifexpression;
            }
        };
        List iterables = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)elements)), (Functions.Function1)_function);
        Iterable _filterNull = IterableExtensions.filterNull((Iterable)iterables);
        return Iterables.concat((Iterable)_filterNull);
    }

    public void runJavaConverter(final Collection<PsiJavaFile> files, Project project) {
        final HashMap coversionResult = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
        abstract class __ConvertJavaCodeHandler_1
        extends Task.Backgroundable {
            final __ConvertJavaCodeHandler_1 _this__ConvertJavaCodeHandler_1;
            int done;

            __ConvertJavaCodeHandler_1(@Nls(capitalization=Nls.Capitalization.Title) @NotNull Project project, String title, boolean canBeCancelled) {
                super(project, title, canBeCancelled);
                this._this__ConvertJavaCodeHandler_1 = this;
            }
        }
        __ConvertJavaCodeHandler_1 task = new __ConvertJavaCodeHandler_1(project, "Conversion...", true){
            {
                super(x0, x1, x2);
                this.done = 0;
            }

            public void run(final ProgressIndicator indicator) {
                Procedures.Procedure1<PsiJavaFile> _function = new Procedures.Procedure1<PsiJavaFile>(){

                    public void apply(final PsiJavaFile javaFile) {
                        boolean _isCanceled = indicator.isCanceled();
                        if (_isCanceled) {
                            return;
                        }
                        String _name = javaFile.getName();
                        String _plus = "Converting " + _name;
                        indicator.setText(_plus);
                        JavaConverter jc = (JavaConverter)ConvertJavaCodeHandler.this.jcProvider.get();
                        Application _application = ApplicationManager.getApplication();
                        Functions.Function1<Object, String> _function = new Functions.Function1<Object, String>(){

                            public String apply(Object it) {
                                return javaFile.getText();
                            }
                        };
                        String javaSrc = (String)_application.runReadAction((Computable)new Computable<String>((Functions.Function1)_function){
                            final /* synthetic */ Functions.Function1 val$_function;
                            {
                                this.val$_function = function1;
                            }

                            public String compute() {
                                return (String)this.val$_function.apply(null);
                            }
                        });
                        Project _project = _this__ConvertJavaCodeHandler_1.getProject();
                        ProjectRootManager _instance = ProjectRootManager.getInstance((Project)_project);
                        ProjectFileIndex _fileIndex = _instance.getFileIndex();
                        VirtualFile _virtualFile = javaFile.getVirtualFile();
                        Module context = _fileIndex.getModuleForFile(_virtualFile);
                        VirtualFile _virtualFile_1 = javaFile.getVirtualFile();
                        String _nameWithoutExtension = _virtualFile_1.getNameWithoutExtension();
                        JavaConverter.ConversionResult result = jc.toXtend(_nameWithoutExtension, javaSrc, (Object)context);
                        String _xtendCode = result.getXtendCode();
                        String _format = ConvertJavaCodeHandler.this.formatter.format(_xtendCode);
                        result.setXtendCode(_format);
                        coversionResult.put(javaFile, result);
                        ++_this__ConvertJavaCodeHandler_1.done;
                        int _size = files.size();
                        double _divide = (double)_this__ConvertJavaCodeHandler_1.done / (double)_size;
                        indicator.setFraction(_divide);
                    }
                };
                IterableExtensions.forEach((Iterable)files, (Procedures.Procedure1)_function);
            }

            public void onSuccess() {
                boolean _not;
                boolean _isEmpty = coversionResult.isEmpty();
                boolean bl = _not = !_isEmpty;
                if (_not) {
                    boolean _not_1;
                    Set _keySet;
                    FileModificationService _instance = FileModificationService.getInstance();
                    boolean _preparePsiElementsForWrite = _instance.preparePsiElementsForWrite(_keySet = coversionResult.keySet());
                    boolean bl2 = _not_1 = !_preparePsiElementsForWrite;
                    if (_not_1) {
                        return;
                    }
                    Project _project = this.getProject();
                    final SequentialModalProgressTask progressTask = new SequentialModalProgressTask(_project, "Applying conversion results", true);
                    progressTask.setMinIterationTime(50L);
                    ConvertJavaSequentialTask _convertJavaSequentialTask = new ConvertJavaSequentialTask(coversionResult, progressTask);
                    progressTask.setTask((SequentialTask)_convertJavaSequentialTask);
                    CommandProcessor _instance_1 = CommandProcessor.getInstance();
                    Project _project_1 = this.getProject();
                    Runnable _function = new Runnable(){

                        @Override
                        public void run() {
                            CommandProcessor _instance = CommandProcessor.getInstance();
                            Project _project = _this__ConvertJavaCodeHandler_1.getProject();
                            _instance.markCurrentCommandAsGlobal(_project);
                            Application _application = ApplicationManager.getApplication();
                            Functions.Function1<Object, String> _function = new Functions.Function1<Object, String>(){

                                public String apply(Object it) {
                                    String _xtrycatchfinallyexpression = null;
                                    try {
                                        ProgressManager _instance = ProgressManager.getInstance();
                                        _instance.run((Task)progressTask);
                                    }
                                    catch (Throwable _t) {
                                        if (_t instanceof ProcessCanceledException) {
                                            ProcessCanceledException e = (ProcessCanceledException)_t;
                                            _xtrycatchfinallyexpression = (String)InputOutput.println((Object)"Canceled");
                                        }
                                        throw Exceptions.sneakyThrow((Throwable)_t);
                                    }
                                    return _xtrycatchfinallyexpression;
                                }
                            };
                            _application.runWriteAction(new Runnable((Functions.Function1)_function){
                                final /* synthetic */ Functions.Function1 val$_function;
                                {
                                    this.val$_function = function1;
                                }

                                @Override
                                public void run() {
                                    this.val$_function.apply(null);
                                }
                            });
                        }
                    };
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append((Object)"Convert ");
                    Set _keySet_1 = coversionResult.keySet();
                    int _size = _keySet_1.size();
                    _builder.append((Object)_size, "");
                    _builder.append((Object)" Java to Xtend");
                    _instance_1.executeCommand(_project_1, _function, _builder.toString(), null);
                }
            }
        };
        ProgressManager _instance = ProgressManager.getInstance();
        _instance.run((Task)task);
    }

    private static class ConvertJavaSequentialTask
    implements SequentialTask {
        private final int todo;
        private final Iterator<Runnable> workUnits;
        private final SequentialModalProgressTask progressTask;
        private int alreadyDone = 0;

        private ConvertJavaSequentialTask(final Map<PsiFile, JavaConverter.ConversionResult> runnables, SequentialModalProgressTask modalProgressTask) {
            int _size;
            Set<Map.Entry<PsiFile, JavaConverter.ConversionResult>> _entrySet = runnables.entrySet();
            Functions.Function1<Map.Entry<PsiFile, JavaConverter.ConversionResult>, Runnable> _function = new Functions.Function1<Map.Entry<PsiFile, JavaConverter.ConversionResult>, Runnable>(){

                public Runnable apply(final Map.Entry<PsiFile, JavaConverter.ConversionResult> resultEntry) {
                    return new Runnable(){

                        @Override
                        public void run() {
                            try {
                                boolean _not;
                                JavaConverter.ConversionResult result = (JavaConverter.ConversionResult)resultEntry.getValue();
                                String _xtendCode = result.getXtendCode();
                                boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)_xtendCode);
                                boolean bl = _not = !_isNullOrEmpty;
                                if (_not) {
                                    boolean _tripleEquals;
                                    PsiFile _key = (PsiFile)resultEntry.getKey();
                                    VirtualFile jvf = _key.getVirtualFile();
                                    String _nameWithoutExtension = jvf.getNameWithoutExtension();
                                    String xtendFileName = _nameWithoutExtension + ".xtend";
                                    VirtualFile _parent = jvf.getParent();
                                    VirtualFile _findChild = _parent.findChild(xtendFileName);
                                    boolean bl2 = _tripleEquals = _findChild == null;
                                    if (_tripleEquals) {
                                        boolean _tripleEquals_1;
                                        VirtualFile _parent_1 = jvf.getParent();
                                        final VirtualFile xtendFile = _parent_1.createChildData((Object)this, xtendFileName);
                                        String _xtendCode_1 = result.getXtendCode();
                                        byte[] _bytes = _xtendCode_1.getBytes();
                                        xtendFile.setBinaryContent(_bytes);
                                        PsiFile _key_1 = (PsiFile)resultEntry.getKey();
                                        final Project project = _key_1.getProject();
                                        CodeStyleManager formatter = CodeStyleManager.getInstance((Project)project);
                                        PsiFile xtendPsiFile = PsiUtil.getPsiFile((Project)project, (VirtualFile)xtendFile);
                                        formatter.reformat((PsiElement)xtendPsiFile);
                                        jvf.delete((Object)this);
                                        int _size = runnables.size();
                                        boolean bl3 = _tripleEquals_1 = _size == 1;
                                        if (_tripleEquals_1) {
                                            Application _application = ApplicationManager.getApplication();
                                            Runnable _function = new Runnable(){

                                                @Override
                                                public void run() {
                                                    FileEditorManager _instance = FileEditorManager.getInstance((Project)project);
                                                    _instance.openFile(xtendFile, true);
                                                }
                                            };
                                            _application.invokeLater(_function);
                                        }
                                    }
                                }
                            }
                            catch (Throwable _e) {
                                throw Exceptions.sneakyThrow((Throwable)_e);
                            }
                        }
                    };
                }
            };
            Iterable _map = IterableExtensions.map(_entrySet, (Functions.Function1)_function);
            Iterator _iterator = _map.iterator();
            this.workUnits = _iterator;
            this.progressTask = modalProgressTask;
            this.todo = _size = runnables.size();
        }

        public void prepare() {
        }

        public boolean isDone() {
            return this.alreadyDone > this.todo - 1;
        }

        public boolean iteration() {
            ProgressIndicator indicator = this.progressTask.getIndicator();
            if (indicator != null) {
                indicator.setFraction((double)this.alreadyDone / (double)this.todo);
            }
            Runnable _next = this.workUnits.next();
            _next.run();
            ++this.alreadyDone;
            return true;
        }

        public void stop() {
            this.alreadyDone = this.todo;
        }
    }
}

