/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro.declaration;

import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.macro.declaration.CompilationUnitImpl;
import org.eclipse.xtend.core.macro.declaration.JvmTypeDeclarationImpl;
import org.eclipse.xtend.core.macro.declaration.JvmTypeParameterDeclarationImpl;
import org.eclipse.xtend.core.macro.declaration.PrimitiveTypeImpl;
import org.eclipse.xtend.core.macro.declaration.VoidTypeImpl;
import org.eclipse.xtend.core.macro.declaration.XtendTypeDeclarationImpl;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.PrimitiveType;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeParameterDeclarator;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.services.TypeReferenceProvider;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmAnyTypeReference;
import org.eclipse.xtext.common.types.JvmComponentType;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class TypeReferenceProviderImpl
implements TypeReferenceProvider {
    @Extension
    private CompilationUnitImpl compilationUnit;

    public TypeReferenceProviderImpl(CompilationUnitImpl compilationUnit) {
        this.compilationUnit = compilationUnit;
    }

    public TypeReference getAnyType() {
        TypeReferences _typeReferences = this.compilationUnit.getTypeReferences();
        XtendFile _xtendFile = this.compilationUnit.getXtendFile();
        JvmAnyTypeReference _createAnyTypeReference = _typeReferences.createAnyTypeReference((Notifier)_xtendFile);
        return this.compilationUnit.toTypeReference((JvmTypeReference)_createAnyTypeReference);
    }

    public TypeReference getList(TypeReference param) {
        return this.newTypeReference("java.util.List", param);
    }

    public TypeReference getObject() {
        TypeReferences _typeReferences = this.compilationUnit.getTypeReferences();
        XtendFile _xtendFile = this.compilationUnit.getXtendFile();
        JvmType _findDeclaredType = _typeReferences.findDeclaredType(Object.class, (Notifier)_xtendFile);
        JvmParameterizedTypeReference _createTypeRef = this.createTypeRef(_findDeclaredType, new JvmTypeReference[0]);
        return this.compilationUnit.toTypeReference((JvmTypeReference)_createTypeRef);
    }

    public TypeReference getPrimitiveBoolean() {
        return this.newTypeReference("boolean", new TypeReference[0]);
    }

    public TypeReference getPrimitiveByte() {
        return this.newTypeReference("byte", new TypeReference[0]);
    }

    public TypeReference getPrimitiveChar() {
        return this.newTypeReference("char", new TypeReference[0]);
    }

    public TypeReference getPrimitiveDouble() {
        return this.newTypeReference("double", new TypeReference[0]);
    }

    public TypeReference getPrimitiveFloat() {
        return this.newTypeReference("float", new TypeReference[0]);
    }

    public TypeReference getPrimitiveInt() {
        return this.newTypeReference("int", new TypeReference[0]);
    }

    public TypeReference getPrimitiveLong() {
        return this.newTypeReference("long", new TypeReference[0]);
    }

    public TypeReference getPrimitiveShort() {
        return this.newTypeReference("short", new TypeReference[0]);
    }

    public TypeReference getPrimitiveVoid() {
        return this.newTypeReference("void", new TypeReference[0]);
    }

    public TypeReference getSet(TypeReference param) {
        return this.newTypeReference("java.util.Set", param);
    }

    public TypeReference getString() {
        return this.newTypeReference("java.lang.String", new TypeReference[0]);
    }

    public TypeReference newArrayTypeReference(TypeReference componentType) {
        TypeReference _xblockexpression = null;
        this.compilationUnit.checkCanceled();
        TypeReferences _typeReferences = this.compilationUnit.getTypeReferences();
        JvmTypeReference _jvmTypeReference = this.compilationUnit.toJvmTypeReference(componentType);
        JvmGenericArrayTypeReference _createArrayType = _typeReferences.createArrayType(_jvmTypeReference);
        _xblockexpression = this.compilationUnit.toTypeReference((JvmTypeReference)_createArrayType);
        return _xblockexpression;
    }

    public TypeReference newTypeReference(String typeName, TypeReference ... typeArguments) {
        TypeReference _xblockexpression = null;
        this.compilationUnit.checkCanceled();
        TypeReferences _typeReferences = this.compilationUnit.getTypeReferences();
        XtendFile _xtendFile = this.compilationUnit.getXtendFile();
        JvmType type = _typeReferences.findDeclaredType(typeName, (Notifier)_xtendFile);
        if (type == null) {
            return null;
        }
        Functions.Function1<TypeReference, JvmTypeReference> _function = new Functions.Function1<TypeReference, JvmTypeReference>(){

            public JvmTypeReference apply(TypeReference it) {
                return TypeReferenceProviderImpl.this.compilationUnit.toJvmTypeReference(it);
            }
        };
        List _map = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)typeArguments)), (Functions.Function1)_function);
        JvmParameterizedTypeReference _createTypeRef = this.createTypeRef(type, (JvmTypeReference[])Conversions.unwrapArray((Object)_map, JvmTypeReference.class));
        _xblockexpression = this.compilationUnit.toTypeReference((JvmTypeReference)_createTypeRef);
        return _xblockexpression;
    }

    public JvmParameterizedTypeReference createTypeRef(JvmType type, JvmTypeReference ... typeArgs) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        JvmParameterizedTypeReference reference = TypesFactory.eINSTANCE.createJvmParameterizedTypeReference();
        reference.setType(type);
        JvmTypeReference[] jvmTypeReferenceArray = typeArgs;
        int n = typeArgs.length;
        int n2 = 0;
        while (n2 < n) {
            JvmTypeReference typeArg = jvmTypeReferenceArray[n2];
            EList _arguments = reference.getArguments();
            JvmTypeReference _cloneIfContained = (JvmTypeReference)EcoreUtil2.cloneIfContained((EObject)typeArg);
            _arguments.add((Object)_cloneIfContained);
            ++n2;
        }
        if (type instanceof JvmGenericType) {
            EList list = ((JvmGenericType)type).getTypeParameters();
            if (!reference.getArguments().isEmpty() && list.size() != reference.getArguments().size()) {
                String _identifier = ((JvmGenericType)type).getIdentifier();
                String _plus = "The type " + _identifier;
                String _plus_1 = String.valueOf(_plus) + " expects ";
                int _size = list.size();
                String _plus_2 = String.valueOf(_plus_1) + Integer.valueOf(_size);
                String _plus_3 = String.valueOf(_plus_2) + " type arguments, but was ";
                EList _arguments_1 = reference.getArguments();
                int _size_1 = _arguments_1.size();
                String _plus_4 = String.valueOf(_plus_3) + Integer.valueOf(_size_1);
                String _plus_5 = String.valueOf(_plus_4) + ". Either pass zero arguments (raw type) or the correct number.";
                throw new IllegalArgumentException(_plus_5);
            }
        }
        return reference;
    }

    public TypeReference newTypeReference(Type typeDeclaration, TypeReference ... typeArguments) {
        TypeReference _xblockexpression = null;
        this.compilationUnit.checkCanceled();
        JvmComponentType _switchResult = null;
        boolean _matched = false;
        if (typeDeclaration instanceof JvmTypeDeclarationImpl) {
            _matched = true;
            _switchResult = (JvmComponentType)((JvmTypeDeclarationImpl)typeDeclaration).getDelegate();
        }
        if (!_matched && typeDeclaration instanceof XtendTypeDeclarationImpl) {
            _matched = true;
            IXtendJvmAssociations _jvmModelAssociations = this.compilationUnit.getJvmModelAssociations();
            XtendTypeDeclaration _delegate = (XtendTypeDeclaration)((XtendTypeDeclarationImpl)typeDeclaration).getDelegate();
            _switchResult = _jvmModelAssociations.getInferredType(_delegate);
        }
        if (!_matched && typeDeclaration instanceof JvmTypeParameterDeclarationImpl) {
            _matched = true;
            _switchResult = (JvmComponentType)((JvmTypeParameterDeclarationImpl)typeDeclaration).getDelegate();
        }
        if (!_matched && typeDeclaration instanceof PrimitiveTypeImpl) {
            _matched = true;
            TypeReference _switchResult_1 = null;
            PrimitiveType.Kind _kind = ((PrimitiveTypeImpl)typeDeclaration).getKind();
            if (_kind != null) {
                switch (_kind) {
                    case BOOLEAN: {
                        _switchResult_1 = this.getPrimitiveBoolean();
                        break;
                    }
                    case BYTE: {
                        _switchResult_1 = this.getPrimitiveByte();
                        break;
                    }
                    case CHAR: {
                        _switchResult_1 = this.getPrimitiveChar();
                        break;
                    }
                    case DOUBLE: {
                        _switchResult_1 = this.getPrimitiveDouble();
                        break;
                    }
                    case FLOAT: {
                        _switchResult_1 = this.getPrimitiveFloat();
                        break;
                    }
                    case INT: {
                        _switchResult_1 = this.getPrimitiveInt();
                        break;
                    }
                    case LONG: {
                        _switchResult_1 = this.getPrimitiveLong();
                        break;
                    }
                    case SHORT: {
                        _switchResult_1 = this.getPrimitiveShort();
                        break;
                    }
                }
            }
            return _switchResult_1;
        }
        if (!_matched && typeDeclaration instanceof VoidTypeImpl) {
            _matched = true;
            return this.getPrimitiveVoid();
        }
        if (!_matched) {
            throw new IllegalArgumentException("couldn't construct type reference for type " + typeDeclaration);
        }
        JvmComponentType type = _switchResult;
        if (type == null) {
            return null;
        }
        Functions.Function1<TypeReference, JvmTypeReference> _function = new Functions.Function1<TypeReference, JvmTypeReference>(){

            public JvmTypeReference apply(TypeReference it) {
                return TypeReferenceProviderImpl.this.compilationUnit.toJvmTypeReference(it);
            }
        };
        List _map = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)typeArguments)), (Functions.Function1)_function);
        JvmParameterizedTypeReference _createTypeRef = this.createTypeRef((JvmType)type, (JvmTypeReference[])Conversions.unwrapArray((Object)_map, JvmTypeReference.class));
        _xblockexpression = this.compilationUnit.toTypeReference((JvmTypeReference)_createTypeRef);
        return _xblockexpression;
    }

    public TypeReference newWildcardTypeReference() {
        return this.newWildcardTypeReference(null);
    }

    public TypeReference newWildcardTypeReference(TypeReference upperBound) {
        TypeReference _xifexpression = null;
        if (upperBound == null) {
            TypeReferences _typeReferences = this.compilationUnit.getTypeReferences();
            JvmWildcardTypeReference _wildCard = _typeReferences.wildCard();
            _xifexpression = this.compilationUnit.toTypeReference((JvmTypeReference)_wildCard);
        } else {
            TypeReferences _typeReferences_1 = this.compilationUnit.getTypeReferences();
            JvmTypeReference _jvmTypeReference = this.compilationUnit.toJvmTypeReference(upperBound);
            JvmWildcardTypeReference _wildCardExtends = _typeReferences_1.wildCardExtends(_jvmTypeReference);
            _xifexpression = this.compilationUnit.toTypeReference((JvmTypeReference)_wildCardExtends);
        }
        return _xifexpression;
    }

    public TypeReference newWildcardTypeReferenceWithLowerBound(TypeReference lowerBound) {
        TypeReference _xifexpression = null;
        if (lowerBound == null) {
            TypeReferences _typeReferences = this.compilationUnit.getTypeReferences();
            JvmWildcardTypeReference _wildCard = _typeReferences.wildCard();
            _xifexpression = this.compilationUnit.toTypeReference((JvmTypeReference)_wildCard);
        } else {
            TypeReferences _typeReferences_1 = this.compilationUnit.getTypeReferences();
            JvmTypeReference _jvmTypeReference = this.compilationUnit.toJvmTypeReference(lowerBound);
            JvmWildcardTypeReference _wildCardSuper = _typeReferences_1.wildCardSuper(_jvmTypeReference);
            _xifexpression = this.compilationUnit.toTypeReference((JvmTypeReference)_wildCardSuper);
        }
        return _xifexpression;
    }

    public TypeReference newTypeReference(Class<?> clazz, TypeReference ... typeArguments) {
        String _name = clazz.getName();
        return this.newTypeReference(_name, typeArguments);
    }

    public TypeReference newSelfTypeReference(Type typeDeclaration) {
        TypeReference _xifexpression = null;
        if (typeDeclaration instanceof TypeParameterDeclarator) {
            Iterable _typeParameters = ((TypeParameterDeclarator)typeDeclaration).getTypeParameters();
            Functions.Function1<TypeParameterDeclaration, TypeReference> _function = new Functions.Function1<TypeParameterDeclaration, TypeReference>(){

                public TypeReference apply(TypeParameterDeclaration it) {
                    return TypeReferenceProviderImpl.this.newTypeReference((Type)it, new TypeReference[0]);
                }
            };
            Iterable _map = IterableExtensions.map((Iterable)_typeParameters, (Functions.Function1)_function);
            _xifexpression = this.newTypeReference(typeDeclaration, (TypeReference[])Conversions.unwrapArray((Object)_map, TypeReference.class));
        } else {
            _xifexpression = this.newTypeReference(typeDeclaration, new TypeReference[0]);
        }
        return _xifexpression;
    }
}

