/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.build;

import com.google.common.base.Objects;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.compiler.CompilerMessageImpl;
import com.intellij.compiler.ProblemsView;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.problems.WolfTheProblemSolver;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.build.BuildRequest;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.idea.build.AffectedScope;
import org.eclipse.xtext.idea.build.BuildEvent;
import org.eclipse.xtext.idea.resource.VirtualFileURIUtil;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class BuildProgressReporter
implements BuildRequest.IPostValidationCallback {
    private final UUID sessionId = UUID.randomUUID();
    private final AffectedScope affectedScope = new AffectedScope();
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private Project project;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private List<BuildEvent> events;

    protected ProblemsView getProblemsView() {
        return ProblemsView.SERVICE.getInstance((Project)this.project);
    }

    public void clearProgress() {
        boolean _tripleNotEquals;
        if (this.isUnitTestMode() || this.project.isDisposed()) {
            return;
        }
        ProblemsView _problemsView = this.getProblemsView();
        boolean bl = _tripleNotEquals = _problemsView != null;
        if (_tripleNotEquals) {
            ProblemsView _problemsView_1 = this.getProblemsView();
            _problemsView_1.clearProgress();
            ProblemsView _problemsView_2 = this.getProblemsView();
            _problemsView_2.clearOldMessages((CompileScope)this.affectedScope, this.sessionId);
        }
    }

    public void rehighlight() {
        Functions.Function1<URI, Boolean> _function;
        HashSet<URI> _affectedFiles = this.affectedScope.getAffectedFiles();
        Iterable filesToRehighlight = IterableExtensions.filter(_affectedFiles, (Functions.Function1)(_function = new Functions.Function1<URI, Boolean>(){

            public Boolean apply(URI it) {
                return BuildProgressReporter.this.shouldRehighlight(it);
            }
        }));
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)filesToRehighlight);
        if (_isEmpty) {
            return;
        }
        WolfTheProblemSolver wolfTheProblemSolver = WolfTheProblemSolver.getInstance((Project)this.project);
        for (URI fileToRehighlight : filesToRehighlight) {
            VirtualFile _virtualFile = VirtualFileURIUtil.getVirtualFile(fileToRehighlight);
            wolfTheProblemSolver.queue(_virtualFile);
        }
        DaemonCodeAnalyzer _instance = DaemonCodeAnalyzer.getInstance((Project)this.project);
        _instance.restart();
    }

    protected boolean shouldRehighlight(final URI fileURI) {
        Functions.Function1<BuildEvent, Boolean> _function_1;
        Functions.Function1<BuildEvent, Boolean> _function = new Functions.Function1<BuildEvent, Boolean>(){

            public Boolean apply(BuildEvent it) {
                return Objects.equal((Object)((Object)it.getType()), (Object)((Object)BuildEvent.Type.MODIFIED)) || Objects.equal((Object)((Object)it.getType()), (Object)((Object)BuildEvent.Type.DELETED));
            }
        };
        Iterable _filter = IterableExtensions.filter(this.events, (Functions.Function1)_function);
        boolean _exists = IterableExtensions.exists((Iterable)_filter, (Functions.Function1)(_function_1 = new Functions.Function1<BuildEvent, Boolean>(){

            public Boolean apply(BuildEvent it) {
                Set<URI> _uRIs = it.getURIs();
                return _uRIs.contains(fileURI);
            }
        }));
        return !_exists;
    }

    public void markAsAffected(URI uri) {
        HashSet<URI> _affectedFiles = this.affectedScope.getAffectedFiles();
        _affectedFiles.add(uri);
    }

    public boolean afterValidate(URI validated, Iterable<Issue> issues) {
        this.markAsAffected(validated);
        Iterable _filterNull = IterableExtensions.filterNull(issues);
        for (Issue issue : _filterNull) {
            this.reportIssue(validated, issue);
        }
        return true;
    }

    protected void reportIssue(URI validated, Issue issue) {
        boolean _tripleNotEquals;
        if (this.isUnitTestMode() || this.project.isDisposed()) {
            return;
        }
        CompilerMessage compilerMessage = this.getCompilerMessage(validated, issue);
        ProblemsView _problemsView = this.getProblemsView();
        boolean bl = _tripleNotEquals = _problemsView != null;
        if (_tripleNotEquals) {
            ProblemsView _problemsView_1 = this.getProblemsView();
            _problemsView_1.addMessage(compilerMessage, this.sessionId);
        }
    }

    protected boolean isUnitTestMode() {
        boolean _xblockexpression = false;
        Application application = ApplicationManager.getApplication();
        _xblockexpression = Objects.equal((Object)application, null) || application.isUnitTestMode();
        return _xblockexpression;
    }

    protected CompilerMessage getCompilerMessage(URI validated, Issue issue) {
        VirtualFile file = VirtualFileURIUtil.getVirtualFile(validated);
        CompilerMessageCategory _category = this.getCategory(issue);
        String _message = issue.getMessage();
        Integer _lineNumber = issue.getLineNumber();
        Integer _column = issue.getColumn();
        Integer _offset = issue.getOffset();
        OpenFileDescriptor _openFileDescriptor = new OpenFileDescriptor(this.project, file, _offset.intValue());
        return new CompilerMessageImpl(this.project, _category, _message, file, _lineNumber.intValue(), _column.intValue(), (Navigatable)_openFileDescriptor);
    }

    protected CompilerMessageCategory getCategory(Issue issue) {
        CompilerMessageCategory _switchResult = null;
        Severity _severity = issue.getSeverity();
        if (_severity != null) {
            switch (_severity) {
                case ERROR: {
                    _switchResult = CompilerMessageCategory.ERROR;
                    break;
                }
                case WARNING: {
                    _switchResult = CompilerMessageCategory.WARNING;
                    break;
                }
                case INFO: {
                    _switchResult = CompilerMessageCategory.INFORMATION;
                    break;
                }
                default: {
                    _switchResult = CompilerMessageCategory.INFORMATION;
                    break;
                }
            }
        } else {
            _switchResult = CompilerMessageCategory.INFORMATION;
        }
        return _switchResult;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public void setEvents(List<BuildEvent> events) {
        this.events = events;
    }
}

