/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.debug;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.PositionManagerImpl;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.sun.jdi.Location;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.TraceFileNameProvider;
import org.eclipse.xtext.generator.trace.TraceRegionSerializer;
import org.eclipse.xtext.idea.build.XtextAutoBuilderComponent;
import org.eclipse.xtext.idea.resource.VirtualFileURIUtil;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class DebugProcessExtensions {
    @Inject
    private TraceRegionSerializer traceRegionSerializer;
    @Inject
    private TraceFileNameProvider traceFileNameProvider;

    public PsiFile getPsiFile(final DebugProcess process, final Location location) {
        final PositionManagerImpl delegate = this.getJavaPositionManger(process);
        Application _application = ApplicationManager.getApplication();
        Computable<PsiFile> _function = new Computable<PsiFile>(){

            public PsiFile compute() {
                try {
                    Method method = PositionManagerImpl.class.getDeclaredMethod("getPsiFileByLocation", Project.class, Location.class);
                    method.setAccessible(true);
                    Project _project = process.getProject();
                    Object result = method.invoke((Object)delegate, _project, location);
                    return (PsiFile)result;
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        };
        return (PsiFile)_application.runReadAction((Computable)_function);
    }

    public AbstractTraceRegion getTraceForJava(SourcePosition javaSource) {
        try {
            PsiFile _file = javaSource.getFile();
            VirtualFile _virtualFile = _file.getVirtualFile();
            URI uri = VirtualFileURIUtil.getURI(_virtualFile);
            String _lastSegment = uri.lastSegment();
            String lastSegmentOfTrace = this.traceFileNameProvider.getTraceFromJava(_lastSegment);
            URI _trimSegments = uri.trimSegments(1);
            URI _appendSegment = _trimSegments.appendSegment(lastSegmentOfTrace);
            VirtualFile virtualFile = VirtualFileURIUtil.getVirtualFile(_appendSegment);
            if (Objects.equal((Object)virtualFile, null) || !virtualFile.exists()) {
                return null;
            }
            InputStream _inputStream = virtualFile.getInputStream();
            AbstractTraceRegion trace = this.traceRegionSerializer.readTraceRegionFrom(_inputStream);
            return trace;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public PsiFile getPsiFile(final DebugProcess process, final URI uri) {
        Application _application = ApplicationManager.getApplication();
        Computable<PsiFile> _function = new Computable<PsiFile>(){

            public PsiFile compute() {
                Project _project = process.getProject();
                PsiManager _instance = PsiManager.getInstance((Project)_project);
                VirtualFile _virtualFile = VirtualFileURIUtil.getVirtualFile(uri);
                return _instance.findFile(_virtualFile);
            }
        };
        return (PsiFile)_application.runReadAction((Computable)_function);
    }

    public Map<URI, AbstractTraceRegion> getTracesForSource(DebugProcess process, SourcePosition source) {
        try {
            Project _project = process.getProject();
            XtextAutoBuilderComponent builder = (XtextAutoBuilderComponent)((Object)_project.getComponent(XtextAutoBuilderComponent.class));
            PsiFile _file = source.getFile();
            VirtualFile _virtualFile = _file.getVirtualFile();
            URI _uRI = VirtualFileURIUtil.getURI(_virtualFile);
            Iterable<URI> generated = builder.getGeneratedSources(_uRI);
            HashMap result = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
            Functions.Function1<URI, Boolean> _function = new Functions.Function1<URI, Boolean>(){

                public Boolean apply(URI it) {
                    String _fileExtension = it.fileExtension();
                    return Objects.equal((Object)_fileExtension, (Object)"java");
                }
            };
            Iterable _filter = IterableExtensions.filter(generated, (Functions.Function1)_function);
            for (URI uri : _filter) {
                String _lastSegment = uri.lastSegment();
                String lastSegmentOfTrace = this.traceFileNameProvider.getTraceFromJava(_lastSegment);
                URI _trimSegments = uri.trimSegments(1);
                URI _appendSegment = _trimSegments.appendSegment(lastSegmentOfTrace);
                VirtualFile virtualFile = VirtualFileURIUtil.getVirtualFile(_appendSegment);
                if (Objects.equal((Object)virtualFile, null) || !virtualFile.exists()) continue;
                InputStream _inputStream = virtualFile.getInputStream();
                AbstractTraceRegion trace = this.traceRegionSerializer.readTraceRegionFrom(_inputStream);
                result.put(uri, trace);
            }
            return result;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public PositionManagerImpl getJavaPositionManger(DebugProcess process) {
        return new PositionManagerImpl((DebugProcessImpl)process);
    }

    public URI findOriginalDeclaration(DebugProcess process, Location location) {
        PsiFile psiFile = this.getPsiFile(process, location);
        boolean _equals = Objects.equal((Object)psiFile, null);
        if (_equals) {
            return null;
        }
        Project _project = process.getProject();
        XtextAutoBuilderComponent _component = (XtextAutoBuilderComponent)((Object)_project.getComponent(XtextAutoBuilderComponent.class));
        VirtualFile _virtualFile = psiFile.getVirtualFile();
        URI _uRI = VirtualFileURIUtil.getURI(_virtualFile);
        Iterable<URI> _source4GeneratedSource = _component.getSource4GeneratedSource(_uRI);
        return (URI)IterableExtensions.head(_source4GeneratedSource);
    }
}

