/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.debug;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.ExtraSteppingFilter;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.idea.debug.DebugProcessExtensions;
import org.eclipse.xtext.idea.lang.IXtextLanguage;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;

public class SkippingUnwantedSteppingFilter
implements ExtraSteppingFilter {
    @Inject
    @Extension
    private DebugProcessExtensions _debugProcessExtensions;

    public SkippingUnwantedSteppingFilter(IXtextLanguage language) {
        language.injectMembers(this);
    }

    public int getStepRequestDepth(SuspendContext context) {
        boolean _isEmptyAnonymousClassConstructor = this.isEmptyAnonymousClassConstructor(context);
        if (_isEmptyAnonymousClassConstructor) {
            return 3;
        }
        return 2;
    }

    public boolean isApplicable(SuspendContext context) {
        try {
            if (Objects.equal((Object)context, null) || !this.isXtextSourced(context)) {
                return false;
            }
            DebugProcess debugProcess = context.getDebugProcess();
            PositionManager positionManager = debugProcess.getPositionManager();
            StackFrameProxy _frameProxy = context.getFrameProxy();
            Location location = _frameProxy.location();
            boolean _isEmptyAnonymousClassConstructor = this.isEmptyAnonymousClassConstructor(context);
            if (_isEmptyAnonymousClassConstructor) {
                return true;
            }
            SourcePosition _sourcePosition = positionManager.getSourcePosition(location);
            boolean result = Objects.equal((Object)_sourcePosition, null);
            return result;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected boolean isXtextSourced(SuspendContext context) {
        try {
            StackFrameProxy _frameProxy = context.getFrameProxy();
            Location location = _frameProxy.location();
            DebugProcess _debugProcess = context.getDebugProcess();
            URI _findOriginalDeclaration = this._debugProcessExtensions.findOriginalDeclaration(_debugProcess, location);
            return !Objects.equal((Object)_findOriginalDeclaration, null);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public boolean isEmptyAnonymousClassConstructor(SuspendContext context) {
        try {
            Method method;
            boolean _notEquals;
            StackFrameProxy _frameProxy = context.getFrameProxy();
            Location location = _frameProxy.location();
            boolean bl = _notEquals = !Objects.equal((Object)location, null);
            return _notEquals && !Objects.equal((Object)(method = location.method()), null) && method.isConstructor() && method.argumentTypes().isEmpty() && method.declaringType().name().indexOf("$") > 0;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

