/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.document;

import com.intellij.openapi.editor.Document;
import java.util.List;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.xbase.compiler.ISourceAppender;
import org.eclipse.xtext.xbase.imports.RewritableImportSection;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReferenceSerializer;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitor;

public class DocumentUtils {
    public void updateImportSection(Document document, RewritableImportSection importSection) {
        List _rewrite = importSection.rewrite();
        for (ReplaceRegion reg : _rewrite) {
            int _offset = reg.getOffset();
            int _endOffset = reg.getEndOffset();
            String _text = reg.getText();
            document.replaceString(_offset, _endOffset, (CharSequence)_text);
        }
    }

    public String toImportableString(LightweightTypeReference ref, RewritableImportSection importSection) {
        ImportingSourceAppender appender = new ImportingSourceAppender(importSection);
        appender.append(ref);
        return appender.toString();
    }

    public String toImportableString(JvmTypeReference ref, RewritableImportSection importSection) {
        ImportingSourceAppender appender = new ImportingSourceAppender(importSection);
        JvmType _type = ref.getType();
        appender.append(_type);
        return appender.toString();
    }

    @FinalFieldsConstructor
    private static class ImportingSourceAppender
    implements ISourceAppender {
        private final RewritableImportSection importSection;
        private final StringBuilder result = new StringBuilder();

        public ISourceAppender append(CharSequence string) {
            this.result.append(string);
            return this;
        }

        public ISourceAppender append(JvmType object) {
            if (object instanceof JvmGenericType && (this.importSection.addImport((JvmDeclaredType)object) || this.importSection.hasImportedType((JvmDeclaredType)object) || !this.importSection.needsImport((JvmDeclaredType)object))) {
                String _simpleName = ((JvmGenericType)object).getSimpleName();
                this.result.append(_simpleName);
                return this;
            }
            String _qualifiedName = object.getQualifiedName();
            this.result.append(_qualifiedName);
            return this;
        }

        public ISourceAppender append(LightweightTypeReference typeRef) {
            ImportingSourceAppender nested = new ImportingSourceAppender(this.importSection);
            LightweightTypeReferenceSerializer serializer = new LightweightTypeReferenceSerializer((ISourceAppender)nested);
            typeRef.accept((TypeReferenceVisitor)serializer);
            String _string = nested.toString();
            this.result.append(_string);
            return this;
        }

        public String toString() {
            return this.result.toString();
        }

        public boolean isJava() {
            return false;
        }

        public ISourceAppender decreaseIndentation() {
            throw new UnsupportedOperationException("TODO: auto-generated method stub");
        }

        public ISourceAppender increaseIndentation() {
            throw new UnsupportedOperationException("TODO: auto-generated method stub");
        }

        public ISourceAppender newLine() {
            throw new UnsupportedOperationException("TODO: auto-generated method stub");
        }

        public ImportingSourceAppender(RewritableImportSection importSection) {
            this.importSection = importSection;
        }
    }
}

