/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.editorActions;

import com.google.common.base.Objects;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.tree.TokenSet;
import java.util.Collections;
import java.util.Set;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.idea.editorActions.AbstractIndentableAutoEditBlock;
import org.eclipse.xtext.idea.editorActions.AutoEditBlockRegion;
import org.eclipse.xtext.idea.editorActions.AutoEditContext;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Pure;

@Accessors
public class AutoEditMultiLineBlock
extends AbstractIndentableAutoEditBlock {
    private static final Set<Character> CHARACTERS = Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new Character[]{Character.valueOf('!'), Character.valueOf('-'), Character.valueOf('('), Character.valueOf('{'), Character.valueOf('['), Character.valueOf('\''), Character.valueOf('\"')}));
    private boolean shouldInsertClosingTerminalBeforeIndentifier = false;
    private boolean shouldInsertClosingTerminalBeforeDigit = false;
    private boolean shouldInsertClosingTerminalBeforeSpecialCharacters = false;

    public AutoEditMultiLineBlock(String openingTerminal, String closingTerminal) {
        super(openingTerminal, closingTerminal);
    }

    public AutoEditMultiLineBlock(String openingTerminal, String closingTerminal, boolean nested) {
        super(openingTerminal, null, closingTerminal, nested);
    }

    public AutoEditMultiLineBlock(String openingTerminal, String indentationTerminal, String closingTerminal) {
        super(openingTerminal, indentationTerminal, closingTerminal, false);
    }

    public AutoEditMultiLineBlock(String openingTerminal, String indentationTerminal, String closingTerminal, boolean nested) {
        super(openingTerminal, indentationTerminal, closingTerminal, nested);
    }

    @Override
    public AutoEditBlockRegion findRegion(@Extension AutoEditContext context) {
        int _caretOffset = context.getCaretOffset();
        return this.findRegion(_caretOffset, context);
    }

    protected AutoEditBlockRegion findRegion(int offset, @Extension AutoEditContext context) {
        TextRegion openingTerminal = this.findOpeningTerminal(offset, context);
        boolean _equals = Objects.equal((Object)openingTerminal, null);
        if (_equals) {
            return null;
        }
        TextRegion closingTerminal = this.findClosingTerminal(offset, context);
        if (!Objects.equal((Object)closingTerminal, (Object)-1) && this.isNested()) {
            TextRegion previousOpeningTerminal = openingTerminal;
            TextRegion previousClosingTerminal = closingTerminal;
            while (!(Objects.equal((Object)closingTerminal, null) || Objects.equal((Object)previousOpeningTerminal, null) || Objects.equal((Object)previousClosingTerminal, null))) {
                int _offset_1;
                int _plus;
                TextRegion _findClosingTerminal;
                boolean _equals_1;
                int _offset = previousOpeningTerminal.getOffset();
                TextRegion _findOpeningTerminal = this.findOpeningTerminal(_offset, context);
                boolean _notEquals = !Objects.equal((Object)(previousOpeningTerminal = _findOpeningTerminal), null);
                if (!_notEquals || !(_equals_1 = Objects.equal((Object)(previousClosingTerminal = (_findClosingTerminal = this.findClosingTerminal(_plus = (_offset_1 = previousClosingTerminal.getOffset()) + 1, context))), null))) continue;
                closingTerminal = null;
            }
        }
        return new AutoEditBlockRegion(this, openingTerminal, closingTerminal);
    }

    protected TextRegion findOpeningTerminal(int offset, @Extension AutoEditContext context) {
        EditorEx _editor = context.getEditor();
        DocumentEx _document = _editor.getDocument();
        String text = _document.getText();
        int leftOffset = offset;
        int rightOffset = offset;
        String _openingTerminal;
        TextRegion openingTerminal;
        boolean _equals;
        while (!(_equals = Objects.equal((Object)(openingTerminal = this.searchBackward(text, _openingTerminal = this.getOpeningTerminal(), leftOffset, context)), null))) {
            int _offset_1;
            int _offset;
            String _closingTerminal = this.getClosingTerminal();
            TextRegion closingTerminal = this.searchBackward(text, _closingTerminal, rightOffset, context);
            if (Objects.equal((Object)closingTerminal, null) || closingTerminal.getOffset() < openingTerminal.getOffset()) {
                return openingTerminal;
            }
            leftOffset = _offset = openingTerminal.getOffset();
            rightOffset = _offset_1 = closingTerminal.getOffset();
        }
        return null;
    }

    protected TextRegion findClosingTerminal(int offset, @Extension AutoEditContext context) {
        EditorEx _editor = context.getEditor();
        DocumentEx _document = _editor.getDocument();
        String text = _document.getText();
        int leftOffset = offset;
        int rightOffset = offset;
        String _closingTerminal;
        TextRegion closingTerminal;
        boolean _equals;
        while (!(_equals = Objects.equal((Object)(closingTerminal = this.searchForward(text, _closingTerminal = this.getClosingTerminal(), rightOffset, context)), null))) {
            int _findNextOffset_1;
            int _findNextOffset;
            String _openingTerminal = this.getOpeningTerminal();
            TextRegion openingTerminal = this.searchForward(text, _openingTerminal, leftOffset, context);
            if (Objects.equal((Object)openingTerminal, null) || openingTerminal.getOffset() > closingTerminal.getOffset()) {
                return closingTerminal;
            }
            int _offset = closingTerminal.getOffset();
            int _length = closingTerminal.getLength();
            int _plus = _offset + _length;
            rightOffset = _findNextOffset = this.findNextOffset(rightOffset, _plus, context);
            int _offset_1 = openingTerminal.getOffset();
            int _length_1 = openingTerminal.getLength();
            int _plus_1 = _offset_1 + _length_1;
            leftOffset = _findNextOffset_1 = this.findNextOffset(leftOffset, _plus_1, context);
        }
        return null;
    }

    protected int findNextOffset(int currentOffset, int nextOffset, @Extension AutoEditContext context) {
        TokenSet tokenSet = context.getTokenSet(currentOffset);
        HighlighterIterator iterator = context.createTokenIterator(nextOffset);
        int offset = nextOffset;
        while (!iterator.atEnd()) {
            TokenSet _tokenSet;
            boolean _equals;
            boolean _greaterThan;
            int _start = iterator.getStart();
            boolean bl = _greaterThan = _start > offset;
            if (_greaterThan) {
                int _start_1;
                offset = _start_1 = iterator.getStart();
            }
            if (_equals = Objects.equal((Object)tokenSet, (Object)(_tokenSet = context.getTokenSet(iterator)))) {
                return offset;
            }
            iterator.advance();
        }
        return offset;
    }

    protected TextRegion searchForward(String text, String toFind, int startOffset, @Extension AutoEditContext context) {
        int length = toFind.length();
        TokenSet tokenSet = context.getTokenSet(startOffset);
        int index = text.indexOf(toFind, startOffset);
        while (index >= 0 && index < text.length()) {
            int _indexOf;
            TokenSet _tokenSet = context.getTokenSet(index);
            boolean _equals = Objects.equal((Object)_tokenSet, (Object)tokenSet);
            if (_equals) {
                int _length = toFind.length();
                return new TextRegion(index, _length);
            }
            index = _indexOf = text.indexOf(toFind, index + length);
        }
        String trimmed = toFind.trim();
        if (!trimmed.isEmpty() && trimmed.length() != toFind.length()) {
            return this.searchForward(text, trimmed, startOffset, context);
        }
        return null;
    }

    protected TextRegion searchBackward(String text, String toFind, int endOffset, @Extension AutoEditContext context) {
        int length = toFind.length();
        TokenSet tokenSet = context.getTokenSet(endOffset);
        int index = text.lastIndexOf(toFind, endOffset - length);
        while (index >= 0) {
            int _lastIndexOf;
            TokenSet _tokenSet = context.getTokenSet(index);
            boolean _equals = Objects.equal((Object)_tokenSet, (Object)tokenSet);
            if (_equals) {
                int _length = toFind.length();
                return new TextRegion(index, _length);
            }
            index = _lastIndexOf = text.lastIndexOf(toFind, index - length);
        }
        String trimmed = toFind.trim();
        if (!trimmed.isEmpty() && trimmed.length() != toFind.length()) {
            return this.searchBackward(text, trimmed, endOffset, context);
        }
        return null;
    }

    @Override
    public String indent(AutoEditBlockRegion region, String previousLineIndentation, @Extension AutoEditContext context) {
        int caretOffset = context.getCaretOffset();
        TextRegion _openingTerminal = region.getOpeningTerminal();
        int _offset = _openingTerminal.getOffset();
        boolean _isSameLine = context.isSameLine(_offset, caretOffset);
        if (_isSameLine) {
            TextRegion closingTerminal = this.getClosingTerminal(region, context);
            boolean _equals = Objects.equal((Object)closingTerminal, null);
            if (_equals) {
                this.close(previousLineIndentation, context);
            } else if (context.isSameLine(closingTerminal.getOffset(), caretOffset) && closingTerminal.getOffset() >= caretOffset) {
                int _offset_1 = closingTerminal.getOffset();
                String _text = context.getText(caretOffset, _offset_1);
                String text = _text.trim();
                DocumentEx _document = context.getDocument();
                int _offset_2 = closingTerminal.getOffset();
                String _newLine = context.newLine(previousLineIndentation);
                String _plus = text + _newLine;
                _document.replaceString(caretOffset, _offset_2, (CharSequence)_plus);
            }
            return this.getIndentationTerminal();
        }
        TextRegion _closingTerminal = region.getClosingTerminal();
        boolean _equals_1 = Objects.equal((Object)_closingTerminal, null);
        if (_equals_1) {
            this.close(previousLineIndentation, context);
            return "";
        }
        String _indentationTerminal = this.getIndentationTerminal();
        return Strings.removeLeadingWhitespace((String)_indentationTerminal);
    }

    protected TextRegion getClosingTerminal(AutoEditBlockRegion region, @Extension AutoEditContext context) {
        TextRegion closingTerminal = region.getClosingTerminal();
        boolean _equals = Objects.equal((Object)closingTerminal, null);
        if (_equals) {
            return null;
        }
        if (closingTerminal.getLength() < this.getClosingTerminal().length() && context.isSameLine(closingTerminal.getOffset(), context.getCaretOffset())) {
            return null;
        }
        return closingTerminal;
    }

    protected void close(String previousLineIndentation, @Extension AutoEditContext context) {
        int _caretOffset = context.getCaretOffset();
        boolean _isEndOfLine = context.isEndOfLine(_caretOffset);
        if (_isEndOfLine) {
            DocumentEx _document = context.getDocument();
            int _caretOffset_1 = context.getCaretOffset();
            String _closingTerminal = this.getClosingTerminal();
            String _removeLeadingWhitespace = Strings.removeLeadingWhitespace((String)_closingTerminal);
            String _plus = previousLineIndentation + _removeLeadingWhitespace;
            String _newLine = context.newLine(_plus);
            _document.insertString(_caretOffset_1, (CharSequence)_newLine);
        }
    }

    @Override
    public void open(char c, @Extension AutoEditContext context) {
        int newCaretOffset = context.type(c);
        boolean _shouldInsertClosingTerminal = this.shouldInsertClosingTerminal(newCaretOffset, context);
        if (_shouldInsertClosingTerminal) {
            DocumentEx _document = context.getDocument();
            String _closingTerminal = this.getClosingTerminal();
            _document.insertString(newCaretOffset, (CharSequence)_closingTerminal);
        }
    }

    @Override
    public boolean close(char c, @Extension AutoEditContext context) {
        boolean _notEquals;
        int _caretOffset = context.getCaretOffset();
        AutoEditBlockRegion region = this.findRegion(_caretOffset, context);
        boolean _equals = Objects.equal((Object)region, null);
        if (_equals) {
            return false;
        }
        AutoEditBlockRegion openedRegion = this.findOpenedRegion(region, context);
        boolean bl = _notEquals = !Objects.equal((Object)openedRegion, null);
        if (_notEquals) {
            context.type(c);
        } else if (!Objects.equal((Object)region.getClosingTerminal(), null) && region.getClosingTerminal().contains(context.getCaretOffset())) {
            EditorEx _editor = context.getEditor();
            EditorModificationUtil.moveCaretRelatively((Editor)_editor, (int)1);
        } else {
            context.type(c);
        }
        return true;
    }

    protected AutoEditBlockRegion findOpenedRegion(AutoEditBlockRegion region, @Extension AutoEditContext context) {
        boolean _equals = Objects.equal((Object)region, null);
        if (_equals) {
            return null;
        }
        TextRegion _closingTerminal = region.getClosingTerminal();
        boolean _equals_1 = Objects.equal((Object)_closingTerminal, null);
        if (_equals_1) {
            return region;
        }
        TextRegion _openingTerminal = region.getOpeningTerminal();
        int _offset = _openingTerminal.getOffset();
        AutoEditBlockRegion nextRegion = this.findRegion(_offset, context);
        return this.findOpenedRegion(nextRegion, context);
    }

    protected boolean shouldInsertClosingTerminal(int offset, @Extension AutoEditContext context) {
        boolean _lessEqualsThan;
        DocumentEx _document = context.getDocument();
        int _textLength = _document.getTextLength();
        boolean bl = _lessEqualsThan = _textLength <= offset;
        if (_lessEqualsThan) {
            return true;
        }
        DocumentEx _document_1 = context.getDocument();
        CharSequence _charsSequence = _document_1.getCharsSequence();
        char charAtOffset = _charsSequence.charAt(offset);
        if (!this.shouldInsertClosingTerminalBeforeIndentifier && Character.isJavaIdentifierStart(charAtOffset)) {
            return false;
        }
        if (!this.shouldInsertClosingTerminalBeforeDigit && Character.isDigit(charAtOffset)) {
            return false;
        }
        return this.shouldInsertClosingTerminalBeforeSpecialCharacters || !this.getSpecialCharacters().contains(Character.valueOf(charAtOffset));
    }

    protected Set<Character> getSpecialCharacters() {
        return CHARACTERS;
    }

    @Pure
    public boolean isShouldInsertClosingTerminalBeforeIndentifier() {
        return this.shouldInsertClosingTerminalBeforeIndentifier;
    }

    public void setShouldInsertClosingTerminalBeforeIndentifier(boolean shouldInsertClosingTerminalBeforeIndentifier) {
        this.shouldInsertClosingTerminalBeforeIndentifier = shouldInsertClosingTerminalBeforeIndentifier;
    }

    @Pure
    public boolean isShouldInsertClosingTerminalBeforeDigit() {
        return this.shouldInsertClosingTerminalBeforeDigit;
    }

    public void setShouldInsertClosingTerminalBeforeDigit(boolean shouldInsertClosingTerminalBeforeDigit) {
        this.shouldInsertClosingTerminalBeforeDigit = shouldInsertClosingTerminalBeforeDigit;
    }

    @Pure
    public boolean isShouldInsertClosingTerminalBeforeSpecialCharacters() {
        return this.shouldInsertClosingTerminalBeforeSpecialCharacters;
    }

    public void setShouldInsertClosingTerminalBeforeSpecialCharacters(boolean shouldInsertClosingTerminalBeforeSpecialCharacters) {
        this.shouldInsertClosingTerminalBeforeSpecialCharacters = shouldInsertClosingTerminalBeforeSpecialCharacters;
    }
}

