/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.editorActions;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.text.CharArrayUtil;
import org.eclipse.xtext.idea.editorActions.AbstractAutoEditBlock;
import org.eclipse.xtext.idea.editorActions.AbstractIndentableAutoEditBlock;
import org.eclipse.xtext.idea.editorActions.AutoEditBlockProvider;
import org.eclipse.xtext.idea.editorActions.AutoEditBlockRegion;
import org.eclipse.xtext.idea.editorActions.AutoEditContext;
import org.eclipse.xtext.idea.editorActions.IdeaAutoEditHandler;
import org.eclipse.xtext.idea.editorActions.TokenSetProvider;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class DefaultAutoEditHandler
extends IdeaAutoEditHandler {
    @Inject
    @Extension
    private TokenSetProvider tokenSetProvider;
    @Inject
    @Extension
    private AutoEditBlockProvider blockProvider;
    protected static final String WHITESPACE_CHARACTERS = " \t";

    protected Iterable<AbstractIndentableAutoEditBlock> getBlocks(EditorEx editor) {
        CaretModel _caretModel = editor.getCaretModel();
        int _offset = _caretModel.getOffset();
        TokenSet _tokenSet = this.tokenSetProvider.getTokenSet(editor, _offset);
        return this.blockProvider.getBlocks(_tokenSet);
    }

    @Override
    public IdeaAutoEditHandler.Result beforeEnterTyped(PsiFile file, EditorEx editor, Ref<Integer> caretOffset, Ref<Integer> caretAdvance, DataContext dataContext, EditorActionHandler originalHandler) {
        AutoEditContext context = new AutoEditContext(editor, this.tokenSetProvider);
        AutoEditBlockRegion region = this.findBlockRegion(context);
        boolean _equals = Objects.equal((Object)region, null);
        if (_equals) {
            return IdeaAutoEditHandler.Result.CONTINUE;
        }
        return this.handleIndentation(region, context);
    }

    protected IdeaAutoEditHandler.Result handleIndentation(AutoEditBlockRegion region, @Extension AutoEditContext context) {
        String previousLineIndentation = this.getPreviousLineIndentaiton(context);
        String blockIndentaion = this.indentBlock(region, previousLineIndentation, context);
        String string = context.newLine(previousLineIndentation + blockIndentaion);
        int cursorShift = string.length();
        EditorEx _editor = context.getEditor();
        EditorModificationUtil.insertStringAtCaret((Editor)_editor, (String)string, (boolean)false, (boolean)false);
        EditorEx _editor_1 = context.getEditor();
        EditorModificationUtil.moveCaretRelatively((Editor)_editor_1, (int)cursorShift);
        return IdeaAutoEditHandler.Result.STOP;
    }

    protected String indentBlock(AutoEditBlockRegion region, String previousLineIndentation, AutoEditContext context) {
        boolean _shouldIndentBlock = this.shouldIndentBlock(region, previousLineIndentation, context);
        if (_shouldIndentBlock) {
            AbstractIndentableAutoEditBlock _block = region.getBlock();
            return _block.indent(region, previousLineIndentation, context);
        }
        return "";
    }

    protected boolean shouldIndentBlock(AutoEditBlockRegion region, String previousLineIndentation, AutoEditContext context) {
        return CodeInsightSettings.getInstance().INSERT_BRACE_ON_ENTER && Objects.equal((Object)region.getBlock().getClosingTerminal(), (Object)"}") || CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET;
    }

    protected String getPreviousLineIndentaiton(@Extension AutoEditContext context) {
        boolean _not;
        String _xblockexpression = null;
        boolean _shouldIndent = this.shouldIndent(context);
        boolean bl = _not = !_shouldIndent;
        if (_not) {
            return "";
        }
        DocumentEx _document = context.getDocument();
        int _caretOffset = context.getCaretOffset();
        int lineNumber = _document.getLineNumber(_caretOffset);
        DocumentEx _document_1 = context.getDocument();
        int lineStartOffset = _document_1.getLineStartOffset(lineNumber);
        DocumentEx _document_2 = context.getDocument();
        String _text = _document_2.getText();
        int _caretOffset_1 = context.getCaretOffset();
        int textStartOffset = CharArrayUtil.shiftForward((CharSequence)_text, (int)lineStartOffset, (int)_caretOffset_1, (String)WHITESPACE_CHARACTERS);
        String _xifexpression = null;
        _xifexpression = textStartOffset > lineStartOffset ? context.getText(lineStartOffset, textStartOffset) : "";
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected boolean shouldIndent(@Extension AutoEditContext context) {
        TokenSet _stringLiteralTokens;
        int _caretOffset = context.getCaretOffset();
        TokenSet _tokenSet = context.getTokenSet(_caretOffset);
        return !Objects.equal((Object)_tokenSet, (Object)(_stringLiteralTokens = this.tokenSetProvider.getStringLiteralTokens()));
    }

    protected AutoEditBlockRegion findBlockRegion(final @Extension AutoEditContext context) {
        EditorEx _editor = context.getEditor();
        Iterable<AbstractIndentableAutoEditBlock> _blocks = this.getBlocks(_editor);
        Functions.Function1<AbstractIndentableAutoEditBlock, AutoEditBlockRegion> _function = new Functions.Function1<AbstractIndentableAutoEditBlock, AutoEditBlockRegion>(){

            public AutoEditBlockRegion apply(AbstractIndentableAutoEditBlock it) {
                return it.findRegion(context);
            }
        };
        Iterable _map = IterableExtensions.map(_blocks, (Functions.Function1)_function);
        Iterable _filterNull = IterableExtensions.filterNull((Iterable)_map);
        Functions.Function2<AutoEditBlockRegion, AutoEditBlockRegion, AutoEditBlockRegion> _function_1 = new Functions.Function2<AutoEditBlockRegion, AutoEditBlockRegion, AutoEditBlockRegion>(){

            public AutoEditBlockRegion apply(AutoEditBlockRegion $0, AutoEditBlockRegion $1) {
                TextRegion _openingTerminal_1;
                int _offset_1;
                AutoEditBlockRegion _xifexpression = null;
                TextRegion _openingTerminal = $0.getOpeningTerminal();
                int _offset = _openingTerminal.getOffset();
                boolean _lessThan = _offset < (_offset_1 = (_openingTerminal_1 = $1.getOpeningTerminal()).getOffset());
                _xifexpression = _lessThan ? $1 : $0;
                return _xifexpression;
            }
        };
        return (AutoEditBlockRegion)IterableExtensions.reduce((Iterable)_filterNull, (Functions.Function2)_function_1);
    }

    @Override
    public IdeaAutoEditHandler.Result beforeCharTyped(final char c, Project project, EditorEx editor, PsiFile file, FileType fileType) {
        final AutoEditContext context = new AutoEditContext(editor, this.tokenSetProvider);
        CodeInsightSettings _instance = CodeInsightSettings.getInstance();
        if (_instance.AUTOINSERT_PAIR_BRACKET) {
            Iterable<AbstractIndentableAutoEditBlock> _blocks = this.getBlocks(editor);
            Functions.Function1<AbstractIndentableAutoEditBlock, IdeaAutoEditHandler.Result> _function = new Functions.Function1<AbstractIndentableAutoEditBlock, IdeaAutoEditHandler.Result>(){

                public IdeaAutoEditHandler.Result apply(AbstractIndentableAutoEditBlock it) {
                    return DefaultAutoEditHandler.this.closeBlock(it, c, context);
                }
            };
            Iterable _map = IterableExtensions.map(_blocks, (Functions.Function1)_function);
            for (IdeaAutoEditHandler.Result result : _map) {
                if (!Objects.equal((Object)((Object)result), (Object)((Object)IdeaAutoEditHandler.Result.DEFAULT)) && !Objects.equal((Object)((Object)result), (Object)((Object)IdeaAutoEditHandler.Result.STOP))) continue;
                return result;
            }
        }
        CodeInsightSettings _instance_1 = CodeInsightSettings.getInstance();
        if (_instance_1.AUTOINSERT_PAIR_QUOTE) {
            Iterable<AbstractAutoEditBlock> _quotes = this.blockProvider.getQuotes();
            Functions.Function1<AbstractAutoEditBlock, IdeaAutoEditHandler.Result> _function_1 = new Functions.Function1<AbstractAutoEditBlock, IdeaAutoEditHandler.Result>(){

                public IdeaAutoEditHandler.Result apply(AbstractAutoEditBlock it) {
                    return DefaultAutoEditHandler.this.closeBlock(it, c, context);
                }
            };
            Iterable _map_1 = IterableExtensions.map(_quotes, (Functions.Function1)_function_1);
            for (IdeaAutoEditHandler.Result result_1 : _map_1) {
                if (!Objects.equal((Object)((Object)result_1), (Object)((Object)IdeaAutoEditHandler.Result.DEFAULT)) && !Objects.equal((Object)((Object)result_1), (Object)((Object)IdeaAutoEditHandler.Result.STOP))) continue;
                return result_1;
            }
        }
        CodeInsightSettings _instance_2 = CodeInsightSettings.getInstance();
        if (_instance_2.AUTOINSERT_PAIR_BRACKET) {
            Iterable<AbstractIndentableAutoEditBlock> _blocks_1 = this.getBlocks(editor);
            Functions.Function1<AbstractIndentableAutoEditBlock, IdeaAutoEditHandler.Result> _function_2 = new Functions.Function1<AbstractIndentableAutoEditBlock, IdeaAutoEditHandler.Result>(){

                public IdeaAutoEditHandler.Result apply(AbstractIndentableAutoEditBlock it) {
                    return DefaultAutoEditHandler.this.openBlock(it, c, context);
                }
            };
            Iterable _map_2 = IterableExtensions.map(_blocks_1, (Functions.Function1)_function_2);
            for (IdeaAutoEditHandler.Result result_2 : _map_2) {
                if (!Objects.equal((Object)((Object)result_2), (Object)((Object)IdeaAutoEditHandler.Result.DEFAULT)) && !Objects.equal((Object)((Object)result_2), (Object)((Object)IdeaAutoEditHandler.Result.STOP))) continue;
                return result_2;
            }
        }
        CodeInsightSettings _instance_3 = CodeInsightSettings.getInstance();
        if (_instance_3.AUTOINSERT_PAIR_QUOTE) {
            Iterable<AbstractAutoEditBlock> _quotes_1 = this.blockProvider.getQuotes();
            Functions.Function1<AbstractAutoEditBlock, IdeaAutoEditHandler.Result> _function_3 = new Functions.Function1<AbstractAutoEditBlock, IdeaAutoEditHandler.Result>(){

                public IdeaAutoEditHandler.Result apply(AbstractAutoEditBlock it) {
                    return DefaultAutoEditHandler.this.openBlock(it, c, context);
                }
            };
            Iterable _map_3 = IterableExtensions.map(_quotes_1, (Functions.Function1)_function_3);
            for (IdeaAutoEditHandler.Result result_3 : _map_3) {
                if (!Objects.equal((Object)((Object)result_3), (Object)((Object)IdeaAutoEditHandler.Result.DEFAULT)) && !Objects.equal((Object)((Object)result_3), (Object)((Object)IdeaAutoEditHandler.Result.STOP))) continue;
                return result_3;
            }
        }
        return super.beforeCharTyped(c, project, editor, file, fileType);
    }

    @Override
    public boolean charDeleted(final char c, PsiFile file, EditorEx editor) {
        final AutoEditContext context = new AutoEditContext(editor, this.tokenSetProvider);
        if (CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && IterableExtensions.exists(this.getBlocks(editor), (Functions.Function1)new Functions.Function1<AbstractIndentableAutoEditBlock, Boolean>(){

            public Boolean apply(AbstractIndentableAutoEditBlock it) {
                return it.delete(c, context);
            }
        })) {
            return true;
        }
        if (CodeInsightSettings.getInstance().AUTOINSERT_PAIR_QUOTE && IterableExtensions.exists(this.blockProvider.getQuotes(), (Functions.Function1)new Functions.Function1<AbstractAutoEditBlock, Boolean>(){

            public Boolean apply(AbstractAutoEditBlock it) {
                return it.delete(c, context);
            }
        })) {
            return true;
        }
        return super.charDeleted(c, file, editor);
    }

    protected IdeaAutoEditHandler.Result closeBlock(AbstractAutoEditBlock block, char c, AutoEditContext context) {
        boolean _close;
        String _closingTerminal = block.getClosingTerminal();
        boolean _isAtTerminal = this.isAtTerminal(_closingTerminal, c, context);
        if (_isAtTerminal && (_close = block.close(c, context))) {
            return IdeaAutoEditHandler.Result.STOP;
        }
        return IdeaAutoEditHandler.Result.CONTINUE;
    }

    protected IdeaAutoEditHandler.Result openBlock(AbstractAutoEditBlock block, char c, AutoEditContext context) {
        String _openingTerminal = block.getOpeningTerminal();
        boolean _isAtTerminal = this.isAtTerminal(_openingTerminal, c, context);
        if (_isAtTerminal) {
            block.open(c, context);
            return IdeaAutoEditHandler.Result.STOP;
        }
        return IdeaAutoEditHandler.Result.CONTINUE;
    }

    protected boolean isAtTerminal(String terminal, char c, @Extension AutoEditContext context) {
        boolean _equals_1;
        boolean _equals;
        boolean _xblockexpression = false;
        int _caretOffset = context.getCaretOffset();
        int _length = terminal.length();
        int _minus = _caretOffset - _length;
        int startOffset = _minus + 1;
        String _xifexpression = null;
        int _caretOffset_1 = context.getCaretOffset();
        boolean bl = _equals = startOffset == _caretOffset_1;
        if (_equals) {
            _xifexpression = "";
        } else {
            int _max = Math.max(0, startOffset);
            int _caretOffset_2 = context.getCaretOffset();
            _xifexpression = context.getText(_max, _caretOffset_2);
        }
        String startText = _xifexpression;
        int _caretOffset_3 = context.getCaretOffset();
        int _length_1 = terminal.length();
        int _plus = _caretOffset_3 + _length_1;
        int endOffset = _plus - 1;
        String _xifexpression_1 = null;
        int _caretOffset_4 = context.getCaretOffset();
        boolean bl2 = _equals_1 = endOffset == _caretOffset_4;
        if (_equals_1) {
            _xifexpression_1 = "";
        } else {
            int _caretOffset_5 = context.getCaretOffset();
            DocumentEx _document = context.getDocument();
            int _textLength = _document.getTextLength();
            int _min = Math.min(endOffset, _textLength);
            _xifexpression_1 = context.getText(_caretOffset_5, _min);
        }
        String endText = _xifexpression_1;
        String text = startText + Character.valueOf(c) + endText;
        int _lastIndexOf = text.lastIndexOf(terminal);
        _xblockexpression = _lastIndexOf != -1;
        return _xblockexpression;
    }
}

