/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.execution;

import com.google.inject.Inject;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.application.ApplicationConfigurationType;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationUtil;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.junit.JavaRunConfigurationProducerBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.psi.util.PsiTreeUtil;
import org.eclipse.xtext.idea.execution.ConfigurationProducerExtensions;
import org.eclipse.xtext.idea.lang.IXtextLanguage;
import org.eclipse.xtext.xbase.lib.Extension;
import org.jetbrains.annotations.Nullable;

public class TraceBasedApplicationConfigurationProducer
extends JavaRunConfigurationProducerBase<ApplicationConfiguration> {
    @Inject
    @Extension
    private ConfigurationProducerExtensions _configurationProducerExtensions;

    public TraceBasedApplicationConfigurationProducer(IXtextLanguage xtextLanguage) {
        super((ConfigurationType)ApplicationConfigurationType.getInstance());
        xtextLanguage.injectMembers((Object)this);
    }

    protected boolean setupConfigurationFromContext(ApplicationConfiguration conf, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        PsiElement javaElement = this._configurationProducerExtensions.tracedJavaElement(context);
        if (javaElement != null) {
            ConfigurationContext _prepareContextFor = this._configurationProducerExtensions.prepareContextFor(context, javaElement);
            return this.internalSetupConfigurationFromContext(conf, _prepareContextFor, sourceElement);
        }
        return false;
    }

    public boolean isConfigurationFromContext(ApplicationConfiguration appConf, ConfigurationContext context) {
        PsiElement javaElement = this._configurationProducerExtensions.tracedJavaElement(context);
        if (javaElement != null) {
            ConfigurationContext _prepareContextFor = this._configurationProducerExtensions.prepareContextFor(context, javaElement);
            return this.internalIsConfigurationFromContext(appConf, _prepareContextFor);
        }
        return false;
    }

    protected boolean internalSetupConfigurationFromContext(ApplicationConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        PsiClass aClass;
        boolean _not;
        Location contextLocation = context.getLocation();
        if (contextLocation == null) {
            return false;
        }
        Location location = JavaExecutionUtil.stepIntoSingleClass((Location)contextLocation);
        if (location == null) {
            return false;
        }
        PsiElement element = location.getPsiElement();
        boolean _isPhysical = element.isPhysical();
        boolean bl = _not = !_isPhysical;
        if (_not) {
            return false;
        }
        PsiElement currentElement = element;
        PsiMethod method = null;
        while ((method = TraceBasedApplicationConfigurationProducer.findMain(currentElement)) != null) {
            PsiElement _parent;
            aClass = method.getContainingClass();
            boolean _value = ConfigurationUtil.MAIN_CLASS.value((Object)aClass);
            if (_value) {
                sourceElement.set((Object)method);
                this.setupConfiguration(configuration, aClass, context);
                return true;
            }
            currentElement = _parent = method.getParent();
        }
        aClass = ApplicationConfigurationType.getMainClass((PsiElement)element);
        if (aClass == null) {
            return false;
        }
        sourceElement.set((Object)aClass);
        this.setupConfiguration(configuration, aClass, context);
        return true;
    }

    private void setupConfiguration(ApplicationConfiguration configuration, PsiClass aClass, ConfigurationContext context) {
        String _runtimeQualifiedName;
        configuration.MAIN_CLASS_NAME = _runtimeQualifiedName = JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)aClass);
        configuration.setGeneratedName();
        this.setupConfigurationModule(context, (ModuleBasedConfiguration)configuration);
    }

    @Nullable
    private static PsiMethod findMain(PsiElement element_finalParam_) {
        PsiElement element = element_finalParam_;
        PsiMethod method = null;
        while ((method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class)) != null) {
            PsiElement _parent;
            boolean _isMainMethod = PsiMethodUtil.isMainMethod((PsiMethod)method);
            if (_isMainMethod) {
                return method;
            }
            element = _parent = method.getParent();
        }
        return null;
    }

    public boolean internalIsConfigurationFromContext(ApplicationConfiguration appConfiguration, ConfigurationContext context) {
        PsiElement location = context.getPsiLocation();
        PsiClass aClass = ApplicationConfigurationType.getMainClass((PsiElement)location);
        if (aClass != null && Comparing.equal((String)JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)aClass), (String)appConfiguration.MAIN_CLASS_NAME)) {
            ConfigurationFactory _configurationFactory;
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)location, PsiMethod.class, (boolean)false);
            if (method != null && TestFrameworks.getInstance().isTestMethod(method)) {
                return false;
            }
            JavaRunConfigurationModule _configurationModule = (JavaRunConfigurationModule)appConfiguration.getConfigurationModule();
            Module configurationModule = _configurationModule.getModule();
            Module _module = context.getModule();
            boolean _equal = Comparing.equal((Object)_module, (Object)configurationModule);
            if (_equal) {
                return true;
            }
            RunManager _runManager = context.getRunManager();
            RunnerAndConfigurationSettings _configurationTemplate = _runManager.getConfigurationTemplate(_configurationFactory = this.getConfigurationFactory());
            RunConfiguration _configuration = _configurationTemplate.getConfiguration();
            ApplicationConfiguration template = (ApplicationConfiguration)_configuration;
            JavaRunConfigurationModule _configurationModule_1 = (JavaRunConfigurationModule)template.getConfigurationModule();
            Module predefinedModule = _configurationModule_1.getModule();
            boolean _equal_1 = Comparing.equal((Object)predefinedModule, (Object)configurationModule);
            if (_equal_1) {
                return true;
            }
        }
        return false;
    }
}

