/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.execution;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.intellij.execution.filters.ExceptionFilter;
import com.intellij.execution.filters.FileHyperlinkInfo;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.DocumentUtil;
import java.util.List;
import org.eclipse.xtext.idea.shared.IdeaSharedInjectorProvider;
import org.eclipse.xtext.idea.trace.IIdeaTrace;
import org.eclipse.xtext.idea.trace.ILocationInVirtualFile;
import org.eclipse.xtext.idea.trace.ITraceForVirtualFileProvider;
import org.eclipse.xtext.idea.trace.VirtualFileInProject;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class TraceBasedExceptionFilter
extends ExceptionFilter {
    @Inject
    private ITraceForVirtualFileProvider traceProvider;

    public TraceBasedExceptionFilter(GlobalSearchScope scope) {
        super(scope);
        IdeaSharedInjectorProvider.injectMembers((Object)this);
    }

    public Filter.Result applyFilter(String line, int textEndOffset) {
        Functions.Function1<Filter.ResultItem, Boolean> _function;
        Filter.Result result = super.applyFilter(line, textEndOffset);
        boolean _equals = Objects.equal((Object)result, null);
        if (_equals) {
            return null;
        }
        List _resultItems = result.getResultItems();
        Filter.ResultItem resultItem = (Filter.ResultItem)IterableExtensions.findFirst((Iterable)_resultItems, (Functions.Function1)(_function = new Functions.Function1<Filter.ResultItem, Boolean>(){

            public Boolean apply(Filter.ResultItem it) {
                HyperlinkInfo _hyperlinkInfo = it.getHyperlinkInfo();
                return !Objects.equal((Object)_hyperlinkInfo, null);
            }
        }));
        HyperlinkInfo hyperlinkInfo = resultItem.getHyperlinkInfo();
        if (hyperlinkInfo instanceof FileHyperlinkInfo) {
            Project _project;
            VirtualFile _file;
            VirtualFileInProject fileInProject;
            boolean _isGenerated;
            boolean _notEquals;
            final OpenFileDescriptor descriptor = ((FileHyperlinkInfo)hyperlinkInfo).getDescriptor();
            boolean bl = _notEquals = !Objects.equal((Object)descriptor, null);
            if (_notEquals && (_isGenerated = this.traceProvider.isGenerated(fileInProject = new VirtualFileInProject(_file = descriptor.getFile(), _project = descriptor.getProject())))) {
                IIdeaTrace trace = (IIdeaTrace)this.traceProvider.getTraceToSource(fileInProject);
                final RangeMarker rangeMarker = descriptor.getRangeMarker();
                if (!Objects.equal((Object)trace, null) && !Objects.equal((Object)rangeMarker, null)) {
                    boolean _notEquals_1;
                    Computable<Integer> _function_1;
                    Application _application = ApplicationManager.getApplication();
                    Integer nonSpaceCharOffset = (Integer)_application.runReadAction((Computable)(_function_1 = new Computable<Integer>(){

                        public Integer compute() {
                            int _xblockexpression = 0;
                            FileDocumentManager _instance = FileDocumentManager.getInstance();
                            VirtualFile _file = descriptor.getFile();
                            Document document = _instance.getDocument(_file);
                            int _startOffset = rangeMarker.getStartOffset();
                            int lineNumber = document.getLineNumber(_startOffset);
                            _xblockexpression = DocumentUtil.getFirstNonSpaceCharOffset((Document)document, (int)lineNumber);
                            return _xblockexpression;
                        }
                    }));
                    TextRegion _textRegion = new TextRegion(nonSpaceCharOffset.intValue(), 0);
                    ILocationInVirtualFile location = (ILocationInVirtualFile)trace.getBestAssociatedLocation((ITextRegion)_textRegion);
                    boolean bl2 = _notEquals_1 = !Objects.equal((Object)location, null);
                    if (_notEquals_1) {
                        VirtualFileInProject _platformResource = (VirtualFileInProject)location.getPlatformResource();
                        Project _project_1 = _platformResource.getProject();
                        VirtualFileInProject _platformResource_1 = (VirtualFileInProject)location.getPlatformResource();
                        VirtualFile _file_1 = _platformResource_1.getFile();
                        ITextRegionWithLineInformation _textRegion_1 = location.getTextRegion();
                        int _lineNumber = _textRegion_1.getLineNumber();
                        OpenFileDescriptor sourceFileDescriptor = new OpenFileDescriptor(_project_1, _file_1, _lineNumber, 0);
                        OpenFileHyperlinkInfo linkInfo = new OpenFileHyperlinkInfo(sourceFileDescriptor);
                        int _highlightStartOffset = resultItem.getHighlightStartOffset();
                        int _highlightEndOffset = resultItem.getHighlightEndOffset();
                        TextAttributes _highlightAttributes = resultItem.getHighlightAttributes();
                        return new Filter.Result(_highlightStartOffset, _highlightEndOffset, (HyperlinkInfo)linkInfo, _highlightAttributes);
                    }
                }
            }
        }
        return result;
    }
}

