/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.filesystem;

import com.google.common.base.Objects;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.idea.extensions.RootModelExtensions;
import org.eclipse.xtext.idea.filesystem.IdeaSourceFolder;
import org.eclipse.xtext.idea.filesystem.IdeaWorkspaceConfig;
import org.eclipse.xtext.util.UriUtil;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.IWorkspaceConfig;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
public class IdeaProjectConfig
implements IProjectConfig {
    private final Module module;
    private final VirtualFile contentRoot;

    public IdeaProjectConfig(Module module) {
        VirtualFile _head;
        this.module = module;
        ModuleRootManager _instance = ModuleRootManager.getInstance((Module)module);
        VirtualFile[] _contentRoots = _instance.getContentRoots();
        this.contentRoot = _head = (VirtualFile)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)_contentRoots)));
    }

    public IdeaSourceFolder findSourceFolderContaining(URI member) {
        String _string;
        VirtualFileManager _instance = VirtualFileManager.getInstance();
        VirtualFile file = _instance.findFileByUrl(_string = member.toString());
        boolean _equals = Objects.equal((Object)file, null);
        if (_equals) {
            return null;
        }
        Project _project = this.module.getProject();
        ProjectRootManager _instance_1 = ProjectRootManager.getInstance((Project)_project);
        ProjectFileIndex _fileIndex = _instance_1.getFileIndex();
        VirtualFile sourceRoot = _fileIndex.getSourceRootForFile(file);
        boolean _equals_1 = Objects.equal((Object)sourceRoot, null);
        if (_equals_1) {
            return null;
        }
        SourceFolder sourceFolder = ProjectRootsUtil.findSourceFolder((Module)this.module, (VirtualFile)sourceRoot);
        if (Objects.equal((Object)sourceFolder, null) || !Objects.equal((Object)sourceFolder.getContentEntry().getFile(), (Object)this.contentRoot)) {
            return null;
        }
        return new IdeaSourceFolder(sourceFolder);
    }

    public String getName() {
        return this.module.getName();
    }

    public URI getPath() {
        String _url = this.contentRoot.getUrl();
        URI _createURI = URI.createURI((String)_url);
        return UriUtil.toFolderURI((URI)_createURI);
    }

    public Set<? extends IdeaSourceFolder> getSourceFolders() {
        Iterable<SourceFolder> _existingSourceFolders = RootModelExtensions.getExistingSourceFolders(this.module);
        Functions.Function1<SourceFolder, Boolean> _function = new Functions.Function1<SourceFolder, Boolean>(){

            public Boolean apply(SourceFolder it) {
                return Objects.equal((Object)it.getFile(), (Object)IdeaProjectConfig.this.contentRoot) || VfsUtil.isAncestor((VirtualFile)IdeaProjectConfig.this.contentRoot, (VirtualFile)it.getFile(), (boolean)false);
            }
        };
        Iterable _filter = IterableExtensions.filter(_existingSourceFolders, (Functions.Function1)_function);
        Functions.Function1<SourceFolder, IdeaSourceFolder> _function_1 = new Functions.Function1<SourceFolder, IdeaSourceFolder>(){

            public IdeaSourceFolder apply(SourceFolder sourceFolder) {
                return new IdeaSourceFolder(sourceFolder);
            }
        };
        Iterable _map = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
        return IterableExtensions.toSet((Iterable)_map);
    }

    public IWorkspaceConfig getWorkspaceConfig() {
        Project _project = this.module.getProject();
        return new IdeaWorkspaceConfig(_project);
    }

    @Pure
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.module == null ? 0 : this.module.hashCode());
        result = 31 * result + (this.contentRoot == null ? 0 : this.contentRoot.hashCode());
        return result;
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IdeaProjectConfig other = (IdeaProjectConfig)obj;
        if (this.module == null ? other.module != null : !this.module.equals(other.module)) {
            return false;
        }
        return !(this.contentRoot == null ? other.contentRoot != null : !this.contentRoot.equals(other.contentRoot));
    }

    @Pure
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("module", (Object)this.module);
        b.add("contentRoot", (Object)this.contentRoot);
        return b.toString();
    }

    @Pure
    public Module getModule() {
        return this.module;
    }

    @Pure
    public VirtualFile getContentRoot() {
        return this.contentRoot;
    }
}

