/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.findusages;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.xtext.idea.findusages.GeneratedSourceAwareFindUsagesHandler;
import org.eclipse.xtext.idea.shared.IdeaSharedInjectorProvider;
import org.eclipse.xtext.idea.trace.ITraceForVirtualFileProvider;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class GeneratedSourceAwareUsagesHandlerFactory
extends FindUsagesHandlerFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.find.findParameterUsages.FindUsagesManager");
    @Inject
    private ITraceForVirtualFileProvider traceProvider;

    public GeneratedSourceAwareUsagesHandlerFactory() {
        IdeaSharedInjectorProvider.injectMembers((Object)this);
    }

    public boolean canFindUsages(PsiElement element) {
        FindUsagesHandlerFactory[] delegates;
        Project _project = element.getProject();
        for (FindUsagesHandlerFactory delegate : delegates = (FindUsagesHandlerFactory[])Extensions.getExtensions((ExtensionPointName)FindUsagesHandlerFactory.EP_NAME, (AreaInstance)_project)) {
            if (delegate == this) continue;
            try {
                boolean _canFindUsages = delegate.canFindUsages(element);
                if (!_canFindUsages) continue;
                return true;
            }
            catch (Throwable _t) {
                if (_t instanceof IndexNotReadyException) {
                    IndexNotReadyException e = (IndexNotReadyException)_t;
                    throw e;
                }
                if (_t instanceof ProcessCanceledException) {
                    ProcessCanceledException e_1 = (ProcessCanceledException)_t;
                    throw e_1;
                }
                if (_t instanceof Exception) {
                    Exception e_2 = (Exception)_t;
                    LOG.error((Throwable)e_2);
                    continue;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        return false;
    }

    public FindUsagesHandler createFindUsagesHandler(PsiElement element, boolean forHighlightUsages) {
        if (forHighlightUsages) {
            return null;
        }
        FindUsagesHandler primaryHandler = this.delegateFindUsagesHandler(element);
        boolean _isNullHandler = this.isNullHandler(primaryHandler);
        if (_isNullHandler) {
            return null;
        }
        Iterable<FindUsagesHandler> secondaryHandlers = this.getSecondaryHandlers(element);
        boolean _isEmpty = IterableExtensions.isEmpty(secondaryHandlers);
        if (_isEmpty) {
            return primaryHandler;
        }
        return new GeneratedSourceAwareFindUsagesHandler(primaryHandler, secondaryHandlers);
    }

    protected Iterable<FindUsagesHandler> getSecondaryHandlers(PsiElement element) {
        List<? extends PsiElement> _secondaryElements = this.getSecondaryElements(element);
        Functions.Function1<PsiElement, FindUsagesHandler> _function = new Functions.Function1<PsiElement, FindUsagesHandler>(){

            public FindUsagesHandler apply(PsiElement it) {
                return GeneratedSourceAwareUsagesHandlerFactory.this.delegateFindUsagesHandler(it);
            }
        };
        List _map = ListExtensions.map(_secondaryElements, (Functions.Function1)_function);
        Functions.Function1<FindUsagesHandler, Boolean> _function_1 = new Functions.Function1<FindUsagesHandler, Boolean>(){

            public Boolean apply(FindUsagesHandler it) {
                boolean _isNullHandler = GeneratedSourceAwareUsagesHandlerFactory.this.isNullHandler(it);
                return !_isNullHandler;
            }
        };
        return IterableExtensions.filter((Iterable)_map, (Functions.Function1)_function_1);
    }

    protected List<? extends PsiElement> getSecondaryElements(PsiElement element) {
        boolean _not;
        List<? extends PsiElement> generatedElements = this.getGeneratedElements(element);
        boolean _isEmpty = generatedElements.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            return generatedElements;
        }
        return this.getOriginalElements(element);
    }

    protected List<? extends PsiElement> getOriginalElements(PsiElement element) {
        if (element instanceof PsiNameIdentifierOwner) {
            PsiElement _nameIdentifier = ((PsiNameIdentifierOwner)element).getNameIdentifier();
            return this.getOriginalElements(_nameIdentifier);
        }
        List<? extends PsiElement> _originalElements = this.traceProvider.getOriginalElements(element);
        Functions.Function1<PsiElement, PsiNamedElement> _function = new Functions.Function1<PsiElement, PsiNamedElement>(){

            public PsiNamedElement apply(PsiElement it) {
                return (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)it, PsiNamedElement.class, (boolean)false);
            }
        };
        List _map = ListExtensions.map(_originalElements, (Functions.Function1)_function);
        Iterable _filterNull = IterableExtensions.filterNull((Iterable)_map);
        Set _set = IterableExtensions.toSet((Iterable)_filterNull);
        List result = IterableExtensions.toList((Iterable)_set);
        return result;
    }

    protected List<? extends PsiElement> getGeneratedElements(PsiElement element) {
        if (element instanceof PsiNameIdentifierOwner) {
            PsiElement nameIdentifier = ((PsiNameIdentifierOwner)element).getNameIdentifier();
            if (nameIdentifier == null) {
                return Collections.emptyList();
            }
            return this.getGeneratedElements(nameIdentifier);
        }
        ArrayList result = CollectionLiterals.newArrayList((Object[])new PsiNamedElement[0]);
        List<? extends PsiElement> _generatedElements = this.traceProvider.getGeneratedElements(element);
        for (PsiElement psiElement : _generatedElements) {
            PsiNamedElement parent = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiNamedElement.class, (boolean)false);
            if (Objects.equal((Object)parent, null) || result.contains(parent)) continue;
            result.add(parent);
        }
        return result;
    }

    protected boolean isNullHandler(FindUsagesHandler handler) {
        return handler == null || handler == FindUsagesHandler.NULL_HANDLER;
    }

    protected FindUsagesHandler delegateFindUsagesHandler(PsiElement element) {
        FindUsagesHandlerFactory[] delegates;
        Project _project = element.getProject();
        for (FindUsagesHandlerFactory delegate : delegates = (FindUsagesHandlerFactory[])Extensions.getExtensions((ExtensionPointName)FindUsagesHandlerFactory.EP_NAME, (AreaInstance)_project)) {
            if (delegate == this) continue;
            try {
                FindUsagesHandler handler;
                boolean _canFindUsages = delegate.canFindUsages(element);
                if (!_canFindUsages || (handler = delegate.createFindUsagesHandler(element, false)) == null) continue;
                return handler;
            }
            catch (Throwable _t) {
                if (_t instanceof IndexNotReadyException) {
                    IndexNotReadyException e = (IndexNotReadyException)_t;
                    throw e;
                }
                if (_t instanceof ProcessCanceledException) {
                    ProcessCanceledException e_1 = (ProcessCanceledException)_t;
                    throw e_1;
                }
                if (_t instanceof Exception) {
                    Exception e_2 = (Exception)_t;
                    LOG.error((Throwable)e_2);
                    continue;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        return null;
    }
}

