/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.formatting;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.ide.editor.bracketmatching.BracePair;
import org.eclipse.xtext.ide.editor.bracketmatching.IBracePairProvider;
import org.eclipse.xtext.idea.formatting.ModifiableBlock;
import org.eclipse.xtext.psi.tree.IGrammarAwareElementType;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class BlockExtension {
    @Inject
    private IBracePairProvider bracePairProvider;
    public static final Indent STRUCTURAL_INDENT = Indent.getIndent((Indent.Type)Indent.Type.NORMAL, (boolean)false, (boolean)true);

    public Block getParentBlock(Block block) {
        Block _xifexpression = null;
        if (block instanceof ModifiableBlock) {
            _xifexpression = ((ModifiableBlock)block).getParentBlock();
        }
        return _xifexpression;
    }

    public ASTNode getNode(Block block) {
        ASTNode _xifexpression = null;
        if (block instanceof ASTBlock) {
            _xifexpression = ((ASTBlock)block).getNode();
        }
        return _xifexpression;
    }

    public IElementType getElementType(Block block) {
        ASTNode _node = this.getNode(block);
        IElementType _elementType = null;
        if (_node != null) {
            _elementType = _node.getElementType();
        }
        return _elementType;
    }

    public EObject getGrammarElement(Block block) {
        EObject _xblockexpression = null;
        IElementType elementType = this.getElementType(block);
        EObject _xifexpression = null;
        if (elementType instanceof IGrammarAwareElementType) {
            _xifexpression = ((IGrammarAwareElementType)elementType).getGrammarElement();
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public boolean isOpening(Block block) {
        boolean _xifexpression = false;
        if (block instanceof ASTBlock) {
            ASTNode _node = ((ASTBlock)block).getNode();
            _xifexpression = this.isOpening(_node);
        }
        return _xifexpression;
    }

    public boolean isClosing(Block block) {
        boolean _xifexpression = false;
        if (block instanceof ASTBlock) {
            ASTNode _node = ((ASTBlock)block).getNode();
            _xifexpression = this.isClosing(_node);
        }
        return _xifexpression;
    }

    public boolean isOpening(ASTNode node) {
        boolean _xblockexpression = false;
        boolean _equals = Objects.equal((Object)node, null);
        if (_equals) {
            return false;
        }
        final String text = node.getText();
        Set<BracePair> _bracePairs = this.getBracePairs();
        Functions.Function1<BracePair, Boolean> _function = new Functions.Function1<BracePair, Boolean>(){

            public Boolean apply(BracePair it) {
                String _leftBrace = it.getLeftBrace();
                return Objects.equal((Object)text, (Object)_leftBrace);
            }
        };
        _xblockexpression = IterableExtensions.exists(_bracePairs, (Functions.Function1)_function);
        return _xblockexpression;
    }

    public boolean isClosing(ASTNode node) {
        boolean _xblockexpression = false;
        boolean _equals = Objects.equal((Object)node, null);
        if (_equals) {
            return false;
        }
        final String text = node.getText();
        Set<BracePair> _bracePairs = this.getBracePairs();
        Functions.Function1<BracePair, Boolean> _function = new Functions.Function1<BracePair, Boolean>(){

            public Boolean apply(BracePair it) {
                String _rightBrace = it.getRightBrace();
                return Objects.equal((Object)text, (Object)_rightBrace);
            }
        };
        _xblockexpression = IterableExtensions.exists(_bracePairs, (Functions.Function1)_function);
        return _xblockexpression;
    }

    public BracePair getBracePairForOpeningBrace(Block block) {
        ASTNode _node = this.getNode(block);
        return this.getBracePairForOpeningNode(_node);
    }

    public BracePair getBracePairForOpeningNode(ASTNode node) {
        BracePair _xblockexpression = null;
        boolean _equals = Objects.equal((Object)node, null);
        if (_equals) {
            return null;
        }
        final String openingBrace = node.getText();
        Set<BracePair> _bracePairs = this.getBracePairs();
        Functions.Function1<BracePair, Boolean> _function = new Functions.Function1<BracePair, Boolean>(){

            public Boolean apply(BracePair it) {
                String _leftBrace = it.getLeftBrace();
                return Objects.equal((Object)_leftBrace, (Object)openingBrace);
            }
        };
        _xblockexpression = (BracePair)IterableExtensions.findFirst(_bracePairs, (Functions.Function1)_function);
        return _xblockexpression;
    }

    public BracePair getBracePairForClosingBrace(Block block) {
        ASTNode _node = this.getNode(block);
        return this.getBracePairForClosingNode(_node);
    }

    public BracePair getBracePairForClosingNode(ASTNode node) {
        BracePair _xblockexpression = null;
        boolean _equals = Objects.equal((Object)node, null);
        if (_equals) {
            return null;
        }
        final String openingBrace = node.getText();
        Set<BracePair> _bracePairs = this.getBracePairs();
        Functions.Function1<BracePair, Boolean> _function = new Functions.Function1<BracePair, Boolean>(){

            public Boolean apply(BracePair it) {
                String _rightBrace = it.getRightBrace();
                return Objects.equal((Object)_rightBrace, (Object)openingBrace);
            }
        };
        _xblockexpression = (BracePair)IterableExtensions.findFirst(_bracePairs, (Functions.Function1)_function);
        return _xblockexpression;
    }

    public boolean isStructural(Block block) {
        int _startOffset_1;
        TextRange _textRange;
        int _startOffset;
        int offset;
        boolean _xblockexpression = false;
        ASTNode node = this.getNode(block);
        ASTNode leafElement = node.findLeafElementAt(offset = (_startOffset = (_textRange = block.getTextRange()).getStartOffset()) - (_startOffset_1 = node.getStartOffset()));
        BracePair bracePair = this.getBracePairForOpeningNode(leafElement);
        _xblockexpression = !Objects.equal((Object)bracePair, null) && bracePair.isStructural();
        return _xblockexpression;
    }

    public Set<BracePair> getBracePairs() {
        return this.bracePairProvider.getPairs();
    }

    public Indent getIndent(BracePair bracePair, boolean enforceIndentToChildren) {
        boolean _equals = Objects.equal((Object)bracePair, null);
        if (_equals) {
            return Indent.getNoneIndent();
        }
        boolean _isStructural = bracePair.isStructural();
        if (_isStructural) {
            if (enforceIndentToChildren) {
                return STRUCTURAL_INDENT;
            }
            return Indent.getNormalIndent();
        }
        return Indent.getContinuationIndent();
    }
}

