/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.formatting;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.idea.formatting.BlockExtension;
import org.eclipse.xtext.idea.formatting.BlockFactory;
import org.eclipse.xtext.idea.formatting.DefaultXtextBlock;
import org.eclipse.xtext.idea.formatting.ModifiableBlock;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;

@Singleton
public class DefaultBlockFactory
implements BlockFactory {
    private static final char LINE_FEED = '\n';
    @Inject
    private Injector injector;
    @Inject
    @Extension
    private BlockExtension _blockExtension;

    @Override
    public Block createRootBlock(PsiElement element, CodeStyleSettings settings) {
        DefaultXtextBlock _xblockexpression = null;
        ASTNode _node = element.getNode();
        DefaultXtextBlock block = new DefaultXtextBlock(_node, null, null);
        this.injector.injectMembers((Object)block);
        Language _language = element.getLanguage();
        SpacingBuilder _createSpacingBuilder = this.createSpacingBuilder(settings, _language);
        block.setSpacingBuilder(_createSpacingBuilder);
        _xblockexpression = block;
        return _xblockexpression;
    }

    protected SpacingBuilder createSpacingBuilder(CodeStyleSettings settings, Language language) {
        return null;
    }

    @Override
    public DefaultXtextBlock createBlock(ASTNode node, Block parentBlock) {
        DefaultXtextBlock _xblockexpression = null;
        boolean _isWhitespaceOrEmpty = FormatterUtil.isWhitespaceOrEmpty((ASTNode)node);
        if (_isWhitespaceOrEmpty) {
            return null;
        }
        TextRange blockTextRange = this.createTextRange(node);
        if (Objects.equal((Object)blockTextRange, null) || blockTextRange.isEmpty() || !parentBlock.getTextRange().contains(blockTextRange)) {
            return null;
        }
        SpacingBuilder _xifexpression = null;
        if (parentBlock instanceof ModifiableBlock) {
            _xifexpression = ((ModifiableBlock)parentBlock).getSpacingBuilder();
        }
        SpacingBuilder spacingBuilder = _xifexpression;
        DefaultXtextBlock block = new DefaultXtextBlock(node, null, null);
        this.injector.injectMembers((Object)block);
        block.setTextRange(blockTextRange);
        block.setSpacingBuilder(spacingBuilder);
        block.setParentBlock(parentBlock);
        Indent _childIndent = this.getChildIndent(parentBlock, block);
        block.setIndent(_childIndent);
        _xblockexpression = block;
        return _xblockexpression;
    }

    protected Indent getChildIndent(Block parentBlock, DefaultXtextBlock childBlock) {
        if (this._blockExtension.isOpening(childBlock) || this._blockExtension.isClosing(childBlock)) {
            return Indent.getNoneIndent();
        }
        EObject grammarElement = this._blockExtension.getGrammarElement(parentBlock);
        boolean _isContinuation = this.isContinuation(grammarElement);
        if (_isContinuation) {
            return Indent.getContinuationWithoutFirstIndent();
        }
        boolean _isStructural = this.isStructural(grammarElement);
        if (_isStructural) {
            boolean _isStructural_1 = this._blockExtension.isStructural(childBlock);
            if (_isStructural_1) {
                return Indent.getNoneIndent();
            }
            return Indent.getNormalIndent();
        }
        return Indent.getNoneIndent();
    }

    protected boolean isContinuation(EObject grammarElement) {
        return false;
    }

    protected boolean isStructural(EObject grammarElement) {
        return false;
    }

    protected TextRange createTextRange(ASTNode node) {
        Functions.Function1<ASTNode, Boolean> _function_1;
        Functions.Function1<ASTNode, ASTNode> _function;
        TextRange _xblockexpression = null;
        final TextRange textRange = node.getTextRange();
        if (node instanceof PsiComment) {
            boolean _equals;
            int _length;
            int _minus;
            CharSequence chars = node.getChars();
            char _charAt = chars.charAt(_minus = (_length = chars.length()) - 1);
            boolean bl = _equals = _charAt == '\n';
            if (_equals) {
                int _startOffset = textRange.getStartOffset();
                int _endOffset = textRange.getEndOffset();
                int _minus_1 = _endOffset - 1;
                return new TextRange(_startOffset, _minus_1);
            }
            return textRange;
        }
        ASTNode _firstChildNode = node.getFirstChildNode();
        boolean _equals_1 = Objects.equal((Object)_firstChildNode, null);
        if (_equals_1) {
            return textRange;
        }
        LeafElement _findFirstLeaf = TreeUtil.findFirstLeaf((ASTNode)node);
        ASTNode firstNonHiddenLeafNode = this.findNode((ASTNode)_findFirstLeaf, (Functions.Function1<? super ASTNode, ? extends ASTNode>)(_function = new Functions.Function1<ASTNode, ASTNode>(){

            public ASTNode apply(ASTNode it) {
                return TreeUtil.nextLeaf((ASTNode)it);
            }
        }), (Functions.Function1<? super ASTNode, ? extends Boolean>)(_function_1 = new Functions.Function1<ASTNode, Boolean>(){

            public Boolean apply(ASTNode it) {
                return !FormatterUtil.isWhitespaceOrEmpty((ASTNode)it) || !textRange.contains(it.getTextRange());
            }
        }));
        if (Objects.equal((Object)firstNonHiddenLeafNode, null) || !textRange.contains(firstNonHiddenLeafNode.getTextRange())) {
            return null;
        }
        int startOffset = firstNonHiddenLeafNode.getStartOffset();
        ASTNode _findLastLeaf = TreeUtil.findLastLeaf((ASTNode)node);
        Functions.Function1<ASTNode, ASTNode> _function_2 = new Functions.Function1<ASTNode, ASTNode>(){

            public ASTNode apply(ASTNode it) {
                return TreeUtil.prevLeaf((ASTNode)it);
            }
        };
        Functions.Function1<ASTNode, Boolean> _function_3 = new Functions.Function1<ASTNode, Boolean>(){

            public Boolean apply(ASTNode it) {
                boolean _isWhitespaceOrEmpty = FormatterUtil.isWhitespaceOrEmpty((ASTNode)it);
                return !_isWhitespaceOrEmpty;
            }
        };
        ASTNode _findNode = this.findNode(_findLastLeaf, (Functions.Function1<? super ASTNode, ? extends ASTNode>)_function_2, (Functions.Function1<? super ASTNode, ? extends Boolean>)_function_3);
        TextRange _textRange = _findNode.getTextRange();
        int endOffset = _textRange.getEndOffset();
        _xblockexpression = new TextRange(startOffset, endOffset);
        return _xblockexpression;
    }

    protected ASTNode findNode(ASTNode node, Functions.Function1<? super ASTNode, ? extends ASTNode> provider, Functions.Function1<? super ASTNode, ? extends Boolean> condition) {
        boolean _equals = Objects.equal((Object)node, null);
        if (_equals) {
            return null;
        }
        Boolean _apply = (Boolean)condition.apply((Object)node);
        if (_apply.booleanValue()) {
            return node;
        }
        ASTNode _apply_1 = (ASTNode)provider.apply((Object)node);
        return this.findNode(_apply_1, provider, condition);
    }
}

