/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.formatting;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedListMultimap;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.TokenType;
import com.intellij.psi.formatter.common.AbstractBlock;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.ide.editor.bracketmatching.BracePair;
import org.eclipse.xtext.idea.formatting.BlockExtension;
import org.eclipse.xtext.idea.formatting.BlockFactory;
import org.eclipse.xtext.idea.formatting.ChildAttributesProvider;
import org.eclipse.xtext.idea.formatting.ModifiableBlock;
import org.eclipse.xtext.idea.formatting.SyntheticXtextBlock;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

public class DefaultXtextBlock
extends AbstractBlock
implements ModifiableBlock {
    @Accessors
    private Block parentBlock;
    @Accessors
    private Boolean incomplete;
    @Accessors
    private TextRange textRange;
    @Accessors
    private Indent indent = Indent.getNoneIndent();
    @Accessors
    private SpacingBuilder spacingBuilder;
    @Inject
    private Injector injector;
    @Inject
    @Extension
    private BlockFactory _blockFactory;
    @Inject
    @Extension
    private BlockExtension _blockExtension;
    @Inject
    private ChildAttributesProvider childAttributesProvider;

    public DefaultXtextBlock(ASTNode node, Wrap wrap, Alignment alignment) {
        super(node, wrap, alignment);
    }

    public boolean isIncomplete() {
        boolean _notEquals;
        boolean bl = _notEquals = !Objects.equal((Object)this.incomplete, null);
        if (_notEquals) {
            return this.incomplete;
        }
        return super.isIncomplete();
    }

    public TextRange getTextRange() {
        boolean _notEquals;
        boolean bl = _notEquals = !Objects.equal((Object)this.textRange, null);
        if (_notEquals) {
            return this.textRange;
        }
        return super.getTextRange();
    }

    protected List<Block> buildChildren() {
        ASTNode[] _children = this.myNode.getChildren(null);
        Functions.Function1<ASTNode, Block> _function = new Functions.Function1<ASTNode, Block>(){

            public Block apply(ASTNode it) {
                return DefaultXtextBlock.this._blockFactory.createBlock(it, DefaultXtextBlock.this);
            }
        };
        List _map = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)_children)), (Functions.Function1)_function);
        Iterable _filterNull = IterableExtensions.filterNull((Iterable)_map);
        return this.group(_filterNull);
    }

    protected List<Block> group(Iterable<Block> blocks) {
        LinkedList _xblockexpression = null;
        LinkedListMultimap openingBlockIndex = LinkedListMultimap.create();
        LinkedList stack = CollectionLiterals.newLinkedList((Object[])new Block[0]);
        for (Block block : blocks) {
            boolean _isClosing;
            boolean _isOpening = this._blockExtension.isOpening(block);
            if (_isOpening) {
                BracePair bracePair = this._blockExtension.getBracePairForOpeningBrace(block);
                int _size = stack.size();
                openingBlockIndex.put((Object)bracePair, (Object)_size);
            }
            if (_isClosing = this._blockExtension.isClosing(block)) {
                boolean _notEquals;
                BracePair bracePair_1 = this._blockExtension.getBracePairForClosingBrace(block);
                List _get = openingBlockIndex.get((Object)bracePair_1);
                Integer index = (Integer)IterableExtensions.last((Iterable)_get);
                boolean bl = _notEquals = !Objects.equal((Object)index, null);
                if (_notEquals) {
                    openingBlockIndex.remove((Object)bracePair_1, (Object)index);
                    this.group(stack, index, bracePair_1, block);
                }
            }
            stack.addLast(block);
        }
        List _entries = openingBlockIndex.entries();
        Comparator<Map.Entry<BracePair, Integer>> _function = new Comparator<Map.Entry<BracePair, Integer>>(){

            @Override
            public int compare(Map.Entry<BracePair, Integer> $0, Map.Entry<BracePair, Integer> $1) {
                Integer _value = $0.getValue();
                Integer _value_1 = $1.getValue();
                return _value.compareTo(_value_1);
            }
        };
        List _sortWith = IterableExtensions.sortWith((Iterable)_entries, (Comparator)_function);
        List _reverse = ListExtensions.reverse((List)_sortWith);
        for (Map.Entry entry : _reverse) {
            Integer _value = (Integer)entry.getValue();
            BracePair _key = (BracePair)entry.getKey();
            this.group(stack, _value, _key, null);
        }
        _xblockexpression = stack;
        return _xblockexpression;
    }

    protected void group(LinkedList<Block> stack, Integer openingBlockIndex, BracePair bracePair, Block closingBlock) {
        List<Block> children = this.collectChildren(stack, openingBlockIndex);
        boolean _isEmpty = children.isEmpty();
        if (_isEmpty) {
            return;
        }
        final SyntheticXtextBlock groupBlock = this.createGroup(children);
        groupBlock.setIncomplete(Objects.equal((Object)closingBlock, null) || Objects.equal((Object)this._blockExtension.getElementType(closingBlock), (Object)TokenType.ERROR_ELEMENT));
        boolean enforceIndentToChildren = this.shouldEnforceIndentToChildren(children);
        Indent _indent = this._blockExtension.getIndent(bracePair, enforceIndentToChildren);
        groupBlock.setIndent(_indent);
        Iterable _filter = Iterables.filter(children, ModifiableBlock.class);
        ModifiableBlock _head = (ModifiableBlock)IterableExtensions.head((Iterable)_filter);
        Block _parentBlock = _head.getParentBlock();
        groupBlock.setParentBlock(_parentBlock);
        Iterable _filter_1 = Iterables.filter(children, ModifiableBlock.class);
        Procedures.Procedure1<ModifiableBlock> _function = new Procedures.Procedure1<ModifiableBlock>(){

            public void apply(ModifiableBlock child) {
                child.setParentBlock(groupBlock);
            }
        };
        IterableExtensions.forEach((Iterable)_filter_1, (Procedures.Procedure1)_function);
        stack.addLast(groupBlock);
    }

    protected List<Block> collectChildren(LinkedList<Block> stack, Integer openingBlockIndex) {
        LinkedList _xblockexpression = null;
        LinkedList children = CollectionLiterals.newLinkedList((Object[])new Block[0]);
        for (int i = stack.size() - 1; i > openingBlockIndex; --i) {
            Block childBlock = stack.removeLast();
            children.addFirst(childBlock);
        }
        _xblockexpression = children;
        return _xblockexpression;
    }

    protected boolean shouldEnforceIndentToChildren(List<Block> children) {
        boolean _greaterThan;
        int _size = children.size();
        boolean bl = _greaterThan = _size > 3;
        if (_greaterThan) {
            return true;
        }
        Block _head = (Block)IterableExtensions.head(children);
        BracePair bracePair = this._blockExtension.getBracePairForOpeningBrace(_head);
        if (Objects.equal((Object)bracePair, null) || !bracePair.isStructural()) {
            return true;
        }
        Block _last = (Block)IterableExtensions.last(children);
        BracePair _bracePairForClosingBrace = this._blockExtension.getBracePairForClosingBrace(_last);
        return !Objects.equal((Object)_bracePairForClosingBrace, (Object)bracePair);
    }

    protected SyntheticXtextBlock createGroup(Iterable<Block> children) {
        SyntheticXtextBlock _xblockexpression = null;
        SyntheticXtextBlock groupBlock = new SyntheticXtextBlock();
        this.injector.injectMembers((Object)groupBlock);
        groupBlock.setSpacingBuilder(this.spacingBuilder);
        List<Block> _children = groupBlock.getChildren();
        Iterables.addAll(_children, children);
        _xblockexpression = groupBlock;
        return _xblockexpression;
    }

    public ChildAttributes getChildAttributes(int newChildIndex) {
        return this.childAttributesProvider.getChildAttributes(this, newChildIndex);
    }

    public boolean isLeaf() {
        ASTNode _firstChildNode = this.myNode.getFirstChildNode();
        return Objects.equal((Object)_firstChildNode, null);
    }

    public Spacing getSpacing(Block child1, Block child2) {
        Spacing _spacing = null;
        if (this.spacingBuilder != null) {
            _spacing = this.spacingBuilder.getSpacing((Block)this, child1, child2);
        }
        return _spacing;
    }

    @Override
    @Pure
    public Block getParentBlock() {
        return this.parentBlock;
    }

    @Override
    public void setParentBlock(Block parentBlock) {
        this.parentBlock = parentBlock;
    }

    @Pure
    public Boolean getIncomplete() {
        return this.incomplete;
    }

    @Override
    public void setIncomplete(Boolean incomplete) {
        this.incomplete = incomplete;
    }

    public void setTextRange(TextRange textRange) {
        this.textRange = textRange;
    }

    @Pure
    public Indent getIndent() {
        return this.indent;
    }

    @Override
    public void setIndent(Indent indent) {
        this.indent = indent;
    }

    @Override
    @Pure
    public SpacingBuilder getSpacingBuilder() {
        return this.spacingBuilder;
    }

    @Override
    public void setSpacingBuilder(SpacingBuilder spacingBuilder) {
        this.spacingBuilder = spacingBuilder;
    }
}

