/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.highlighting;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.eclipse.xtext.ide.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.ide.editor.syntaxcoloring.ISemanticHighlightingCalculator;
import org.eclipse.xtext.idea.highlighting.IdeaHighlightingAttributesProvider;
import org.eclipse.xtext.idea.util.CancelProgressIndicator;
import org.eclipse.xtext.psi.XtextPsiUtils;
import org.eclipse.xtext.psi.impl.BaseXtextFile;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.service.OperationCanceledError;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public abstract class SemanticHighlightVisitor
implements HighlightVisitor {
    @Inject
    @Named(value="languageName")
    private String languageId;
    @Inject
    private ISemanticHighlightingCalculator highlightCalculator;
    @Inject
    @Extension
    private IdeaHighlightingAttributesProvider _ideaHighlightingAttributesProvider;
    @Inject
    private OperationCanceledManager operationCanceledManager;
    private IHighlightedPositionAcceptor acceptor;
    private volatile long lastRun;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean analyze(PsiFile file, boolean updateWholeFile, final HighlightInfoHolder holder, Runnable action) {
        boolean _not;
        VirtualFile virtualFile = XtextPsiUtils.findVirtualFile((PsiElement)file);
        Project _project = file.getProject();
        FileEditorManager _instance = FileEditorManager.getInstance((Project)_project);
        boolean _isFileOpen = _instance.isFileOpen(virtualFile);
        boolean bl = _not = !_isFileOpen;
        if (_not) {
            return true;
        }
        try {
            IHighlightedPositionAcceptor _function;
            this.acceptor = _function = new IHighlightedPositionAcceptor(){

                public void addPosition(final int offset, final int length, String[] styles) {
                    ProgressIndicatorProvider.checkCanceled();
                    if (length > 0) {
                        Procedures.Procedure1<String> _function = new Procedures.Procedure1<String>(){

                            public void apply(String it) {
                                HighlightInfoType _highlightInfoType = SemanticHighlightVisitor.this._ideaHighlightingAttributesProvider.getHighlightInfoType(it);
                                HighlightInfo.Builder _newHighlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)_highlightInfoType);
                                HighlightInfo.Builder _range = _newHighlightInfo.range(offset, offset + length);
                                HighlightInfo.Builder _description = _range.description(it);
                                HighlightInfo info = _description.create();
                                holder.add(info);
                            }
                        };
                        IterableExtensions.forEach((Iterable)((Iterable)Conversions.doWrapArray((Object)styles)), (Procedures.Procedure1)_function);
                    }
                }
            };
            ProgressIndicatorProvider.checkCanceled();
            action.run();
        }
        finally {
            this.acceptor = null;
        }
        return true;
    }

    public int order() {
        return 0;
    }

    public boolean suitableForFile(PsiFile file) {
        return file instanceof BaseXtextFile && Objects.equal((Object)this.languageId, (Object)file.getLanguage().getID());
    }

    public void visit(PsiElement element) {
        try {
            if (element instanceof BaseXtextFile) {
                long _modificationStamp;
                XtextResource resource = ((BaseXtextFile)element).getResource();
                this.lastRun = _modificationStamp = resource.getModificationStamp();
                CancelProgressIndicator _cancelProgressIndicator = new CancelProgressIndicator();
                this.highlightCalculator.provideHighlightingFor(resource, this.acceptor, (CancelIndicator)_cancelProgressIndicator);
            }
        }
        catch (Throwable _t) {
            if (_t instanceof OperationCanceledError) {
                OperationCanceledError error = (OperationCanceledError)_t;
                this.operationCanceledManager.propagateIfCancelException((Throwable)error);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public HighlightVisitor clone() {
        try {
            Class<?> _class = this.getClass();
            SemanticHighlightVisitor _newInstance = (SemanticHighlightVisitor)_class.newInstance();
            Procedures.Procedure1<SemanticHighlightVisitor> _function = new Procedures.Procedure1<SemanticHighlightVisitor>(){

                public void apply(SemanticHighlightVisitor it) {
                    it.acceptor = SemanticHighlightVisitor.this.acceptor;
                }
            };
            return (HighlightVisitor)ObjectExtensions.operator_doubleArrow((Object)_newInstance, (Procedures.Procedure1)_function);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

