/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.linking.lazy;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xtext.idea.linking.lazy.ICrossReferenceDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.service.OperationCanceledError;
import org.eclipse.xtext.util.ITextRegion;

public class CrossReferenceDescription
implements ICrossReferenceDescription {
    @Inject
    private IScopeProvider scopeProvider;
    @Inject
    private ILocationInFileProvider locationInFileProvider;
    private Integer index;
    private EObject context;
    private EReference reference;

    @Override
    public ITextRegion getTextRegion() {
        try {
            if (this.index == null) {
                return this.locationInFileProvider.getSignificantTextRegion(this.context, (EStructuralFeature)this.reference, -1);
            }
            return this.locationInFileProvider.getSignificantTextRegion(this.context, (EStructuralFeature)this.reference, this.index.intValue());
        }
        catch (OperationCanceledError e) {
            throw e.getWrapped();
        }
    }

    @Override
    public EObject resolve() {
        try {
            InternalEList internalEList;
            Object value = this.context.eGet((EStructuralFeature)this.reference);
            if (this.reference.isMany() && (internalEList = (InternalEList)value).size() > this.index) {
                value = internalEList.get(this.index.intValue());
            }
            if (value instanceof EObject) {
                return (EObject)value;
            }
            return null;
        }
        catch (OperationCanceledError e) {
            throw e.getWrapped();
        }
    }

    @Override
    public Iterable<IEObjectDescription> getVariants() {
        final Iterable<IEObjectDescription> iterable = this.getAllElements();
        return new Iterable<IEObjectDescription>(){

            @Override
            public Iterator<IEObjectDescription> iterator() {
                final Iterator iterator = iterable.iterator();
                return new Iterator<IEObjectDescription>(){

                    @Override
                    public boolean hasNext() {
                        try {
                            return iterator.hasNext();
                        }
                        catch (OperationCanceledError e) {
                            throw e.getWrapped();
                        }
                        catch (UnsupportedOperationException e) {
                            return false;
                        }
                    }

                    @Override
                    public IEObjectDescription next() {
                        try {
                            return (IEObjectDescription)iterator.next();
                        }
                        catch (OperationCanceledError e) {
                            throw e.getWrapped();
                        }
                    }

                    @Override
                    public void remove() {
                        try {
                            iterator.remove();
                        }
                        catch (OperationCanceledError e) {
                            throw e.getWrapped();
                        }
                    }
                };
            }
        };
    }

    protected Iterable<IEObjectDescription> getAllElements() {
        try {
            IScope scope = this.scopeProvider.getScope(this.context, this.reference);
            return scope.getAllElements();
        }
        catch (OperationCanceledError e) {
            throw e.getWrapped();
        }
        catch (UnsupportedOperationException e) {
            return Collections.emptyList();
        }
    }

    public static class CrossReferenceDescriptionProvider {
        @Inject
        private Provider<CrossReferenceDescription> delegate;

        public ICrossReferenceDescription get(EObject context, EReference reference, Integer index) {
            CrossReferenceDescription crossReferenceDescription = (CrossReferenceDescription)this.delegate.get();
            crossReferenceDescription.index = index;
            crossReferenceDescription.context = context;
            crossReferenceDescription.reference = reference;
            return crossReferenceDescription;
        }
    }
}

