/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.resource;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.idea.build.XtextAutoBuilderComponent;
import org.eclipse.xtext.idea.common.types.StubTypeProviderFactory;
import org.eclipse.xtext.idea.resource.IdeaClasspathURIResolver;
import org.eclipse.xtext.idea.resource.ProjectDescriptionProvider;
import org.eclipse.xtext.idea.resource.VirtualFileURIUtil;
import org.eclipse.xtext.resource.IClasspathUriResolver;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.impl.ProjectDescription;
import org.eclipse.xtext.util.LazyStringInputStream;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;

@Singleton
@Log
public class IdeaResourceSetProvider {
    @Inject
    private Provider<XtextResourceSet> resourceSetProvider;
    @Inject
    private StubTypeProviderFactory stubTypeProviderFactory;
    @Inject
    private ProjectDescriptionProvider projectDescriptionProvider;
    @Inject
    private Provider<IdeaClasspathURIResolver> classpathURIResolverProvider;
    private static final Logger LOG = Logger.getLogger(IdeaResourceSetProvider.class);

    public XtextResourceSet get(Module module) {
        XtextResourceSet resourceSet = (XtextResourceSet)this.resourceSetProvider.get();
        resourceSet.setClasspathURIContext((Object)module);
        IdeaClasspathURIResolver _get = (IdeaClasspathURIResolver)this.classpathURIResolverProvider.get();
        resourceSet.setClasspathUriResolver((IClasspathUriResolver)_get);
        URIConverter _uRIConverter = resourceSet.getURIConverter();
        EList _uRIHandlers = _uRIConverter.getURIHandlers();
        _uRIHandlers.clear();
        URIConverter _uRIConverter_1 = resourceSet.getURIConverter();
        EList _uRIHandlers_1 = _uRIConverter_1.getURIHandlers();
        VirtualFileBasedUriHandler _virtualFileBasedUriHandler = new VirtualFileBasedUriHandler();
        _uRIHandlers_1.add((Object)_virtualFileBasedUriHandler);
        ProjectDescription desc = this.projectDescriptionProvider.getProjectDescription(module);
        desc.attachToEmfObject((Notifier)resourceSet);
        Project _project = module.getProject();
        XtextAutoBuilderComponent builder = (XtextAutoBuilderComponent)((Object)_project.getComponent(XtextAutoBuilderComponent.class));
        builder.installCopyOfResourceDescriptions((ResourceSet)resourceSet);
        this.stubTypeProviderFactory.createTypeProvider((ResourceSet)resourceSet);
        return resourceSet;
    }

    public static class VirtualFileBasedUriHandler
    implements URIHandler {
        @Accessors
        private Map<URI, ContentDescriptor> writtenContents = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
        @Accessors
        private Set<URI> deleted = CollectionLiterals.newHashSet((Object[])new URI[0]);

        public static VirtualFileBasedUriHandler find(Notifier notifier) {
            ResourceSet _resourceSet = EcoreUtil2.getResourceSet((Notifier)notifier);
            URIConverter _uRIConverter = _resourceSet.getURIConverter();
            EList _uRIHandlers = _uRIConverter.getURIHandlers();
            Iterable _filter = Iterables.filter((Iterable)_uRIHandlers, VirtualFileBasedUriHandler.class);
            return (VirtualFileBasedUriHandler)IterableExtensions.head((Iterable)_filter);
        }

        public boolean canHandle(URI uri) {
            return true;
        }

        public void flushToDisk() {
            HashSet _newHashSet;
            HashMap _newHashMap;
            boolean _isDebugEnabled = LOG.isDebugEnabled();
            if (_isDebugEnabled) {
                Set<URI> _keySet = this.writtenContents.keySet();
                String _join = IterableExtensions.join(_keySet, (CharSequence)", ");
                String _plus = "writing : " + _join;
                LOG.debug((Object)_plus);
                String _join_1 = IterableExtensions.join(this.deleted, (CharSequence)", ");
                String _plus_1 = "deleting: " + _join_1;
                LOG.debug((Object)_plus_1);
            }
            final Map<URI, ContentDescriptor> localWritten = this.writtenContents;
            this.writtenContents = _newHashMap = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
            final Set<URI> localDeleted = this.deleted;
            this.deleted = _newHashSet = CollectionLiterals.newHashSet((Object[])new URI[0]);
            if (localDeleted.isEmpty() && localWritten.isEmpty()) {
                return;
            }
            Application _application = ApplicationManager.getApplication();
            Runnable _function = new Runnable(){

                @Override
                public void run() {
                    try {
                        VirtualFile file;
                        if (!XtextAutoBuilderComponent.TEST_MODE) {
                            FileDocumentManager _instance = FileDocumentManager.getInstance();
                            _instance.saveAllDocuments();
                        }
                        Set _keySet = localWritten.keySet();
                        for (URI uri : _keySet) {
                            byte[] oldContent;
                            file = VirtualFileURIUtil.getOrCreateVirtualFile(uri);
                            ContentDescriptor contentDescriptor = (ContentDescriptor)localWritten.get(uri);
                            byte[] newContent = contentDescriptor.content;
                            boolean _equals = Arrays.equals(newContent, oldContent = file.contentsToByteArray());
                            boolean _not = !_equals;
                            if (!_not) continue;
                            Object _requestor = VirtualFileBasedUriHandler.this.getRequestor();
                            file.setBinaryContent(newContent, -1L, contentDescriptor.timeStamp, _requestor);
                        }
                        for (URI uri_1 : localDeleted) {
                            file = VirtualFileURIUtil.getVirtualFile(uri_1);
                            if (Objects.equal((Object)file, null) || !file.exists()) continue;
                            Object _requestor = VirtualFileBasedUriHandler.this.getRequestor();
                            file.delete(_requestor);
                        }
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            };
            _application.runWriteAction(_function);
        }

        public Map<String, ?> contentDescription(URI uri, Map<?, ?> options) throws IOException {
            return CollectionLiterals.emptyMap();
        }

        public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
            boolean _notEquals;
            boolean _contains = this.deleted.contains(uri);
            if (_contains) {
                throw new IOException("resource " + uri + " is deleted.");
            }
            boolean _containsKey = this.writtenContents.containsKey(uri);
            if (_containsKey) {
                ContentDescriptor _get = this.writtenContents.get(uri);
                return new ByteArrayInputStream(_get.content);
            }
            final VirtualFile virtualFile = VirtualFileURIUtil.getVirtualFile(uri);
            boolean _equals = Objects.equal((Object)virtualFile, null);
            if (_equals) {
                throw new FileNotFoundException("Couldn't find virtual file for " + uri);
            }
            FileDocumentManager _instance = FileDocumentManager.getInstance();
            Document cachedDocument = _instance.getCachedDocument(virtualFile);
            boolean bl = _notEquals = !Objects.equal((Object)cachedDocument, null);
            if (_notEquals) {
                String _text = cachedDocument.getText();
                Charset _charset = virtualFile.getCharset();
                return new LazyStringInputStream(_text, _charset);
            }
            Application _application = ApplicationManager.getApplication();
            Computable<InputStream> _function = new Computable<InputStream>(){

                public InputStream compute() {
                    try {
                        byte[] _contentsToByteArray = virtualFile.contentsToByteArray();
                        return new ByteArrayInputStream(_contentsToByteArray);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            };
            return (InputStream)_application.runReadAction((Computable)_function);
        }

        public OutputStream createOutputStream(final URI uri, Map<?, ?> options) throws IOException {
            return new ByteArrayOutputStream(){

                @Override
                public void close() throws IOException {
                    super.close();
                    byte[] bytes = this.toByteArray();
                    VirtualFileBasedUriHandler.this.deleted.remove(uri);
                    ContentDescriptor contentDescriptor = new ContentDescriptor();
                    ContentDescriptor.access$102(contentDescriptor, bytes);
                    long _currentTimeMillis = System.currentTimeMillis();
                    contentDescriptor.timeStamp = _currentTimeMillis;
                    VirtualFileBasedUriHandler.this.writtenContents.put(uri, contentDescriptor);
                }
            };
        }

        public void delete(URI uri, Map<?, ?> options) throws IOException {
            this.writtenContents.remove(uri);
            this.deleted.add(uri);
        }

        public Object getRequestor() {
            return null;
        }

        public boolean exists(URI uri, Map<?, ?> options) {
            boolean _notEquals;
            boolean _contains = this.deleted.contains(uri);
            if (_contains) {
                return false;
            }
            boolean _containsKey = this.writtenContents.containsKey(uri);
            if (_containsKey) {
                return true;
            }
            ContentDescriptor _folderDescriptor = this.getFolderDescriptor(uri);
            boolean bl = _notEquals = !Objects.equal((Object)_folderDescriptor, null);
            if (_notEquals) {
                return true;
            }
            VirtualFile _virtualFile = VirtualFileURIUtil.getVirtualFile(uri);
            boolean _exists = false;
            if (_virtualFile != null) {
                _exists = _virtualFile.exists();
            }
            return _exists;
        }

        public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
            boolean _notEquals_2;
            boolean _notEquals_1;
            boolean _notEquals;
            boolean _contains = this.deleted.contains(uri);
            if (_contains) {
                return CollectionLiterals.emptyMap();
            }
            Object _get = options.get("requestedAttributes");
            Set requestedAttributes = (Set)_get;
            if (Objects.equal((Object)requestedAttributes, null) || requestedAttributes.isEmpty()) {
                return CollectionLiterals.emptyMap();
            }
            ContentDescriptor fileDescriptor = this.writtenContents.get(uri);
            boolean bl = _notEquals = !Objects.equal((Object)fileDescriptor, null);
            if (_notEquals) {
                boolean _contains_2;
                HashMap attributes = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
                boolean _contains_1 = requestedAttributes.contains("directory");
                if (_contains_1) {
                    attributes.put("directory", false);
                }
                if (_contains_2 = requestedAttributes.contains("timeStamp")) {
                    attributes.put("timeStamp", fileDescriptor.timeStamp);
                }
                return attributes;
            }
            ContentDescriptor folderDescriptor = this.getFolderDescriptor(uri);
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)folderDescriptor, null);
            if (_notEquals_1) {
                boolean _contains_4;
                HashMap attributes_1 = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
                boolean _contains_3 = requestedAttributes.contains("directory");
                if (_contains_3) {
                    attributes_1.put("directory", true);
                }
                if (_contains_4 = requestedAttributes.contains("timeStamp")) {
                    attributes_1.put("timeStamp", folderDescriptor.timeStamp);
                }
                return attributes_1;
            }
            VirtualFile file = VirtualFileURIUtil.getVirtualFile(uri);
            boolean bl3 = _notEquals_2 = !Objects.equal((Object)file, null);
            if (_notEquals_2) {
                boolean _contains_6;
                HashMap attributes_2 = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
                boolean _contains_5 = requestedAttributes.contains("directory");
                if (_contains_5) {
                    boolean _isDirectory = file.isDirectory();
                    attributes_2.put("directory", _isDirectory);
                }
                if (_contains_6 = requestedAttributes.contains("timeStamp")) {
                    long _timeStamp = file.getTimeStamp();
                    attributes_2.put("timeStamp", _timeStamp);
                }
                return attributes_2;
            }
            return CollectionLiterals.emptyMap();
        }

        protected ContentDescriptor getFolderDescriptor(final URI uri) {
            Set<Map.Entry<URI, ContentDescriptor>> _entrySet = this.writtenContents.entrySet();
            Functions.Function1<Map.Entry<URI, ContentDescriptor>, Boolean> _function = new Functions.Function1<Map.Entry<URI, ContentDescriptor>, Boolean>(){

                public Boolean apply(Map.Entry<URI, ContentDescriptor> fileDescriptor) {
                    URI _key_1;
                    boolean _xblockexpression = false;
                    URI _key = fileDescriptor.getKey();
                    URI relativeURI = _key.deresolve(uri);
                    _xblockexpression = !Objects.equal((Object)relativeURI, (Object)(_key_1 = fileDescriptor.getKey()));
                    return _xblockexpression;
                }
            };
            Iterable _filter = IterableExtensions.filter(_entrySet, (Functions.Function1)_function);
            Map.Entry _head = (Map.Entry)IterableExtensions.head((Iterable)_filter);
            ContentDescriptor _value = null;
            if (_head != null) {
                _value = (ContentDescriptor)_head.getValue();
            }
            return _value;
        }

        public void setAttributes(URI uri, Map<String, ?> attributes, Map<?, ?> options) throws IOException {
        }

        public Set<URI> getChildren(final URI uri) {
            boolean _notEquals;
            LinkedHashSet _xblockexpression = null;
            VirtualFile file = VirtualFileURIUtil.getVirtualFile(uri);
            Set _xifexpression = null;
            boolean bl = _notEquals = !Objects.equal((Object)file, null);
            if (_notEquals) {
                VirtualFile[] _children = file.getChildren();
                Functions.Function1<VirtualFile, URI> _function = new Functions.Function1<VirtualFile, URI>(){

                    public URI apply(VirtualFile it) {
                        return VirtualFileURIUtil.getURI(it);
                    }
                };
                List _map = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)_children)), (Functions.Function1)_function);
                _xifexpression = IterableExtensions.toSet((Iterable)_map);
            } else {
                _xifexpression = CollectionLiterals.newLinkedHashSet((Object[])new URI[0]);
            }
            LinkedHashSet children = _xifexpression;
            Set<URI> _keySet = this.writtenContents.keySet();
            Functions.Function1<URI, URI> _function_1 = new Functions.Function1<URI, URI>(){

                public URI apply(URI uriToWrite) {
                    URI _xblockexpression = null;
                    URI relativeURI = uriToWrite.deresolve(uri);
                    URI _xifexpression = null;
                    if (!relativeURI.isEmpty() && !Objects.equal((Object)relativeURI, (Object)uriToWrite)) {
                        int _segmentCount = relativeURI.segmentCount();
                        int _minus = _segmentCount - 1;
                        URI _trimSegments = relativeURI.trimSegments(_minus);
                        _xifexpression = _trimSegments.resolve(uri);
                    }
                    _xblockexpression = _xifexpression;
                    return _xblockexpression;
                }
            };
            Iterable _map_1 = IterableExtensions.map(_keySet, (Functions.Function1)_function_1);
            Iterable _filterNull = IterableExtensions.filterNull((Iterable)_map_1);
            Iterables.addAll((Collection)children, (Iterable)_filterNull);
            Iterables.removeAll((Iterable)children, this.deleted);
            _xblockexpression = children;
            return _xblockexpression;
        }

        @Pure
        public Map<URI, ContentDescriptor> getWrittenContents() {
            return this.writtenContents;
        }

        public void setWrittenContents(Map<URI, ContentDescriptor> writtenContents) {
            this.writtenContents = writtenContents;
        }

        @Pure
        public Set<URI> getDeleted() {
            return this.deleted;
        }

        public void setDeleted(Set<URI> deleted) {
            this.deleted = deleted;
        }

        @Accessors
        public static class ContentDescriptor {
            private byte[] content;
            private long timeStamp;

            @Pure
            public byte[] getContent() {
                return this.content;
            }

            public void setContent(byte[] content) {
                this.content = content;
            }

            @Pure
            public long getTimeStamp() {
                return this.timeStamp;
            }

            public void setTimeStamp(long timeStamp) {
                this.timeStamp = timeStamp;
            }

            static /* synthetic */ byte[] access$102(ContentDescriptor x0, byte[] x1) {
                x0.content = x1;
                return x1;
            }
        }
    }
}

