/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.resource;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.idea.resource.ModuleProvider;
import org.eclipse.xtext.resource.CompilerPhases;
import org.eclipse.xtext.resource.XtextResourceSet;

public class IndexingAwareGlobalSearchScope
extends GlobalSearchScope {
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private ResourceSet resourceSet;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private GlobalSearchScope filterScope;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private GlobalSearchScope searchScope;
    @Inject
    private CompilerPhases compilerPhases;

    public Project getProject() {
        return this.searchScope.getProject();
    }

    public int compare(VirtualFile file1, VirtualFile file2) {
        return this.searchScope.compare(file1, file2);
    }

    public boolean contains(VirtualFile file) {
        boolean _xblockexpression = false;
        if (this.compilerPhases.isIndexing((Notifier)this.resourceSet) && this.filterScope.contains(file)) {
            return false;
        }
        _xblockexpression = this.searchScope.contains(file);
        return _xblockexpression;
    }

    public boolean isSearchInLibraries() {
        return this.searchScope.isSearchInLibraries();
    }

    public boolean isSearchInModuleContent(Module aModule) {
        boolean _xblockexpression = false;
        if (this.compilerPhases.isIndexing((Notifier)this.resourceSet) && this.filterScope.isSearchInModuleContent(aModule)) {
            return false;
        }
        _xblockexpression = this.searchScope.isSearchInModuleContent(aModule);
        return _xblockexpression;
    }

    public void setResourceSet(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    public void setFilterScope(GlobalSearchScope filterScope) {
        this.filterScope = filterScope;
    }

    public void setSearchScope(GlobalSearchScope searchScope) {
        this.searchScope = searchScope;
    }

    public static class Factory {
        @Inject
        private Provider<IndexingAwareGlobalSearchScope> provider;

        public IndexingAwareGlobalSearchScope createSearchScope(XtextResourceSet resourceSet) {
            IndexingAwareGlobalSearchScope indexingAwareGlobalSearchScope = (IndexingAwareGlobalSearchScope)((Object)this.provider.get());
            indexingAwareGlobalSearchScope.resourceSet = (ResourceSet)resourceSet;
            Module context = ModuleProvider.findModule((ResourceSet)resourceSet);
            GlobalSearchScope _moduleScope = context.getModuleScope();
            indexingAwareGlobalSearchScope.filterScope = _moduleScope;
            GlobalSearchScope _moduleWithDependenciesAndLibrariesScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)context);
            indexingAwareGlobalSearchScope.searchScope = _moduleWithDependenciesAndLibrariesScope;
            return indexingAwareGlobalSearchScope;
        }
    }
}

