/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.resource;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.psi.tree.IElementType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.idea.resource.PsiToEcoreTransformationContext;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.impl.SyntheticCompositeNode;
import org.eclipse.xtext.psi.impl.BaseXtextFile;
import org.eclipse.xtext.psi.tree.IGrammarAwareElementType;
import org.eclipse.xtext.util.internal.EmfAdaptable;
import org.eclipse.xtext.xbase.lib.Pure;

@EmfAdaptable
public class PsiToEcoreAdapter {
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private final BaseXtextFile xtextFile;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private final Map<ASTNode, INode> nodesMapping;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private final Map<INode, List<ASTNode>> reverseNodesMapping;

    public PsiToEcoreAdapter(PsiToEcoreTransformationContext context) {
        BaseXtextFile _xtextFile;
        this.xtextFile = _xtextFile = context.getXtextFile();
        Map<ASTNode, INode> _nodesMapping = context.getNodesMapping();
        Map<ASTNode, INode> _unmodifiableView = Collections.unmodifiableMap(_nodesMapping);
        this.nodesMapping = _unmodifiableView;
        Map<INode, List<ASTNode>> _reverseNodesMapping = context.getReverseNodesMapping();
        Map<INode, List<ASTNode>> _unmodifiableView_1 = Collections.unmodifiableMap(_reverseNodesMapping);
        this.reverseNodesMapping = _unmodifiableView_1;
    }

    public INode getINode(ASTNode astNode) {
        if (astNode == null) {
            return null;
        }
        INode node = this.nodesMapping.get(astNode);
        IElementType elementType = astNode.getElementType();
        if (elementType instanceof IGrammarAwareElementType) {
            EObject grammarElement = ((IGrammarAwareElementType)elementType).getGrammarElement();
            while (node instanceof ICompositeNode && node.getGrammarElement() != grammarElement) {
                INode _firstChild;
                node = _firstChild = ((ICompositeNode)node).getFirstChild();
            }
        }
        return node;
    }

    public ASTNode getASTNode(INode node) {
        if (node == null) {
            return null;
        }
        int index = 0;
        INode originalNode = node;
        while (originalNode instanceof SyntheticCompositeNode) {
            ICompositeNode _parent = ((SyntheticCompositeNode)originalNode).getParent();
            originalNode = _parent;
            ++index;
        }
        List<ASTNode> astNodes = this.reverseNodesMapping.get(originalNode);
        if (astNodes == null && node.getRootNode() == node) {
            FileASTNode _node = this.xtextFile.getNode();
            return _node.getFirstChildNode();
        }
        return astNodes.get(index);
    }

    public static PsiToEcoreAdapter findInEmfObject(Notifier emfObject) {
        for (Adapter adapter : emfObject.eAdapters()) {
            if (!(adapter instanceof PsiToEcoreAdapterAdapter)) continue;
            return ((PsiToEcoreAdapterAdapter)adapter).get();
        }
        return null;
    }

    public static PsiToEcoreAdapter removeFromEmfObject(Notifier emfObject) {
        EList adapters = emfObject.eAdapters();
        int max = adapters.size();
        for (int i = 0; i < max; ++i) {
            Adapter adapter = (Adapter)adapters.get(i);
            if (!(adapter instanceof PsiToEcoreAdapterAdapter)) continue;
            emfObject.eAdapters().remove(i);
            return ((PsiToEcoreAdapterAdapter)adapter).get();
        }
        return null;
    }

    public void attachToEmfObject(Notifier emfObject) {
        PsiToEcoreAdapter result = PsiToEcoreAdapter.findInEmfObject(emfObject);
        if (result != null) {
            throw new IllegalStateException("The given EMF object already contains an adapter for PsiToEcoreAdapter");
        }
        PsiToEcoreAdapterAdapter adapter = new PsiToEcoreAdapterAdapter(this);
        emfObject.eAdapters().add((Object)adapter);
    }

    @Pure
    public BaseXtextFile getXtextFile() {
        return this.xtextFile;
    }

    @Pure
    public Map<ASTNode, INode> getNodesMapping() {
        return this.nodesMapping;
    }

    @Pure
    public Map<INode, List<ASTNode>> getReverseNodesMapping() {
        return this.reverseNodesMapping;
    }

    public static class PsiToEcoreAdapterAdapter
    extends AdapterImpl {
        private PsiToEcoreAdapter element;

        public PsiToEcoreAdapterAdapter(PsiToEcoreAdapter element) {
            this.element = element;
        }

        public PsiToEcoreAdapter get() {
            return this.element;
        }

        public boolean isAdapterForType(Object object) {
            return object == PsiToEcoreAdapter.class;
        }
    }
}

