/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.psi;

import com.google.inject.Singleton;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.tree.CompositeElement;
import java.util.List;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.idea.resource.ModuleProvider;
import org.eclipse.xtext.psi.IPsiModelAssociations;
import org.eclipse.xtext.psi.IPsiModelAssociator;
import org.eclipse.xtext.psi.PsiEObject;
import org.eclipse.xtext.psi.PsiElementProvider;
import org.eclipse.xtext.psi.impl.BaseXtextFile;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.service.OperationCanceledError;

@Singleton
public class PsiModelAssociations
implements IPsiModelAssociations,
IPsiModelAssociator {
    @Override
    public EObject getEObject(PsiElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof PsiEObject) {
            PsiEObject psiEObject = (PsiEObject)element;
            return psiEObject.getEObject();
        }
        return null;
    }

    @Override
    public PsiElement getPsiElement(EObject object) {
        try {
            if (object == null || object.eIsProxy()) {
                return null;
            }
            PsiElement psi = PsiAdapter.getPsi(object);
            if (psi != null) {
                return psi;
            }
            URI uri = EcoreUtil.getURI((EObject)object);
            Resource eResource = object.eResource();
            if (eResource == null) {
                return null;
            }
            BaseXtextFile xtextFile = this.getBaseXtextFile(eResource.getResourceSet(), uri);
            if (xtextFile == null) {
                return null;
            }
            EObject resolvedObject = xtextFile.getEObject(uri);
            return PsiAdapter.getPsi(resolvedObject);
        }
        catch (OperationCanceledError e) {
            throw e.getWrapped();
        }
    }

    protected BaseXtextFile getBaseXtextFile(ResourceSet resourceSet, URI uri) {
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(uri.trimFragment().toString());
        if (file == null) {
            return null;
        }
        Module module = ModuleProvider.findModule(resourceSet);
        if (module == null) {
            throw new IllegalStateException("Module was null");
        }
        PsiFile psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(file);
        if (psiFile == null || !(psiFile instanceof BaseXtextFile)) {
            return null;
        }
        return (BaseXtextFile)psiFile;
    }

    @Override
    public PsiElement getPsiElement(IEObjectDescription objectDescription, Resource context) {
        if (objectDescription == null) {
            return null;
        }
        EObject object = context.getResourceSet().getEObject(objectDescription.getEObjectURI(), true);
        return this.getPsiElement(object);
    }

    @Override
    public boolean associate(EObject eObject, PsiElementProvider psiElementProvider) {
        if (eObject == null || psiElementProvider == null) {
            return false;
        }
        if (PsiAdapter.get(eObject) != null) {
            return false;
        }
        return eObject.eAdapters().add((Object)new PsiAdapter(psiElementProvider));
    }

    public static class PsiAdapter
    extends AdapterImpl {
        private PsiElement psiElement;
        private final CompositeElement composite;
        private final PsiElementProvider psiElementProvider;

        public PsiAdapter(final PsiElement psiElement) {
            this(new PsiElementProvider(){

                @Override
                public PsiElement get() {
                    return psiElement;
                }
            });
        }

        public PsiAdapter(PsiElementProvider psiElementProvider) {
            this.composite = null;
            this.psiElementProvider = psiElementProvider;
        }

        public PsiAdapter(CompositeElement composite) {
            this.composite = composite;
            this.psiElementProvider = null;
        }

        public boolean isAdapterForType(Object type) {
            return ((Object)((Object)this)).getClass() == type;
        }

        public CompositeElement getComposite() {
            return this.composite;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PsiElement getPsi() {
            if (this.composite != null) {
                return this.composite.getPsi();
            }
            if (this.psiElement == null && this.psiElementProvider != null) {
                PsiElementProvider psiElementProvider = this.psiElementProvider;
                synchronized (psiElementProvider) {
                    if (this.psiElement == null) {
                        this.psiElement = this.psiElementProvider.get();
                    }
                }
            }
            return this.psiElement;
        }

        public static CompositeElement getComposite(EObject object) {
            PsiAdapter psiAdapter = PsiAdapter.get(object);
            if (psiAdapter != null) {
                return psiAdapter.getComposite();
            }
            return null;
        }

        public static PsiElement getPsi(EObject object) {
            PsiAdapter psiAdapter = PsiAdapter.get(object);
            if (psiAdapter != null) {
                return psiAdapter.getPsi();
            }
            return null;
        }

        public static PsiAdapter get(EObject object) {
            if (object == null) {
                return null;
            }
            return (PsiAdapter)EcoreUtil.getAdapter((List)object.eAdapters(), PsiAdapter.class);
        }
    }
}

