/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.idea.completion;

import com.google.inject.Inject;
import com.intellij.codeInsight.completion.AllClassesGetter;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaClassNameCompletionContributor;
import com.intellij.codeInsight.completion.JavaCompletionSorting;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.openapi.editor.Document;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.Consumer;
import com.intellij.util.ProcessingContext;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.idea.lang.AbstractXtextLanguage;
import org.eclipse.xtext.psi.impl.BaseXtextFile;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.idea.completion.XbaseLookupElementWeigher;
import org.eclipse.xtext.xbase.idea.completion.XtypeCompletionContributor;
import org.eclipse.xtext.xbase.idea.imports.DocumentAwareRewritableImportSectionFactory;
import org.eclipse.xtext.xbase.imports.RewritableImportSection;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.services.XbaseGrammarAccess;
import org.eclipse.xtext.xtype.XtypePackage;

public class XbaseCompletionContributor
extends XtypeCompletionContributor {
    @Inject
    private XbaseGrammarAccess grammarAccess;
    @Inject
    private ImportAddingInsertHandler importAddingInsertHandler;

    public XbaseCompletionContributor(AbstractXtextLanguage lang) {
        super(lang);
        this.completeJvmParameterizedTypeReference_Type();
        this.completeXImportDeclaration_ImportedType();
        this.completeXConstructorCall_Constructor();
        this.completeXTypeLiteral_Type();
        this.completeJavaTypeWithinMultiLineComment();
        this.completeJavaTypeWithinExpressionContext();
    }

    @Override
    protected CompletionSorter getCompletionSorter(CompletionParameters parameters, CompletionResultSet result) {
        PrefixMatcher _prefixMatcher = result.getPrefixMatcher();
        CompletionSorter _defaultSorter = CompletionSorter.defaultSorter((CompletionParameters)parameters, (PrefixMatcher)_prefixMatcher);
        XbaseLookupElementWeigher _xbaseLookupElementWeigher = new XbaseLookupElementWeigher();
        return _defaultSorter.weighBefore("liftShorter", new LookupElementWeigher[]{_xbaseLookupElementWeigher});
    }

    protected void completeJavaTypeWithinExpressionContext() {
        Set<RuleCall> _expressionContextFollowElements = this.getExpressionContextFollowElements();
        for (RuleCall expressionContextFollowElement : _expressionContextFollowElements) {
            CompletionProvider<CompletionParameters> _function = new CompletionProvider<CompletionParameters>(){

                protected void addCompletions(CompletionParameters $0, ProcessingContext $1, CompletionResultSet $2) {
                    Functions.Function1<JavaPsiClassReferenceElement, Boolean> _function = new Functions.Function1<JavaPsiClassReferenceElement, Boolean>(){

                        public Boolean apply(JavaPsiClassReferenceElement it) {
                            return true;
                        }
                    };
                    XbaseCompletionContributor.this.completeJavaTypes($0, $2, true, (Functions.Function1<? super JavaPsiClassReferenceElement, ? extends Boolean>)_function);
                }
            };
            this.extend(CompletionType.BASIC, (AbstractElement)expressionContextFollowElement, _function);
        }
    }

    protected Set<RuleCall> getExpressionContextFollowElements() {
        XbaseGrammarAccess.XPrimaryExpressionElements _xPrimaryExpressionAccess = this.grammarAccess.getXPrimaryExpressionAccess();
        RuleCall _xFeatureCallParserRuleCall_4 = _xPrimaryExpressionAccess.getXFeatureCallParserRuleCall_4();
        return Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new RuleCall[]{_xFeatureCallParserRuleCall_4}));
    }

    protected void completeJavaTypeWithinMultiLineComment() {
        IElementType[] _types;
        TokenSet _multiLineCommentTokens = this._tokenSetProvider.getMultiLineCommentTokens();
        for (IElementType mlCommentTokenType : _types = _multiLineCommentTokens.getTypes()) {
            PsiElementPattern.Capture _psiElement = PlatformPatterns.psiElement((IElementType)mlCommentTokenType);
            CompletionProvider<CompletionParameters> _function = new CompletionProvider<CompletionParameters>(){

                protected void addCompletions(CompletionParameters $0, ProcessingContext $1, CompletionResultSet $2) {
                    Functions.Function1<JavaPsiClassReferenceElement, Boolean> _function = new Functions.Function1<JavaPsiClassReferenceElement, Boolean>(){

                        public Boolean apply(JavaPsiClassReferenceElement it) {
                            return true;
                        }
                    };
                    XbaseCompletionContributor.this.completeJavaTypes($0, $2, false, (Functions.Function1<? super JavaPsiClassReferenceElement, ? extends Boolean>)_function);
                }
            };
            this.extend(CompletionType.BASIC, (ElementPattern)_psiElement, (CompletionProvider)_function);
        }
    }

    protected void completeJvmParameterizedTypeReference_Type() {
        this.completeJavaTypes(TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE);
    }

    protected void completeXImportDeclaration_ImportedType() {
        Functions.Function1<JavaPsiClassReferenceElement, Boolean> _function = new Functions.Function1<JavaPsiClassReferenceElement, Boolean>(){

            public Boolean apply(JavaPsiClassReferenceElement it) {
                return true;
            }
        };
        this.completeJavaTypes(XtypePackage.Literals.XIMPORT_DECLARATION__IMPORTED_TYPE, false, (Functions.Function1<? super JavaPsiClassReferenceElement, ? extends Boolean>)_function);
    }

    protected void completeXConstructorCall_Constructor() {
        Functions.Function1<JavaPsiClassReferenceElement, Boolean> _function = new Functions.Function1<JavaPsiClassReferenceElement, Boolean>(){

            public Boolean apply(JavaPsiClassReferenceElement it) {
                boolean _xblockexpression = false;
                PsiClass type = it.getObject();
                _xblockexpression = !type.hasModifierProperty("abstract") && !type.isInterface();
                return _xblockexpression;
            }
        };
        this.completeJavaTypes(XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR, true, (Functions.Function1<? super JavaPsiClassReferenceElement, ? extends Boolean>)_function);
    }

    protected void completeXTypeLiteral_Type() {
        this.completeJavaTypes(XbasePackage.Literals.XTYPE_LITERAL__TYPE);
    }

    protected void completeJavaTypes(EReference reference) {
        this.completeJavaTypes(reference, true);
    }

    protected void completeJavaTypes(EReference reference, boolean addImport) {
        Functions.Function1<JavaPsiClassReferenceElement, Boolean> _function = new Functions.Function1<JavaPsiClassReferenceElement, Boolean>(){

            public Boolean apply(JavaPsiClassReferenceElement it) {
                return true;
            }
        };
        this.completeJavaTypes(reference, addImport, (Functions.Function1<? super JavaPsiClassReferenceElement, ? extends Boolean>)_function);
    }

    protected void completeJavaTypes(EReference reference, final boolean addImport, final Functions.Function1<? super JavaPsiClassReferenceElement, ? extends Boolean> filter) {
        CompletionProvider<CompletionParameters> _function = new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(CompletionParameters $0, ProcessingContext $1, CompletionResultSet $2) {
                XbaseCompletionContributor.this.completeJavaTypes($0, $2, addImport, (Functions.Function1<? super JavaPsiClassReferenceElement, ? extends Boolean>)filter);
            }
        };
        this.extend(CompletionType.BASIC, (EStructuralFeature)reference, _function);
    }

    protected void completeJavaTypes(CompletionParameters completionParameters, final CompletionResultSet completionResultSet, final boolean addImport, final Functions.Function1<? super JavaPsiClassReferenceElement, ? extends Boolean> filter) {
        int _invocationCount = completionParameters.getInvocationCount();
        boolean _lessEqualsThan = _invocationCount <= 2;
        CompletionResultSet _addJavaSorting = JavaCompletionSorting.addJavaSorting((CompletionParameters)completionParameters, (CompletionResultSet)completionResultSet);
        PrefixMatcher _prefixMatcher = _addJavaSorting.getPrefixMatcher();
        Consumer<LookupElement> _function = new Consumer<LookupElement>(){

            public void consume(LookupElement it) {
                Boolean _apply;
                if (it instanceof JavaPsiClassReferenceElement && (_apply = (Boolean)filter.apply((Object)((JavaPsiClassReferenceElement)it))).booleanValue()) {
                    if (addImport) {
                        ((JavaPsiClassReferenceElement)it).setInsertHandler((InsertHandler)XbaseCompletionContributor.this.importAddingInsertHandler);
                    }
                    completionResultSet.addElement(it);
                }
            }
        };
        JavaClassNameCompletionContributor.addAllClasses((CompletionParameters)completionParameters, (boolean)_lessEqualsThan, (PrefixMatcher)_prefixMatcher, (Consumer)_function);
    }

    @Override
    protected boolean isKeywordWorthyToPropose(Keyword keyword) {
        return keyword.getValue().length() > 1 && Character.isLetter(keyword.getValue().charAt(0));
    }

    public static class ImportAddingInsertHandler
    implements InsertHandler<JavaPsiClassReferenceElement> {
        @Inject
        private DocumentAwareRewritableImportSectionFactory factory;

        public void handleInsert(InsertionContext context, JavaPsiClassReferenceElement item) {
            PsiFile file = context.getFile();
            if (file instanceof BaseXtextFile) {
                String _qualifiedName;
                ResourceSet _resourceSet;
                XtextResource resource = ((BaseXtextFile)file).getResource();
                IResourceServiceProvider _resourceServiceProvider = resource.getResourceServiceProvider();
                IJvmTypeProvider.Factory _get = (IJvmTypeProvider.Factory)_resourceServiceProvider.get(IJvmTypeProvider.Factory.class);
                IJvmTypeProvider typeProvider = _get.findTypeProvider(_resourceSet = resource.getResourceSet());
                JvmType jvmType = typeProvider.findTypeByName(_qualifiedName = item.getQualifiedName());
                if (jvmType instanceof JvmDeclaredType) {
                    String simpleName = ((JvmDeclaredType)jvmType).getSimpleName();
                    Document _document = context.getDocument();
                    int _startOffset = context.getStartOffset();
                    int _tailOffset = context.getTailOffset();
                    _document.replaceString(_startOffset, _tailOffset, (CharSequence)simpleName);
                    RewritableImportSection importSection = this.factory.parse(resource);
                    boolean _addImport = importSection.addImport((JvmDeclaredType)jvmType);
                    if (_addImport) {
                        List regions = importSection.rewrite();
                        for (ReplaceRegion reg : regions) {
                            Document _document_1 = context.getDocument();
                            int _offset = reg.getOffset();
                            int _endOffset = reg.getEndOffset();
                            String _text = reg.getText();
                            _document_1.replaceString(_offset, _endOffset, (CharSequence)_text);
                        }
                    }
                } else {
                    AllClassesGetter.INSERT_FQN.handleInsert(context, (LookupElement)item);
                }
            } else {
                throw new IllegalStateException("Not an Xtext psi file " + file);
            }
        }
    }
}

