/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.interpreter;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XBooleanLiteral;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XStringLiteral;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.XUnaryOperation;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.interpreter.ConstantExpressionEvaluationException;
import org.eclipse.xtext.xbase.interpreter.ConstantOperators;
import org.eclipse.xtext.xbase.interpreter.Context;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;

public class AbstractConstantExpressionsInterpreter {
    @Inject
    @Accessors(value={AccessorType.PROTECTED_GETTER})
    private ConstantOperators constantOperators;
    @Inject
    private OperatorMapping operatorMapping;

    protected Object evaluate(XExpression expression, Context ctx) {
        Object _xtrycatchfinallyexpression;
        Object _xifexpression = null;
        Set<XExpression> _alreadyEvaluating = ctx.getAlreadyEvaluating();
        boolean _add = _alreadyEvaluating.add(expression);
        if (_add) {
            _xtrycatchfinallyexpression = null;
            try {
                _xtrycatchfinallyexpression = this.internalEvaluate(expression, ctx);
            }
            finally {
                Set<XExpression> _alreadyEvaluating_1 = ctx.getAlreadyEvaluating();
                _alreadyEvaluating_1.remove(expression);
            }
        } else {
            throw this.notConstantExpression(expression);
        }
        _xifexpression = _xtrycatchfinallyexpression;
        return _xifexpression;
    }

    protected Object _internalEvaluate(XExpression expression, Context ctx) {
        throw this.notConstantExpression(expression);
    }

    protected Object _internalEvaluate(Void nullValue, Context ctx) {
        throw this.notConstantExpression(null);
    }

    public ConstantExpressionEvaluationException notConstantExpression(XExpression expression) {
        String _text = null;
        if (expression != null) {
            _text = this.toText(expression);
        }
        String _plus = "Not a constant expression : '" + _text;
        String _plus_1 = String.valueOf(_plus) + "'";
        return new ConstantExpressionEvaluationException(_plus_1, expression);
    }

    protected Object _internalEvaluate(XCastedExpression expression, Context ctx) {
        XExpression _target = expression.getTarget();
        return this.evaluate(_target, ctx);
    }

    protected Object _internalEvaluate(XStringLiteral it, Context ctx) {
        return it.getValue();
    }

    protected Object _internalEvaluate(XBooleanLiteral it, Context ctx) {
        return it.isIsTrue();
    }

    protected Object _internalEvaluate(XAnnotation literal, Context ctx) {
        return literal;
    }

    protected Object _internalEvaluate(XTypeLiteral it, Context ctx) {
        JvmType _type = it.getType();
        EList<String> _arrayDimensions = it.getArrayDimensions();
        int _size = _arrayDimensions.size();
        return this.toTypeReference(_type, _size);
    }

    protected JvmTypeReference toTypeReference(final JvmType type, int arrayDimensions) {
        boolean _equals = Objects.equal((Object)type, null);
        if (_equals) {
            return null;
        }
        JvmParameterizedTypeReference _createJvmParameterizedTypeReference = TypesFactory.eINSTANCE.createJvmParameterizedTypeReference();
        Procedures.Procedure1<JvmParameterizedTypeReference> _function = new Procedures.Procedure1<JvmParameterizedTypeReference>(){

            public void apply(JvmParameterizedTypeReference it) {
                it.setType(type);
            }
        };
        JvmTypeReference resultTypeRef = (JvmTypeReference)ObjectExtensions.operator_doubleArrow((Object)_createJvmParameterizedTypeReference, (Procedures.Procedure1)_function);
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, arrayDimensions, true);
        Iterator iterator = _doubleDotLessThan.iterator();
        while (iterator.hasNext()) {
            Integer cfr_ignored_0 = (Integer)iterator.next();
            JvmGenericArrayTypeReference arrayRef = TypesFactory.eINSTANCE.createJvmGenericArrayTypeReference();
            arrayRef.setComponentType(resultTypeRef);
            resultTypeRef = arrayRef;
        }
        return resultTypeRef;
    }

    protected Object _internalEvaluate(XBinaryOperation it, Context ctx) {
        Object _xblockexpression = null;
        Context context = ctx.cloneWithExpectation(null);
        XExpression _leftOperand = it.getLeftOperand();
        Object left = this.evaluate(_leftOperand, context);
        XExpression _rightOperand = it.getRightOperand();
        Object right = this.evaluate(_rightOperand, context);
        _xblockexpression = this.evaluateBinaryOperation(it, left, right);
        return _xblockexpression;
    }

    protected Object evaluateBinaryOperation(XBinaryOperation binaryOperation, Object left, Object right) {
        Object _xblockexpression = null;
        String op = this.getOperator(binaryOperation);
        Object _switchResult = null;
        boolean _matched = false;
        if (Objects.equal((Object)op, (Object)"+")) {
            _matched = true;
            _switchResult = this.constantOperators.plus(left, right);
        }
        if (!_matched && Objects.equal((Object)op, (Object)"-")) {
            _matched = true;
            _switchResult = this.constantOperators.minus(left, right);
        }
        if (!_matched && Objects.equal((Object)op, (Object)"*")) {
            _matched = true;
            _switchResult = this.constantOperators.multiply(left, right);
        }
        if (!_matched && Objects.equal((Object)op, (Object)"/")) {
            _matched = true;
            _switchResult = this.constantOperators.divide(left, right);
        }
        if (!_matched && Objects.equal((Object)op, (Object)"%")) {
            _matched = true;
            _switchResult = this.constantOperators.modulo(left, right);
        }
        if (!_matched && Objects.equal((Object)op, (Object)"&&")) {
            _matched = true;
            _switchResult = this.constantOperators.and(left, right);
        }
        if (!_matched && Objects.equal((Object)op, (Object)"||")) {
            _matched = true;
            _switchResult = this.constantOperators.or(left, right);
        }
        if (!_matched && Objects.equal((Object)op, (Object)"<<")) {
            _matched = true;
            _switchResult = this.constantOperators.shiftLeft(left, right);
        }
        if (!_matched && Objects.equal((Object)op, (Object)">>")) {
            _matched = true;
            _switchResult = this.constantOperators.shiftRight(left, right);
        }
        if (!_matched && Objects.equal((Object)op, (Object)">>>")) {
            _matched = true;
            _switchResult = this.constantOperators.shiftRightUnsigned(left, right);
        }
        if (!_matched && Objects.equal((Object)op, (Object)"<")) {
            _matched = true;
            _switchResult = this.constantOperators.lessThan(left, right);
        }
        if (!_matched && Objects.equal((Object)op, (Object)">")) {
            _matched = true;
            _switchResult = this.constantOperators.greaterThan(left, right);
        }
        if (!_matched && Objects.equal((Object)op, (Object)"<=")) {
            _matched = true;
            _switchResult = this.constantOperators.lessEquals(left, right);
        }
        if (!_matched && Objects.equal((Object)op, (Object)">=")) {
            _matched = true;
            _switchResult = this.constantOperators.greaterEquals(left, right);
        }
        if (!_matched) {
            if (Objects.equal((Object)op, (Object)"==")) {
                _matched = true;
            }
            if (!_matched && Objects.equal((Object)op, (Object)"===")) {
                _matched = true;
            }
            if (_matched) {
                _switchResult = this.constantOperators.same(left, right);
            }
        }
        if (!_matched) {
            if (Objects.equal((Object)op, (Object)"!=")) {
                _matched = true;
            }
            if (!_matched && Objects.equal((Object)op, (Object)"!==")) {
                _matched = true;
            }
            if (_matched) {
                _switchResult = this.constantOperators.notSame(left, right);
            }
        }
        if (!_matched) {
            throw new ConstantExpressionEvaluationException("Couldn't evaluate binary operator '" + op + "' on values " + left + " and " + right);
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    protected Object _internalEvaluate(XUnaryOperation it, Context ctx) {
        Object _xblockexpression = null;
        XExpression _operand = it.getOperand();
        Object value = this.evaluate(_operand, ctx);
        String op = this.getOperator(it);
        Object _switchResult = null;
        boolean _matched = false;
        if (Objects.equal((Object)op, (Object)"-")) {
            _matched = true;
            _switchResult = this.constantOperators.minus(value);
        }
        if (!_matched && Objects.equal((Object)op, (Object)"!") && value instanceof Boolean) {
            _matched = true;
            _switchResult = (Boolean)value == false;
        }
        if (!_matched && Objects.equal((Object)op, (Object)"+") && value instanceof Number) {
            _matched = true;
            _switchResult = value;
        }
        if (!_matched) {
            throw new ConstantExpressionEvaluationException("Couldn't evaluate unary operator '" + op + "' on value " + value);
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    protected String getOperator(XAbstractFeatureCall call) {
        boolean _isLoadedFromStorage;
        Resource _eResource;
        String _switchResult = null;
        Resource res = _eResource = call.eResource();
        boolean _matched = false;
        if (res instanceof StorageAwareResource && (_isLoadedFromStorage = ((StorageAwareResource)res).isLoadedFromStorage())) {
            _matched = true;
            JvmIdentifiableElement _feature = call.getFeature();
            String _simpleName = _feature.getSimpleName();
            QualifiedName _create = QualifiedName.create((String)_simpleName);
            QualifiedName _operator = this.operatorMapping.getOperator(_create);
            String _string = null;
            if (_operator != null) {
                _string = _operator.toString();
            }
            return _string;
        }
        if (!_matched) {
            _switchResult = call.getConcreteSyntaxFeatureName();
        }
        return _switchResult;
    }

    protected String toText(XExpression expression) {
        ICompositeNode _node = NodeModelUtils.getNode((EObject)expression);
        return _node.getText();
    }

    public Object internalEvaluate(XExpression it, Context ctx) {
        if (it instanceof XBinaryOperation) {
            return this._internalEvaluate((XBinaryOperation)it, ctx);
        }
        if (it instanceof XUnaryOperation) {
            return this._internalEvaluate((XUnaryOperation)it, ctx);
        }
        if (it instanceof XBooleanLiteral) {
            return this._internalEvaluate((XBooleanLiteral)it, ctx);
        }
        if (it instanceof XCastedExpression) {
            return this._internalEvaluate((XCastedExpression)it, ctx);
        }
        if (it instanceof XStringLiteral) {
            return this._internalEvaluate((XStringLiteral)it, ctx);
        }
        if (it instanceof XTypeLiteral) {
            return this._internalEvaluate((XTypeLiteral)it, ctx);
        }
        if (it instanceof XAnnotation) {
            return this._internalEvaluate((XAnnotation)it, ctx);
        }
        if (it != null) {
            return this._internalEvaluate(it, ctx);
        }
        if (it == null) {
            return this._internalEvaluate((Void)null, ctx);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, ctx).toString());
    }

    @Pure
    protected ConstantOperators getConstantOperators() {
        return this.constantOperators;
    }
}

