/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.wizard;

import com.google.common.io.Resources;
import com.google.inject.Inject;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Set;
import org.eclipse.xtext.idea.config.XtextProjectConfigurator;
import org.eclipse.xtext.idea.facet.AbstractFacetConfiguration;
import org.eclipse.xtext.idea.facet.GeneratorConfigurationState;
import org.eclipse.xtext.idea.lang.XtextLanguage;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xtext.wizard.AbstractFile;
import org.eclipse.xtext.xtext.wizard.BinaryFile;
import org.eclipse.xtext.xtext.wizard.Outlet;
import org.eclipse.xtext.xtext.wizard.ParentProjectDescriptor;
import org.eclipse.xtext.xtext.wizard.ProjectDescriptor;
import org.eclipse.xtext.xtext.wizard.ProjectsCreator;
import org.eclipse.xtext.xtext.wizard.SourceLayout;
import org.eclipse.xtext.xtext.wizard.TextFile;
import org.eclipse.xtext.xtext.wizard.WizardConfiguration;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class IdeaProjectCreator
implements ProjectsCreator {
    @Inject
    private XtextProjectConfigurator projectConfigrator;
    private ModifiableModuleModel model;

    public IdeaProjectCreator(ModifiableModuleModel model) {
        this.model = model;
    }

    public void createProjects(WizardConfiguration config) {
        Set _enabledProjects = config.getEnabledProjects();
        Procedures.Procedure1<ProjectDescriptor> _function = new Procedures.Procedure1<ProjectDescriptor>(){

            public void apply(ProjectDescriptor it) {
                IdeaProjectCreator.this.createProject(it);
            }
        };
        IterableExtensions.forEach((Iterable)_enabledProjects, (Procedures.Procedure1)_function);
    }

    public Module createProject(final ProjectDescriptor project) {
        try {
            AbstractFacetConfiguration conf;
            String _location = project.getLocation();
            final VirtualFile projectRoot = VfsUtil.createDirectories((String)_location);
            final LocalFileSystem fileSystem = LocalFileSystem.getInstance();
            Iterable _files = project.getFiles();
            Procedures.Procedure1<AbstractFile> _function = new Procedures.Procedure1<AbstractFile>(){

                public void apply(AbstractFile it) {
                    try {
                        Object _content;
                        WizardConfiguration _config = project.getConfig();
                        SourceLayout _sourceLayout = _config.getSourceLayout();
                        Outlet _outlet = it.getOutlet();
                        String _pathFor = _sourceLayout.getPathFor(_outlet);
                        String _plus = _pathFor + "/";
                        String _relativePath = it.getRelativePath();
                        String projectRelativePath = _plus + _relativePath;
                        String _path = projectRoot.getPath();
                        File _file = new File(_path);
                        File ioFile = new File(_file, projectRelativePath);
                        File _parentFile = ioFile.getParentFile();
                        _parentFile.mkdirs();
                        ioFile.createNewFile();
                        boolean _isExecutable = it.isExecutable();
                        if (_isExecutable) {
                            ioFile.setExecutable(true);
                        }
                        VirtualFile virtualFile = fileSystem.refreshAndFindFileByIoFile(ioFile);
                        boolean _matched = false;
                        if (it instanceof TextFile) {
                            _matched = true;
                            _content = ((TextFile)it).getContent();
                            VfsUtil.saveText((VirtualFile)virtualFile, (String)_content);
                        }
                        if (!_matched && it instanceof BinaryFile) {
                            _matched = true;
                            _content = ((BinaryFile)it).getContent();
                            byte[] _byteArray = Resources.toByteArray((URL)_content);
                            virtualFile.setBinaryContent(_byteArray);
                        }
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            };
            IterableExtensions.forEach((Iterable)_files, (Procedures.Procedure1)_function);
            String _moduleFilePath = this.moduleFilePath(project);
            String _id = StdModuleTypes.JAVA.getId();
            Module module = this.model.newModule(_moduleFilePath, _id);
            ModuleRootManager _instance = ModuleRootManager.getInstance((Module)module);
            ModifiableRootModel rootModel = _instance.getModifiableModel();
            rootModel.inheritSdk();
            String _location_1 = project.getLocation();
            final VirtualFile modelContentRootDir = fileSystem.refreshAndFindFileByPath(_location_1);
            final ContentEntry contentEntry = rootModel.addContentEntry(modelContentRootDir);
            Outlet[] _generateOutlets = Outlet.generateOutlets();
            Functions.Function1<Outlet, String> _function_1 = new Functions.Function1<Outlet, String>(){

                public String apply(Outlet it) {
                    return project.sourceFolder(it);
                }
            };
            final List genFolders = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)_generateOutlets)), (Functions.Function1)_function_1);
            Set _sourceFolders = project.getSourceFolders();
            Procedures.Procedure1<String> _function_2 = new Procedures.Procedure1<String>(){

                public void apply(String it) {
                    try {
                        VirtualFile sourceRoot = VfsUtil.createDirectoryIfMissing((VirtualFile)modelContentRootDir, (String)it);
                        JavaSourceRootType rootType = JavaSourceRootType.SOURCE;
                        boolean isGen = genFolders.contains(it);
                        JpsJavaExtensionService _instance = JpsJavaExtensionService.getInstance();
                        JavaSourceRootProperties properties = _instance.createSourceRootProperties("", isGen);
                        contentEntry.addSourceFolder(sourceRoot, (JpsModuleSourceRootType)rootType, (JpsElement)properties);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            };
            IterableExtensions.forEach((Iterable)_sourceFolders, (Procedures.Procedure1)_function_2);
            if (!(project instanceof ParentProjectDescriptor) && (conf = this.projectConfigrator.createOrGetFacetConf(module, "org.eclipse.xtend.core.Xtend")) != null) {
                GeneratorConfigurationState _state = conf.getState();
                String _absoluteSourceFolder = this.absoluteSourceFolder(project, Outlet.MAIN_XTEND_GEN);
                _state.setOutputDirectory(_absoluteSourceFolder);
                GeneratorConfigurationState _state_1 = conf.getState();
                String _absoluteSourceFolder_1 = this.absoluteSourceFolder(project, Outlet.TEST_XTEND_GEN);
                _state_1.setTestOutputDirectory(_absoluteSourceFolder_1);
            }
            rootModel.commit();
            return module;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public String absoluteSourceFolder(ProjectDescriptor project, Outlet outlet) {
        String _location = project.getLocation();
        String _plus = _location + "/";
        String _sourceFolder = project.sourceFolder(outlet);
        return _plus + _sourceFolder;
    }

    public String moduleFilePath(ProjectDescriptor project) {
        String _location = project.getLocation();
        String _plus = _location + File.separator;
        String _name = project.getName();
        String _plus_1 = _plus + _name;
        return _plus_1 + ".iml";
    }

    public static class Factory {
        public IdeaProjectCreator create(ModifiableModuleModel model) {
            IdeaProjectCreator pc = new IdeaProjectCreator(model);
            XtextLanguage.INSTANCE.injectMembers(pc);
            return pc;
        }
    }
}

