/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.type.baseimpl.types;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Set;
import org.eclipse.internal.xtend.type.baseimpl.OperationImpl;
import org.eclipse.internal.xtend.type.baseimpl.types.BuiltinBaseType;
import org.eclipse.xtend.expression.TypeSystem;
import org.eclipse.xtend.typesystem.Feature;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RealTypeImpl
extends BuiltinBaseType {
    public RealTypeImpl(TypeSystem ts, String name) {
        super(ts, name);
    }

    @Override
    public Feature[] getContributedFeatures() {
        return new Feature[]{new OperationImpl(this, "+", (Type)this, new Type[]{this}){

            public Object evaluateInternal(Object target, Object[] params) {
                if (params[0] == null) {
                    return null;
                }
                return new Double(((Number)target).doubleValue() + ((Number)params[0]).doubleValue());
            }
        }, new OperationImpl(this, "-", (Type)this, new Type[]{this}){

            public Object evaluateInternal(Object target, Object[] params) {
                if (params[0] == null) {
                    return null;
                }
                return new Double(((Number)target).doubleValue() - ((Number)params[0]).doubleValue());
            }
        }, new OperationImpl(this, "-", (Type)this, new Type[0]){

            public Object evaluateInternal(Object target, Object[] params) {
                return new Double(((Number)target).doubleValue() * -1.0);
            }
        }, new OperationImpl(this, "*", (Type)this, new Type[]{this}){

            public Object evaluateInternal(Object target, Object[] params) {
                if (params[0] == null) {
                    return null;
                }
                return new Double(((Number)target).doubleValue() * ((Number)params[0]).doubleValue());
            }
        }, new OperationImpl(this, "/", (Type)this, new Type[]{this}){

            public Object evaluateInternal(Object target, Object[] params) {
                if (params[0] == null) {
                    return null;
                }
                return new Double(((Number)target).doubleValue() / ((Number)params[0]).doubleValue());
            }
        }, new OperationImpl(this, "==", this.getTypeSystem().getBooleanType(), new Type[]{this.getTypeSystem().getObjectType()}){

            public Object evaluateInternal(Object target, Object[] params) {
                if (target == null) {
                    return new Boolean(target == params[0]);
                }
                try {
                    return RealTypeImpl.this.toDouble(target).equals(RealTypeImpl.this.toDouble(params[0]));
                }
                catch (Exception exception) {
                    return false;
                }
            }
        }, new OperationImpl(this, "!=", this.getTypeSystem().getBooleanType(), new Type[]{this.getTypeSystem().getObjectType()}){

            public Object evaluateInternal(Object target, Object[] params) {
                if (target == null) {
                    return new Boolean(target != params[0]);
                }
                try {
                    return !RealTypeImpl.this.toDouble(target).equals(RealTypeImpl.this.toDouble(params[0]));
                }
                catch (Exception exception) {
                    return true;
                }
            }
        }, new OperationImpl(this, ">", this.getTypeSystem().getBooleanType(), new Type[]{this.getTypeSystem().getObjectType()}){

            public Object evaluateInternal(Object target, Object[] params) {
                if (target == null) {
                    return Boolean.FALSE;
                }
                if (params[0] == null) {
                    return Boolean.FALSE;
                }
                return new Boolean(RealTypeImpl.this.toDouble(target).compareTo(RealTypeImpl.this.toDouble(params[0])) > 0);
            }
        }, new OperationImpl(this, ">=", this.getTypeSystem().getBooleanType(), new Type[]{this.getTypeSystem().getObjectType()}){

            public Object evaluateInternal(Object target, Object[] params) {
                if (target == null) {
                    return params[0] == null ? Boolean.TRUE : Boolean.FALSE;
                }
                if (params[0] == null) {
                    return Boolean.FALSE;
                }
                return new Boolean(RealTypeImpl.this.toDouble(target).compareTo(RealTypeImpl.this.toDouble(params[0])) >= 0);
            }
        }, new OperationImpl(this, "<", this.getTypeSystem().getBooleanType(), new Type[]{this.getTypeSystem().getObjectType()}){

            public Object evaluateInternal(Object target, Object[] params) {
                if (target == null) {
                    return Boolean.FALSE;
                }
                if (params[0] == null) {
                    return Boolean.FALSE;
                }
                return new Boolean(RealTypeImpl.this.toDouble(target).compareTo(RealTypeImpl.this.toDouble(params[0])) < 0);
            }
        }, new OperationImpl(this, "<=", this.getTypeSystem().getBooleanType(), new Type[]{this.getTypeSystem().getObjectType()}){

            public Object evaluateInternal(Object target, Object[] params) {
                if (target == null) {
                    return params[0] == null ? Boolean.TRUE : Boolean.FALSE;
                }
                if (params[0] == null) {
                    return Boolean.FALSE;
                }
                return new Boolean(RealTypeImpl.this.toDouble(target).compareTo(RealTypeImpl.this.toDouble(params[0])) <= 0);
            }
        }, new OperationImpl(this, "toInteger", this.getTypeSystem().getIntegerType(), new Type[0]){

            public Object evaluateInternal(Object target, Object[] params) {
                if (target == null) {
                    return null;
                }
                return ((Number)target).longValue();
            }
        }};
    }

    public Set<Type> getSuperTypes() {
        return Collections.singleton(this.getTypeSystem().getObjectType());
    }

    @Override
    public boolean isInstance(Object o) {
        return o instanceof Double || o instanceof Float || o instanceof BigDecimal;
    }

    @Override
    public Object newInstance() {
        return new Double(1.0);
    }

    private Double toDouble(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        throw new IllegalArgumentException(String.valueOf(o.getClass().getName()) + " not supported");
    }

    @Override
    public Object convert(Object src, Class<?> targetType) {
        Double l = this.toDouble(src);
        if (targetType.isAssignableFrom(Double.class) || targetType.isAssignableFrom(Double.TYPE)) {
            return l;
        }
        if (targetType.isAssignableFrom(Float.class) || targetType.isAssignableFrom(Float.TYPE)) {
            return new Float(l);
        }
        if (targetType.isAssignableFrom(BigDecimal.class)) {
            return new BigDecimal(l);
        }
        return super.convert(src, targetType);
    }
}

