/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.debug;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import org.eclipse.xtext.formatting2.regionaccess.ILineRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextReplacement;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.formatting2.regionaccess.internal.TextRegions;

public class TextRegionsInTextToString {
    private ITextSegment frame;
    private List<ITextReplacement> items = Lists.newArrayList();
    private int leadingLines = 4;
    private ITextRegionAccess textRegionAccess;
    private String title = "document snippet";
    private int trailingLines = 4;

    public TextRegionsInTextToString add(ITextReplacement region) {
        this.items.add(region);
        return this;
    }

    public TextRegionsInTextToString add(ITextSegment region, String title) {
        this.items.add(region.replaceWith(title));
        return this;
    }

    protected String box(String title, String content) {
        int titleLength = title.length() + 2;
        int left = Math.max((80 - titleLength) / 2, 3);
        StringBuilder result = new StringBuilder();
        result.append(Strings.repeat((String)"-", (int)left));
        result.append(" ");
        result.append(title);
        result.append(" ");
        if (left > 3) {
            result.append(Strings.repeat((String)"-", (int)(80 - left - titleLength)));
        }
        result.append("\n");
        result.append(org.eclipse.xtext.util.Strings.trimTrailingLineBreak((CharSequence)content));
        result.append("\n");
        result.append(Strings.repeat((String)"-", (int)80));
        return result.toString();
    }

    public ITextSegment getFrame() {
        if (this.frame != null) {
            return this.frame;
        }
        ITextRegionAccess access = this.getTextRegionAccess();
        if (access != null) {
            ITextSegment impactRegion = TextRegions.merge(this.items);
            List<ILineRegion> expandToLines = TextRegions.expandToLines(impactRegion, this.getLeadingLines(), this.getTrailingLines());
            return TextRegions.merge(expandToLines);
        }
        return null;
    }

    public List<ITextReplacement> getItems() {
        return this.items;
    }

    public int getLeadingLines() {
        return this.leadingLines;
    }

    public ITextRegionAccess getTextRegionAccess() {
        if (this.textRegionAccess != null) {
            return this.textRegionAccess;
        }
        Iterator<ITextReplacement> iterator = this.items.iterator();
        if (iterator.hasNext()) {
            ITextReplacement item = iterator.next();
            return item.getTextRegionAccess();
        }
        return null;
    }

    public String getTitle() {
        return this.title;
    }

    public int getTrailingLines() {
        return this.trailingLines;
    }

    public TextRegionsInTextToString setFrame(ITextSegment frame) {
        this.frame = frame;
        return this;
    }

    public TextRegionsInTextToString setLeadingLines(int leadingLines) {
        this.leadingLines = leadingLines;
        return this;
    }

    public TextRegionsInTextToString setTextRegionAccess(ITextRegionAccess textRegionAccess) {
        this.textRegionAccess = textRegionAccess;
        return this;
    }

    public TextRegionsInTextToString setTitle(String title) {
        this.title = title;
        return this;
    }

    public TextRegionsInTextToString setTrailingLines(int trailingLines) {
        this.trailingLines = trailingLines;
        return this;
    }

    public String toString() {
        ITextSegment frame;
        ITextRegionAccess access;
        block3: {
            try {
                access = this.getTextRegionAccess();
                frame = this.getFrame();
                if (access != null && frame != null) break block3;
                return "(null)";
            }
            catch (Exception e) {
                return this.box("error", String.valueOf(e.getMessage()) + "\n" + Throwables.getStackTraceAsString((Throwable)e));
            }
        }
        StringBuilder builder = new StringBuilder();
        String vizualized = access.getRewriter().renderToString(frame, this.items);
        builder.append(this.box(this.title, vizualized));
        return builder.toString();
    }
}

