/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.facet;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import org.eclipse.xtext.generator.IOutputConfigurationProvider;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.idea.facet.GeneratorConfigurationState;
import org.eclipse.xtext.idea.facet.GeneratorFacetEditorTab;
import org.eclipse.xtext.idea.facet.GeneratorFacetForm;
import org.jdom.Element;

public abstract class AbstractFacetConfiguration
implements FacetConfiguration {
    private GeneratorConfigurationState state;
    @Inject
    private IOutputConfigurationProvider outputConfigDefaults;

    public FacetEditorTab[] createEditorTabs(FacetEditorContext editorContext, FacetValidatorsManager validatorsManager) {
        GeneratorFacetForm uiForm = new GeneratorFacetForm(editorContext.getFacet().getModule());
        GeneratorFacetEditorTab facetEditorTab = new GeneratorFacetEditorTab(editorContext.getFacet(), uiForm);
        return new FacetEditorTab[]{facetEditorTab};
    }

    public GeneratorConfigurationState getState() {
        if (this.state == null) {
            this.state = this.createNewDefaultState();
        }
        return this.state;
    }

    public void loadState(GeneratorConfigurationState state) {
        this.state = state;
    }

    protected GeneratorConfigurationState createNewDefaultState() {
        OutputConfiguration defOutput = this.findDefaultOutputConfiguration();
        return new GeneratorConfigurationState(defOutput);
    }

    protected OutputConfiguration findDefaultOutputConfiguration() {
        OutputConfiguration defOutput = (OutputConfiguration)Iterables.find((Iterable)this.outputConfigDefaults.getOutputConfigurations(), (Predicate)new Predicate<OutputConfiguration>(){

            public boolean apply(OutputConfiguration conf) {
                return "DEFAULT_OUTPUT".equals(conf.getName());
            }
        });
        return defOutput;
    }

    public void readExternal(Element element) throws InvalidDataException {
    }

    public void writeExternal(Element element) throws WriteExternalException {
    }
}

