/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.lang;

import com.google.inject.Inject;
import com.intellij.lang.ASTNode;
import com.intellij.lang.DefaultASTFactoryImpl;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import com.intellij.psi.tree.IElementType;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.idea.lang.CreateElementType;
import org.eclipse.xtext.idea.lang.GrammarAwareErrorElementType;
import org.eclipse.xtext.idea.lang.GrammarAwarePsiErrorElement;
import org.eclipse.xtext.idea.nodemodel.IASTNodeAwareNodeModelBuilder;
import org.eclipse.xtext.idea.parser.TokenTypeProvider;
import org.eclipse.xtext.psi.impl.LeafXtextPsiElement;
import org.eclipse.xtext.psi.impl.LeafXtextPsiReferenceElement;
import org.eclipse.xtext.psi.tree.IGrammarAwareElementType;

public class BaseXtextASTFactory
extends DefaultASTFactoryImpl {
    @Inject
    private TokenTypeProvider tokenTypeProvider;

    public CompositeElement createComposite(IElementType type) {
        if (type instanceof CreateElementType) {
            CreateElementType userDataElementType = (CreateElementType)type;
            CompositeElement composite = this.createComposite(userDataElementType.getElementType());
            userDataElementType.getCreateCallback().onCreate((ASTNode)composite);
            return composite;
        }
        if (type instanceof GrammarAwareErrorElementType) {
            GrammarAwareErrorElementType grammarAwareErrorElementType = (GrammarAwareErrorElementType)type;
            return new GrammarAwarePsiErrorElement(grammarAwareErrorElementType.getElementType());
        }
        return super.createComposite(type);
    }

    public LeafElement createLeaf(IElementType type, CharSequence text) {
        if (type instanceof CreateElementType) {
            CreateElementType userDataElementType = (CreateElementType)type;
            LeafElement leafElement = this.createLeaf(userDataElementType.getElementType(), text);
            userDataElementType.getCreateCallback().onCreate((ASTNode)leafElement);
            return leafElement;
        }
        LeafElement leafElement = this.doCreateLeaf(type, text);
        leafElement.putUserData(IASTNodeAwareNodeModelBuilder.TOKEN_TYPE_KEY, (Object)type);
        return leafElement;
    }

    protected LeafElement doCreateLeaf(IElementType type, CharSequence text) {
        if (this.isWhitespace(type)) {
            return this.createWhitespace(type, text);
        }
        if (this.isComment(type)) {
            return this.createComment(type, text);
        }
        if (this.isCrossReference(type)) {
            return this.createCrossReference(type, text);
        }
        return new LeafXtextPsiElement(type, text);
    }

    protected boolean isComment(IElementType type) {
        return this.tokenTypeProvider.getCommentTokens().contains(type);
    }

    protected boolean isWhitespace(IElementType type) {
        return this.tokenTypeProvider.getWhitespaceTokens().contains(type);
    }

    protected boolean isCrossReference(IElementType type) {
        if (type instanceof IGrammarAwareElementType) {
            IGrammarAwareElementType grammarAwareElementType = (IGrammarAwareElementType)type;
            return grammarAwareElementType.getGrammarElement() instanceof CrossReference;
        }
        return false;
    }

    protected LeafElement createWhitespace(IElementType type, CharSequence text) {
        return new PsiWhiteSpaceImpl(text);
    }

    protected LeafElement createCrossReference(IElementType type, CharSequence text) {
        return new LeafXtextPsiReferenceElement(type, text);
    }
}

