/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.structureview;

import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewFactory;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.idea.structureview.IStructureViewTreeElementProvider;
import org.eclipse.xtext.idea.structureview.XtextFileAwareStructureViewBuilder;
import org.eclipse.xtext.idea.structureview.XtextFileTreeModel;
import org.eclipse.xtext.psi.impl.BaseXtextFile;
import org.eclipse.xtext.xbase.lib.Pure;

public abstract class AbstractStructureViewBuilder
implements XtextFileAwareStructureViewBuilder {
    @Accessors
    private BaseXtextFile xtextFile;

    public StructureView createStructureView(FileEditor fileEditor, Project project) {
        Editor _xifexpression = null;
        _xifexpression = fileEditor instanceof TextEditor ? ((TextEditor)fileEditor).getEditor() : null;
        Editor editor = _xifexpression;
        final XtextFileTreeModel model = this.createStructureViewModel(editor);
        IStructureViewTreeElementProvider structureViewTreeElementProvider = this.createStructureViewTreeElementProvider();
        model.setStructureViewTreeElementProvider(structureViewTreeElementProvider);
        StructureViewFactory _instance = StructureViewFactory.getInstance((Project)project);
        StructureView view = _instance.createStructureView(fileEditor, (StructureViewModel)model, project, false);
        this.configureStructureViewTreeElementProvider(structureViewTreeElementProvider, model, view);
        Disposer.register((Disposable)view, (Disposable)new Disposable(){

            public void dispose() {
                model.dispose();
            }
        });
        return view;
    }

    public XtextFileTreeModel createStructureViewModel(Editor editor) {
        return new XtextFileTreeModel(this.xtextFile, editor);
    }

    public abstract IStructureViewTreeElementProvider createStructureViewTreeElementProvider();

    public abstract void configureStructureViewTreeElementProvider(IStructureViewTreeElementProvider var1, XtextFileTreeModel var2, StructureView var3);

    @Pure
    public BaseXtextFile getXtextFile() {
        return this.xtextFile;
    }

    @Override
    public void setXtextFile(BaseXtextFile xtextFile) {
        this.xtextFile = xtextFile;
    }
}

