/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVoid;
import org.eclipse.xtext.util.Strings;

public class ImportManager {
    private Map<String, String> imports = Maps.newHashMap();
    private boolean organizeImports;
    private Set<String> thisTypeSimpleNames = Sets.newHashSet();
    private Set<String> thisTypeQualifiedNames = Sets.newHashSet();
    private final char innerTypeSeparator;
    private Pattern JAVA_LANG_PACK = Pattern.compile("java\\.lang\\.[\\w]+");
    private boolean thisCollidesWithJavaLang;

    public ImportManager(boolean organizeImports, char innerTypeSeparator) {
        this(organizeImports, null, innerTypeSeparator);
    }

    public ImportManager() {
        this(true, null);
    }

    public ImportManager(boolean organizeImports) {
        this(organizeImports, null);
    }

    public ImportManager(boolean organizeImports, JvmDeclaredType thisType) {
        this(organizeImports, thisType, '.');
    }

    public ImportManager(boolean organizeImports, JvmDeclaredType thisType, char innerTypeSeparator) {
        this.organizeImports = organizeImports;
        this.innerTypeSeparator = innerTypeSeparator;
        if (thisType != null) {
            this.thisTypeSimpleNames.add(thisType.getSimpleName());
            this.thisTypeQualifiedNames.add(thisType.getQualifiedName(innerTypeSeparator));
            this.thisCollidesWithJavaLang |= CodeGenUtil.isJavaLangType((String)thisType.getSimpleName());
            this.registerSimpleNamesOfInnerClasses(thisType, new LinkedHashSet<JvmType>());
        }
    }

    protected void registerSimpleNamesOfInnerClasses(JvmDeclaredType thisType, LinkedHashSet<JvmType> handled) {
        if (!handled.add((JvmType)thisType)) {
            return;
        }
        List nested = EcoreUtil2.typeSelect((List)thisType.getMembers(), JvmDeclaredType.class);
        for (JvmDeclaredType jvmDeclaredType : nested) {
            this.thisTypeSimpleNames.add(jvmDeclaredType.getSimpleName());
            this.thisTypeQualifiedNames.add(jvmDeclaredType.getQualifiedName(this.innerTypeSeparator));
            this.thisCollidesWithJavaLang |= CodeGenUtil.isJavaLangType((String)jvmDeclaredType.getSimpleName());
        }
        for (JvmTypeReference superType : thisType.getSuperTypes()) {
            if (!(superType.getType() instanceof JvmDeclaredType)) continue;
            this.registerSimpleNamesOfInnerClasses((JvmDeclaredType)superType.getType(), handled);
        }
    }

    public CharSequence serialize(JvmType type) {
        StringBuilder sb = new StringBuilder();
        this.appendType(type, sb);
        return sb;
    }

    public CharSequence serialize(Class<?> type) {
        StringBuilder sb = new StringBuilder();
        this.appendType(type, sb);
        return sb;
    }

    public void appendType(JvmType type, StringBuilder builder) {
        if (type instanceof JvmPrimitiveType || type instanceof JvmVoid || type instanceof JvmTypeParameter) {
            builder.append(type.getQualifiedName(this.innerTypeSeparator));
        } else if (type instanceof JvmArrayType) {
            this.appendType((JvmType)((JvmArrayType)type).getComponentType(), builder);
            builder.append("[]");
        } else {
            String shortName;
            String qualifiedName;
            String nameToImport = qualifiedName = type.getQualifiedName(this.innerTypeSeparator);
            String outerShortName = shortName = type.getSimpleName();
            if (this.shouldUseQualifiedNestedName(qualifiedName)) {
                JvmType outerContainer = type;
                while (outerContainer.eContainer() instanceof JvmType) {
                    outerContainer = (JvmType)outerContainer.eContainer();
                }
                if (type != outerContainer) {
                    outerShortName = outerContainer.getSimpleName();
                    if (!this.thisTypeQualifiedNames.contains(outerContainer.getQualifiedName(this.innerTypeSeparator)) && this.thisTypeSimpleNames.contains(outerShortName)) {
                        outerShortName = qualifiedName;
                        shortName = qualifiedName;
                    } else {
                        nameToImport = outerContainer.getQualifiedName(this.innerTypeSeparator);
                        shortName = String.valueOf(outerShortName) + qualifiedName.substring(nameToImport.length());
                    }
                }
            }
            this.appendType(qualifiedName, shortName, outerShortName, nameToImport, builder);
        }
    }

    protected boolean shouldUseQualifiedNestedName(String identifier) {
        return !identifier.startsWith("org.eclipse.xtext.xbase.lib.");
    }

    public void appendType(Class<?> type, StringBuilder builder) {
        if (type.isPrimitive()) {
            builder.append(type.getSimpleName());
        } else if (type.isArray()) {
            this.appendType(type.getComponentType(), builder);
            builder.append("[]");
        } else {
            String shortName;
            String qualifiedName;
            String nameToImport = qualifiedName = type.getCanonicalName();
            String outerShortName = shortName = type.getSimpleName();
            if (this.shouldUseQualifiedNestedName(qualifiedName)) {
                Class<?> outerContainer = type;
                while (outerContainer.getDeclaringClass() != null) {
                    outerContainer = outerContainer.getDeclaringClass();
                }
                if (type != outerContainer) {
                    outerShortName = outerContainer.getSimpleName();
                    if (!this.thisTypeQualifiedNames.contains(outerContainer.getCanonicalName()) && this.thisTypeSimpleNames.contains(outerShortName)) {
                        outerShortName = qualifiedName;
                        shortName = qualifiedName;
                    } else {
                        nameToImport = outerContainer.getCanonicalName();
                        shortName = String.valueOf(outerShortName) + qualifiedName.substring(nameToImport.length());
                    }
                }
            }
            this.appendType(qualifiedName, shortName, outerShortName, nameToImport, builder);
        }
    }

    protected void appendType(String qualifiedName, String shortName, String namespaceImport, StringBuilder builder) {
        this.appendType(qualifiedName, shortName, shortName, namespaceImport, builder);
    }

    protected void appendType(String qualifiedName, String shortName, String outerShortName, String namespaceImport, StringBuilder builder) {
        if (this.allowsSimpleName(namespaceImport, shortName)) {
            builder.append(shortName);
        } else if (this.needsQualifiedName(namespaceImport, shortName)) {
            builder.append(qualifiedName);
        } else if (this.imports.containsKey(outerShortName)) {
            if (namespaceImport.equals(this.imports.get(outerShortName))) {
                builder.append(shortName);
            } else {
                builder.append(qualifiedName);
            }
        } else {
            this.imports.put(outerShortName, namespaceImport);
            builder.append(shortName);
        }
    }

    protected boolean allowsSimpleName(String qualifiedName, String simpleName) {
        return this.thisTypeQualifiedNames.contains(qualifiedName) || (!this.thisCollidesWithJavaLang || !this.thisTypeSimpleNames.contains(simpleName)) && this.JAVA_LANG_PACK.matcher(qualifiedName).matches() || Strings.equal((String)qualifiedName, (String)simpleName);
    }

    protected boolean needsQualifiedName(String qualifiedName, String simpleName) {
        return !this.organizeImports || this.thisTypeSimpleNames.contains(simpleName) && !this.thisTypeQualifiedNames.contains(qualifiedName) || CodeGenUtil.isJavaLangType((String)simpleName);
    }

    public boolean addImportFor(JvmType type) {
        String simpleName;
        String qualifiedName = type.getQualifiedName(this.innerTypeSeparator);
        if (!(this.allowsSimpleName(qualifiedName, simpleName = type.getSimpleName()) || this.needsQualifiedName(qualifiedName, simpleName) || this.imports.containsKey(simpleName))) {
            this.imports.put(simpleName, qualifiedName);
            return true;
        }
        return false;
    }

    public List<String> getImports() {
        ArrayList result = Lists.newArrayList((Iterable)Sets.newLinkedHashSet(this.imports.values()));
        Collections.sort(result);
        return result;
    }
}

