/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.lib;

import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import com.google.common.io.Files;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.File;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.List;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.XbaseStandaloneSetup;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;

public class ArithmeticExtensionGenerator {
    private static String since = "2.3";
    private List<String> types = CollectionLiterals.newArrayList((Object[])new String[]{"double", "float", "long", "int", "char", "short", "byte"});
    private List<QualifiedName> comparators = CollectionLiterals.newArrayList((Object[])new QualifiedName[]{OperatorMapping.LESS_THAN, OperatorMapping.LESS_EQUALS_THAN, OperatorMapping.GREATER_THAN, OperatorMapping.GREATER_EQUALS_THAN, OperatorMapping.EQUALS, OperatorMapping.NOT_EQUALS});
    private List<QualifiedName> operators = CollectionLiterals.newArrayList((Object[])new QualifiedName[]{OperatorMapping.PLUS, OperatorMapping.MINUS, OperatorMapping.MULTIPLY, OperatorMapping.DIVIDE, OperatorMapping.MODULO, OperatorMapping.LESS_THAN, OperatorMapping.LESS_EQUALS_THAN, OperatorMapping.GREATER_THAN, OperatorMapping.GREATER_EQUALS_THAN, OperatorMapping.EQUALS, OperatorMapping.NOT_EQUALS});
    @Inject
    @Extension
    private OperatorMapping _operatorMapping;

    public static void main(String[] args) {
        XbaseStandaloneSetup _xbaseStandaloneSetup = new XbaseStandaloneSetup();
        Injector _createInjectorAndDoEMFRegistration = _xbaseStandaloneSetup.createInjectorAndDoEMFRegistration();
        ArithmeticExtensionGenerator _instance = (ArithmeticExtensionGenerator)_createInjectorAndDoEMFRegistration.getInstance(ArithmeticExtensionGenerator.class);
        _instance.generate();
    }

    public void generate() {
        try {
            File _file = new File("../org.eclipse.xtext.xbase.lib/src/org/eclipse/xtext/xbase/lib/");
            _file.mkdirs();
            for (String type : this.types) {
                String _className = this.className(type);
                String _plus = "../org.eclipse.xtext.xbase.lib/src/org/eclipse/xtext/xbase/lib/" + _className;
                String _plus_1 = String.valueOf(_plus) + ".java";
                File file = new File(_plus_1);
                CharSequence _xifexpression = null;
                boolean _exists = file.exists();
                if (_exists) {
                    String _xblockexpression = null;
                    String content = Files.toString((File)file, (Charset)Charsets.ISO_8859_1);
                    StringConcatenation _builder = new StringConcatenation();
                    String _startMarker = this.startMarker();
                    int _indexOf = content.indexOf(_startMarker);
                    String _substring = content.substring(0, _indexOf);
                    _builder.append((Object)_substring, "");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    CharSequence _generateAllOperations = this.generateAllOperations(type);
                    _builder.append((Object)_generateAllOperations, "\t");
                    _builder.newLineIfNotEmpty();
                    String _endMarker = this.endMarker();
                    int _indexOf_1 = content.indexOf(_endMarker);
                    String _endMarker_1 = this.endMarker();
                    int _length = _endMarker_1.length();
                    int _plus_2 = _indexOf_1 + _length;
                    String _substring_1 = content.substring(_plus_2);
                    _builder.append((Object)_substring_1, "");
                    _xblockexpression = _builder.toString();
                    _xifexpression = _xblockexpression;
                } else {
                    _xifexpression = this.generate(type);
                }
                CharSequence newContent = _xifexpression;
                StringConcatenation result = new StringConcatenation("\n");
                result.append((Object)newContent);
                Files.write((CharSequence)result, (File)file, (Charset)Charsets.ISO_8859_1);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public CharSequence generate(String type) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/*******************************************************************************");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Copyright (c) 2012 itemis AG (http://www.itemis.eu) and others.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* All rights reserved. This program and the accompanying materials");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* are made available under the terms of the Eclipse Public License v1.0");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* which accompanies this distribution, and is available at");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* http://www.eclipse.org/legal/epl-v10.html");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*******************************************************************************/");
        _builder.newLine();
        _builder.append((Object)"package org.eclipse.xtext.xbase.lib;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* This is an extension library for {@link ");
        String _wrapperType = this.wrapperType(type);
        _builder.append((Object)_wrapperType, " ");
        _builder.append((Object)"} numbers.");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* ");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author Jan Koehnlein - Code generator");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @since ");
        _builder.append((Object)since, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public class ");
        String _className = this.className(type);
        _builder.append((Object)_className, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _generateAllOperations = this.generateAllOperations(type);
        _builder.append((Object)_generateAllOperations, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateAllOperations(String type) {
        StringConcatenation _builder = new StringConcatenation();
        String _startMarker = this.startMarker();
        _builder.append((Object)_startMarker, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* The unary <code>minus</code> operator. This is the equivalent to the Java's <code>-</code> function.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* ");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param ");
        char _charAt = type.charAt(0);
        _builder.append((Object)Character.valueOf(_charAt), " ");
        _builder.append((Object)"  ");
        String _article = this.article(type);
        _builder.append((Object)_article, " ");
        _builder.append((Object)" ");
        String _wrapperType = this.wrapperType(type);
        String _firstLower = StringExtensions.toFirstLower((String)_wrapperType);
        _builder.append((Object)_firstLower, " ");
        _builder.append((Object)".");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* @return   <code>-");
        char _charAt_1 = type.charAt(0);
        _builder.append((Object)Character.valueOf(_charAt_1), " ");
        _builder.append((Object)"</code>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* @since ");
        _builder.append((Object)since, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"@Pure");
        _builder.newLine();
        _builder.append((Object)"@Inline(value=\"(-$1)\", constantExpression=true)");
        _builder.newLine();
        _builder.append((Object)"public static ");
        String _returnType = this.returnType(type, OperatorMapping.MINUS, type);
        _builder.append((Object)_returnType, "");
        _builder.append((Object)" ");
        QualifiedName _methodName = this._operatorMapping.getMethodName(OperatorMapping.MINUS);
        _builder.append((Object)_methodName, "");
        _builder.append((Object)"(");
        _builder.append((Object)type, "");
        _builder.append((Object)" ");
        char _charAt_2 = type.charAt(0);
        _builder.append((Object)Character.valueOf(_charAt_2), "");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"return -");
        char _charAt_3 = type.charAt(0);
        _builder.append((Object)Character.valueOf(_charAt_3), "\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* The postfix <code>decrement</code> operator. This is the equivalent to the Java's <code>--</code> postfix function.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* ");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param ");
        char _charAt_4 = type.charAt(0);
        _builder.append((Object)Character.valueOf(_charAt_4), " ");
        _builder.append((Object)"  ");
        String _article_1 = this.article(type);
        _builder.append((Object)_article_1, " ");
        _builder.append((Object)" ");
        String _wrapperType_1 = this.wrapperType(type);
        String _firstLower_1 = StringExtensions.toFirstLower((String)_wrapperType_1);
        _builder.append((Object)_firstLower_1, " ");
        _builder.append((Object)".");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* @return   <code>");
        char _charAt_5 = type.charAt(0);
        _builder.append((Object)Character.valueOf(_charAt_5), " ");
        _builder.append((Object)"--</code>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* @since 2.6");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"@Inline(value=\"$1--\")");
        _builder.newLine();
        _builder.append((Object)"public static ");
        _builder.append((Object)type, "");
        _builder.append((Object)" ");
        QualifiedName _methodName_1 = this._operatorMapping.getMethodName(OperatorMapping.MINUS_MINUS);
        _builder.append((Object)_methodName_1, "");
        _builder.append((Object)"(");
        _builder.append((Object)type, "");
        _builder.append((Object)" ");
        char _charAt_6 = type.charAt(0);
        _builder.append((Object)Character.valueOf(_charAt_6), "");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"throw new HardcodedInInterpreterException();");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* The postfix <code>decrement</code> operator. This is the equivalent to the Java's <code>--</code> postfix function.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* ");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param ");
        char _charAt_7 = type.charAt(0);
        _builder.append((Object)Character.valueOf(_charAt_7), " ");
        _builder.append((Object)"  ");
        String _article_2 = this.article(type);
        _builder.append((Object)_article_2, " ");
        _builder.append((Object)" ");
        String _wrapperType_2 = this.wrapperType(type);
        String _firstLower_2 = StringExtensions.toFirstLower((String)_wrapperType_2);
        _builder.append((Object)_firstLower_2, " ");
        _builder.append((Object)".");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* @return   <code>");
        char _charAt_8 = type.charAt(0);
        _builder.append((Object)Character.valueOf(_charAt_8), " ");
        _builder.append((Object)"--</code>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* @since 2.6");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"@Inline(value=\"$1--\")");
        _builder.newLine();
        _builder.append((Object)"public static ");
        String _wrapperType_3 = this.wrapperType(type);
        _builder.append((Object)_wrapperType_3, "");
        _builder.append((Object)" ");
        QualifiedName _methodName_2 = this._operatorMapping.getMethodName(OperatorMapping.MINUS_MINUS);
        _builder.append((Object)_methodName_2, "");
        _builder.append((Object)"(");
        String _wrapperType_4 = this.wrapperType(type);
        _builder.append((Object)_wrapperType_4, "");
        _builder.append((Object)" ");
        char _charAt_9 = type.charAt(0);
        _builder.append((Object)Character.valueOf(_charAt_9), "");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"throw new HardcodedInInterpreterException();");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* The postfix <code>increment</code> operator. This is the equivalent to the Java's <code>++</code> postfix function.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* ");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param ");
        char _charAt_10 = type.charAt(0);
        _builder.append((Object)Character.valueOf(_charAt_10), " ");
        _builder.append((Object)"  ");
        String _article_3 = this.article(type);
        _builder.append((Object)_article_3, " ");
        _builder.append((Object)" ");
        String _wrapperType_5 = this.wrapperType(type);
        String _firstLower_3 = StringExtensions.toFirstLower((String)_wrapperType_5);
        _builder.append((Object)_firstLower_3, " ");
        _builder.append((Object)".");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* @return   <code>");
        char _charAt_11 = type.charAt(0);
        _builder.append((Object)Character.valueOf(_charAt_11), " ");
        _builder.append((Object)"++</code>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* @since 2.6");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"@Inline(value=\"$1++\")");
        _builder.newLine();
        _builder.append((Object)"public static ");
        _builder.append((Object)type, "");
        _builder.append((Object)" ");
        QualifiedName _methodName_3 = this._operatorMapping.getMethodName(OperatorMapping.PLUS_PLUS);
        _builder.append((Object)_methodName_3, "");
        _builder.append((Object)"(");
        _builder.append((Object)type, "");
        _builder.append((Object)" ");
        char _charAt_12 = type.charAt(0);
        _builder.append((Object)Character.valueOf(_charAt_12), "");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"throw new HardcodedInInterpreterException();");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* The postfix <code>increment</code> operator. This is the equivalent to the Java's <code>++</code> postfix function.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* ");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param ");
        char _charAt_13 = type.charAt(0);
        _builder.append((Object)Character.valueOf(_charAt_13), " ");
        _builder.append((Object)"  ");
        String _article_4 = this.article(type);
        _builder.append((Object)_article_4, " ");
        _builder.append((Object)" ");
        String _wrapperType_6 = this.wrapperType(type);
        String _firstLower_4 = StringExtensions.toFirstLower((String)_wrapperType_6);
        _builder.append((Object)_firstLower_4, " ");
        _builder.append((Object)".");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* @return   <code>");
        char _charAt_14 = type.charAt(0);
        _builder.append((Object)Character.valueOf(_charAt_14), " ");
        _builder.append((Object)"++</code>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* @since 2.6");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"@Inline(value=\"$1++\")");
        _builder.newLine();
        _builder.append((Object)"public static ");
        String _wrapperType_7 = this.wrapperType(type);
        _builder.append((Object)_wrapperType_7, "");
        _builder.append((Object)" ");
        QualifiedName _methodName_4 = this._operatorMapping.getMethodName(OperatorMapping.PLUS_PLUS);
        _builder.append((Object)_methodName_4, "");
        _builder.append((Object)"(");
        String _wrapperType_8 = this.wrapperType(type);
        _builder.append((Object)_wrapperType_8, "");
        _builder.append((Object)" ");
        char _charAt_15 = type.charAt(0);
        _builder.append((Object)Character.valueOf(_charAt_15), "");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"throw new HardcodedInInterpreterException();");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        for (String other : this.types) {
            CharSequence _generateOperations = this.generateOperations(type, other);
            _builder.append((Object)_generateOperations, "");
            _builder.newLineIfNotEmpty();
        }
        String _endMarker = this.endMarker();
        _builder.append((Object)_endMarker, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence generateOperations(String op1, String op2) {
        StringConcatenation _builder = new StringConcatenation();
        for (QualifiedName operator : this.operators) {
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* The binary <code>");
            QualifiedName _methodName = this._operatorMapping.getMethodName(operator);
            String _string = _methodName.toString();
            String _replace = _string.replace("operator_", "");
            _builder.append((Object)_replace, " ");
            _builder.append((Object)"</code> operator. This is the equivalent to the Java <code>");
            String _html = this.toHtml(operator);
            _builder.append((Object)_html, " ");
            _builder.append((Object)"</code> operator.");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"* ");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* @param a  ");
            String _article = this.article(op1);
            _builder.append((Object)_article, " ");
            _builder.append((Object)" ");
            String _wrapperType = this.wrapperType(op1);
            String _firstLower = StringExtensions.toFirstLower((String)_wrapperType);
            _builder.append((Object)_firstLower, " ");
            _builder.append((Object)".");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"* @param b  ");
            String _article_1 = this.article(op2);
            _builder.append((Object)_article_1, " ");
            _builder.append((Object)" ");
            String _wrapperType_1 = this.wrapperType(op2);
            String _firstLower_1 = StringExtensions.toFirstLower((String)_wrapperType_1);
            _builder.append((Object)_firstLower_1, " ");
            _builder.append((Object)".");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"* @return   <code>a");
            String _html_1 = this.toHtml(operator);
            _builder.append((Object)_html_1, " ");
            _builder.append((Object)"b</code>");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"* @since ");
            _builder.append((Object)since, " ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)"@Pure");
            _builder.newLine();
            _builder.append((Object)"@Inline(value=\"($1 ");
            _builder.append((Object)operator, "");
            _builder.append((Object)" $2)\", constantExpression=true)");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"public static ");
            String _returnType = this.returnType(op1, operator, op2);
            _builder.append((Object)_returnType, "");
            _builder.append((Object)" ");
            QualifiedName _methodName_1 = this._operatorMapping.getMethodName(operator);
            _builder.append((Object)_methodName_1, "");
            _builder.append((Object)"(");
            _builder.append((Object)op1, "");
            _builder.append((Object)" a, ");
            _builder.append((Object)op2, "");
            _builder.append((Object)" b) {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"return a ");
            _builder.append((Object)operator, "\t");
            _builder.append((Object)" b;");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.newLine();
        }
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* The binary <code>power</code> operator. This is the equivalent to the Java's <code>Math.pow()</code> function.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* ");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param a  ");
        String _article_2 = this.article(op1);
        _builder.append((Object)_article_2, " ");
        _builder.append((Object)" ");
        String _wrapperType_2 = this.wrapperType(op1);
        String _firstLower_2 = StringExtensions.toFirstLower((String)_wrapperType_2);
        _builder.append((Object)_firstLower_2, " ");
        _builder.append((Object)".");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param b  ");
        String _article_3 = this.article(op2);
        _builder.append((Object)_article_3, " ");
        _builder.append((Object)" ");
        String _wrapperType_3 = this.wrapperType(op2);
        String _firstLower_3 = StringExtensions.toFirstLower((String)_wrapperType_3);
        _builder.append((Object)_firstLower_3, " ");
        _builder.append((Object)".");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* @return   <code>Math.pow(a, b)</code>");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @since ");
        _builder.append((Object)since, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"@Pure");
        _builder.newLine();
        _builder.append((Object)"@Inline(value=\"$3.pow($1, $2)\", imported=Math.class)");
        _builder.newLine();
        _builder.append((Object)"public static double ");
        QualifiedName _methodName_2 = this._operatorMapping.getMethodName(OperatorMapping.POWER);
        _builder.append((Object)_methodName_2, "");
        _builder.append((Object)"(");
        _builder.append((Object)op1, "");
        _builder.append((Object)" a, ");
        _builder.append((Object)op2, "");
        _builder.append((Object)" b) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"return Math.pow(a, b);");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* The <code>identity equals</code> operator. This is the equivalent to Java's <code>==</code>");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* operator.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* ");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param a  ");
        String _article_4 = this.article(op1);
        _builder.append((Object)_article_4, " ");
        _builder.append((Object)" ");
        String _wrapperType_4 = this.wrapperType(op1);
        String _firstLower_4 = StringExtensions.toFirstLower((String)_wrapperType_4);
        _builder.append((Object)_firstLower_4, " ");
        _builder.append((Object)".");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param b  ");
        String _article_5 = this.article(op2);
        _builder.append((Object)_article_5, " ");
        _builder.append((Object)" ");
        String _wrapperType_5 = this.wrapperType(op2);
        String _firstLower_5 = StringExtensions.toFirstLower((String)_wrapperType_5);
        _builder.append((Object)_firstLower_5, " ");
        _builder.append((Object)".");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* @return   <code>a == b</code>");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @since 2.4");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"@Pure");
        _builder.newLine();
        _builder.append((Object)"@Inline(value=\"($1 == $2)\", constantExpression=true)");
        _builder.newLine();
        _builder.append((Object)"public static boolean ");
        QualifiedName _methodName_3 = this._operatorMapping.getMethodName(OperatorMapping.TRIPLE_EQUALS);
        _builder.append((Object)_methodName_3, "");
        _builder.append((Object)"(");
        _builder.append((Object)op1, "");
        _builder.append((Object)" a, ");
        _builder.append((Object)op2, "");
        _builder.append((Object)" b) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"return a == b;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* The <code>identity not equals</code> operator. This is the equivalent to Java's <code>!=</code>");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* operator.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* ");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param a  ");
        String _article_6 = this.article(op1);
        _builder.append((Object)_article_6, " ");
        _builder.append((Object)" ");
        String _wrapperType_6 = this.wrapperType(op1);
        String _firstLower_6 = StringExtensions.toFirstLower((String)_wrapperType_6);
        _builder.append((Object)_firstLower_6, " ");
        _builder.append((Object)".");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param b  ");
        String _article_7 = this.article(op2);
        _builder.append((Object)_article_7, " ");
        _builder.append((Object)" ");
        String _wrapperType_7 = this.wrapperType(op2);
        String _firstLower_7 = StringExtensions.toFirstLower((String)_wrapperType_7);
        _builder.append((Object)_firstLower_7, " ");
        _builder.append((Object)".");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* @return   <code>a != b</code>");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @since 2.4");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"@Pure");
        _builder.newLine();
        _builder.append((Object)"@Inline(value=\"($1 != $2)\", constantExpression=true)");
        _builder.newLine();
        _builder.append((Object)"public static boolean ");
        QualifiedName _methodName_4 = this._operatorMapping.getMethodName(OperatorMapping.TRIPLE_NOT_EQUALS);
        _builder.append((Object)_methodName_4, "");
        _builder.append((Object)"(");
        _builder.append((Object)op1, "");
        _builder.append((Object)" a, ");
        _builder.append((Object)op2, "");
        _builder.append((Object)" b) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"return a != b;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    public String returnType(String o1, QualifiedName operator, String o2) {
        String _xifexpression = null;
        boolean _contains = this.comparators.contains(operator);
        if (_contains) {
            _xifexpression = "boolean";
        } else {
            String _xblockexpression = null;
            HashSet operands = CollectionLiterals.newHashSet((Object[])new String[]{o1, o2});
            String _xifexpression_1 = null;
            boolean _contains_1 = operands.contains("double");
            if (_contains_1) {
                _xifexpression_1 = "double";
            } else {
                String _xifexpression_2 = null;
                boolean _contains_2 = operands.contains("float");
                if (_contains_2) {
                    _xifexpression_2 = "float";
                } else {
                    String _xifexpression_3 = null;
                    boolean _contains_3 = operands.contains("long");
                    _xifexpression_3 = _contains_3 ? "long" : "int";
                    _xifexpression_2 = _xifexpression_3;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xblockexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public String article(String it) {
        String _switchResult = null;
        String _lowerCase = it.toLowerCase();
        String _substring = _lowerCase.substring(0, 1);
        boolean _matched = false;
        if (!_matched) {
            if (Objects.equal((Object)_substring, (Object)"a")) {
                _matched = true;
            }
            if (!_matched && Objects.equal((Object)_substring, (Object)"e")) {
                _matched = true;
            }
            if (!_matched && Objects.equal((Object)_substring, (Object)"i")) {
                _matched = true;
            }
            if (!_matched && Objects.equal((Object)_substring, (Object)"o")) {
                _matched = true;
            }
            if (!_matched && Objects.equal((Object)_substring, (Object)"u")) {
                _matched = true;
            }
            if (_matched) {
                _switchResult = "an";
            }
        }
        if (!_matched) {
            _switchResult = "a";
        }
        return _switchResult;
    }

    public String wrapperType(String it) {
        String _switchResult = null;
        boolean _matched = false;
        if (!_matched && Objects.equal((Object)it, (Object)"int")) {
            _matched = true;
            _switchResult = "Integer";
        }
        if (!_matched && Objects.equal((Object)it, (Object)"char")) {
            _matched = true;
            _switchResult = "Character";
        }
        if (!_matched) {
            _switchResult = StringExtensions.toFirstUpper((String)it);
        }
        return _switchResult;
    }

    public String className(String it) {
        String _wrapperType = this.wrapperType(it);
        return String.valueOf(_wrapperType) + "Extensions";
    }

    public String toHtml(QualifiedName it) {
        String _string = it.toString();
        String _replace = _string.replace("<", "&lt;");
        return _replace.replace(">", "&gt;");
    }

    public String startMarker() {
        return "// BEGIN generated code";
    }

    public String endMarker() {
        return "// END generated code\n";
    }
}

