/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.editor.contentassist;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistEntry;
import org.eclipse.xtext.ide.editor.contentassist.IIdeContentProposalAcceptor;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalPriorities;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

public class IdeCrossrefProposalProvider {
    private static final Logger LOG = Logger.getLogger(IdeCrossrefProposalProvider.class);
    @Inject
    @Accessors(value={AccessorType.PROTECTED_GETTER})
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private IdeContentProposalPriorities proposalPriorities;

    public void lookupCrossReference(IScope scope, CrossReference crossReference, ContentAssistContext context, IIdeContentProposalAcceptor acceptor, Predicate<IEObjectDescription> filter) {
        try {
            Iterable<IEObjectDescription> _queryScope = this.queryScope(scope, crossReference, context);
            for (IEObjectDescription candidate : _queryScope) {
                boolean _apply = filter.apply((Object)candidate);
                if (!_apply) continue;
                ContentAssistEntry entry = this.createProposal(candidate, crossReference, context);
                int _crossRefPriority = this.proposalPriorities.getCrossRefPriority(candidate, entry);
                acceptor.accept(entry, _crossRefPriority);
            }
        }
        catch (Throwable _t) {
            if (_t instanceof UnsupportedOperationException) {
                UnsupportedOperationException uoe = (UnsupportedOperationException)_t;
                LOG.error((Object)"Failed to create content assist proposals for cross-reference.", (Throwable)uoe);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    protected Iterable<IEObjectDescription> queryScope(IScope scope, CrossReference crossReference, ContentAssistContext context) {
        Iterable _xblockexpression = null;
        String _prefix = context.getPrefix();
        boolean _isEmpty = _prefix.isEmpty();
        if (_isEmpty) {
            return scope.getAllElements();
        }
        String _prefix_1 = context.getPrefix();
        final QualifiedName prefix = this.qualifiedNameConverter.toQualifiedName(_prefix_1);
        Iterable _allElements = scope.getAllElements();
        Functions.Function1<IEObjectDescription, Boolean> _function = new Functions.Function1<IEObjectDescription, Boolean>(){

            public Boolean apply(IEObjectDescription it) {
                return IdeCrossrefProposalProvider.this.matchesPrefix(it, prefix);
            }
        };
        _xblockexpression = IterableExtensions.filter((Iterable)_allElements, (Functions.Function1)_function);
        return _xblockexpression;
    }

    protected boolean matchesPrefix(IEObjectDescription candidate, QualifiedName prefix) {
        int _segmentCount;
        boolean _greaterThan;
        QualifiedName name = candidate.getName();
        int count = prefix.getSegmentCount();
        boolean bl = _greaterThan = count > (_segmentCount = name.getSegmentCount());
        if (_greaterThan) {
            return false;
        }
        int i = 0;
        while (i < count) {
            boolean _notEquals;
            String nameSegment = name.getSegment(i);
            String prefixSegment = prefix.getSegment(i);
            boolean _or = false;
            boolean _and = false;
            _and = i >= count - 1 ? false : (_notEquals = !Objects.equal((Object)nameSegment, (Object)prefixSegment));
            if (_and) {
                _or = true;
            } else {
                int _length;
                boolean _regionMatches;
                boolean _not;
                boolean _and_1 = false;
                _and_1 = i != count - 1 ? false : (_not = !(_regionMatches = nameSegment.regionMatches(true, 0, prefixSegment, 0, _length = prefixSegment.length())));
                _or = _and_1;
            }
            if (_or) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected ContentAssistEntry createProposal(final IEObjectDescription candidate, CrossReference crossRef, final ContentAssistContext context) {
        ContentAssistEntry _contentAssistEntry = new ContentAssistEntry();
        Procedures.Procedure1<ContentAssistEntry> _function = new Procedures.Procedure1<ContentAssistEntry>(){

            public void apply(ContentAssistEntry it) {
                String _prefix = context.getPrefix();
                it.setPrefix(_prefix);
                QualifiedName _name = candidate.getName();
                String _string = IdeCrossrefProposalProvider.this.qualifiedNameConverter.toString(_name);
                it.setProposal(_string);
                EClass _eClass = candidate.getEClass();
                String _name_1 = null;
                if (_eClass != null) {
                    _name_1 = _eClass.getName();
                }
                it.setDescription(_name_1);
            }
        };
        return (ContentAssistEntry)ObjectExtensions.operator_doubleArrow((Object)_contentAssistEntry, (Procedures.Procedure1)_function);
    }

    @Pure
    protected IQualifiedNameConverter getQualifiedNameConverter() {
        return this.qualifiedNameConverter;
    }
}

