/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.util;

import com.google.common.annotations.Beta;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.lang.annotation.Annotation;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;

@Singleton
@Beta
public class AnnotationLookup {
    @Inject
    private IJvmTypeProvider.Factory typeProviderFactory;
    @Inject
    private TypesFactory typesFactory;

    public JvmAnnotationReference findAnnotation(JvmAnnotationTarget annotationTarget, Class<? extends Annotation> lookupType) {
        if (annotationTarget.eIsSet((EStructuralFeature)TypesPackage.Literals.JVM_ANNOTATION_TARGET__ANNOTATIONS)) {
            for (JvmAnnotationReference annotation : annotationTarget.getAnnotations()) {
                JvmAnnotationType annotationType = annotation.getAnnotation();
                if (annotationType == null || !lookupType.getCanonicalName().equals(annotationType.getQualifiedName())) continue;
                return annotation;
            }
        }
        return null;
    }

    public JvmAnnotationReference removeAnnotation(JvmAnnotationTarget annotationTarget, Class<? extends Annotation> type) {
        JvmAnnotationReference result = this.findAnnotation(annotationTarget, type);
        if (result != null) {
            annotationTarget.getAnnotations().remove((Object)result);
            return result;
        }
        return null;
    }

    public JvmAnnotationReference findOrAddAnnotation(JvmAnnotationTarget annotationTarget, Notifier context, Class<? extends Annotation> type) {
        JvmAnnotationReference result = this.findAnnotation(annotationTarget, type);
        if (result != null) {
            return result;
        }
        JvmAnnotationType annotationType = this.findAnnotationType(type, context);
        if (annotationType != null) {
            result = this.typesFactory.createJvmAnnotationReference();
            result.setAnnotation(annotationType);
            return result;
        }
        return null;
    }

    private JvmAnnotationType findAnnotationType(Class<? extends Annotation> type, Notifier context) {
        ResourceSet resourceSet = EcoreUtil2.getResourceSet((Notifier)context);
        if (resourceSet == null) {
            return null;
        }
        IJvmTypeProvider typeProvider = this.typeProviderFactory.findOrCreateTypeProvider(resourceSet);
        try {
            JvmType result = typeProvider.findTypeByName(type.getName());
            if (result instanceof JvmAnnotationType) {
                return (JvmAnnotationType)result;
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public boolean isRepeatable(JvmAnnotationType annotationType) {
        for (JvmAnnotationReference metaAnnotation : annotationType.getAnnotations()) {
            if (!"java.lang.annotation.Repeatable".equals(metaAnnotation.getAnnotation().getIdentifier())) continue;
            return true;
        }
        return false;
    }
}

