/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.editor.contentassist;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistEntry;
import org.eclipse.xtext.ide.editor.contentassist.IIdeContentProposalAcceptor;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalPriorities;
import org.eclipse.xtext.ide.editor.contentassist.IdeCrossrefProposalProvider;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtext.CurrentTypeFinder;

public class IdeContentProposalProvider {
    @Inject
    @Accessors(value={AccessorType.PROTECTED_GETTER})
    private IScopeProvider scopeProvider;
    @Inject
    @Accessors(value={AccessorType.PROTECTED_GETTER})
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    @Accessors(value={AccessorType.PROTECTED_GETTER})
    private IdeCrossrefProposalProvider crossrefProposalProvider;
    @Inject
    @Accessors(value={AccessorType.PROTECTED_GETTER})
    private IdeContentProposalPriorities proposalPriorities;
    @Inject
    @Extension
    private CurrentTypeFinder _currentTypeFinder;

    public void createProposals(List<ContentAssistContext> contexts, IIdeContentProposalAcceptor acceptor) {
        ContentAssistContext selectedContext = null;
        for (ContentAssistContext context : contexts) {
            boolean _or = false;
            if (selectedContext == null) {
                _or = true;
            } else {
                boolean _and = false;
                boolean _isAcceptable = this.isAcceptable(context);
                if (!_isAcceptable) {
                    _and = false;
                } else {
                    boolean _isAcceptable_1;
                    boolean _not;
                    String _prefix_1;
                    int _length_1;
                    boolean _greaterThan;
                    boolean _or_1 = false;
                    String _prefix = context.getPrefix();
                    int _length = _prefix.length();
                    boolean bl = _greaterThan = _length > (_length_1 = (_prefix_1 = selectedContext.getPrefix()).length());
                    _or_1 = _greaterThan ? true : (_not = !(_isAcceptable_1 = this.isAcceptable(selectedContext)));
                    _and = _or_1;
                }
                _or = _and;
            }
            if (!_or) continue;
            selectedContext = context;
        }
        for (ContentAssistContext context_1 : contexts) {
            boolean _or_2 = false;
            if (context_1 == selectedContext) {
                _or_2 = true;
            } else {
                boolean _isAcceptable_2;
                String _prefix_3;
                boolean _and_1 = false;
                String _prefix_2 = context_1.getPrefix();
                boolean _equals = Objects.equal((Object)_prefix_2, (Object)(_prefix_3 = selectedContext.getPrefix()));
                _and_1 = !_equals ? false : (_isAcceptable_2 = this.isAcceptable(context_1));
                _or_2 = _and_1;
            }
            if (!_or_2) continue;
            ImmutableList<AbstractElement> _firstSetGrammarElements = context_1.getFirstSetGrammarElements();
            for (AbstractElement element : _firstSetGrammarElements) {
                boolean _not_1;
                boolean _canAcceptMoreProposals = acceptor.canAcceptMoreProposals();
                boolean bl = _not_1 = !_canAcceptMoreProposals;
                if (_not_1) {
                    return;
                }
                this.createProposals(element, context_1, acceptor);
            }
        }
    }

    protected boolean isAcceptable(ContentAssistContext context) {
        String prefix = context.getPrefix();
        boolean _or = false;
        boolean _isEmpty = prefix.isEmpty();
        if (_isEmpty) {
            _or = true;
        } else {
            boolean _isJavaIdentifierPart;
            int _length = prefix.length();
            int _minus = _length - 1;
            char _charAt = prefix.charAt(_minus);
            _or = _isJavaIdentifierPart = Character.isJavaIdentifierPart(_charAt);
        }
        return _or;
    }

    protected void _createProposals(AbstractElement element, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
    }

    protected void _createProposals(final Assignment assignment, final ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        AbstractElement terminal = assignment.getTerminal();
        if (terminal instanceof CrossReference) {
            AbstractElement _terminal = assignment.getTerminal();
            this.createProposals(_terminal, context, acceptor);
        } else if (terminal instanceof RuleCall) {
            final AbstractRule rule = ((RuleCall)terminal).getRule();
            boolean _and = false;
            if (!(rule instanceof TerminalRule)) {
                _and = false;
            } else {
                boolean _isEmpty;
                String _prefix = context.getPrefix();
                _and = _isEmpty = _prefix.isEmpty();
            }
            if (_and) {
                ContentAssistEntry _contentAssistEntry = new ContentAssistEntry();
                Procedures.Procedure1<ContentAssistEntry> _function = new Procedures.Procedure1<ContentAssistEntry>(){

                    public void apply(ContentAssistEntry it) {
                        String _prefix = context.getPrefix();
                        it.setPrefix(_prefix);
                        String _name = rule.getName();
                        boolean _equals = Objects.equal((Object)_name, (Object)"STRING");
                        if (_equals) {
                            String _feature = assignment.getFeature();
                            String _plus = "\"" + _feature;
                            String _plus_1 = String.valueOf(_plus) + "\"";
                            it.setProposal(_plus_1);
                            ArrayList<TextRegion> _editPositions = it.getEditPositions();
                            int _offset = context.getOffset();
                            int _plus_2 = _offset + 1;
                            String _proposal = it.getProposal();
                            int _length = _proposal.length();
                            int _minus = _length - 2;
                            TextRegion _textRegion = new TextRegion(_plus_2, _minus);
                            _editPositions.add(_textRegion);
                        } else {
                            String _feature_1 = assignment.getFeature();
                            it.setProposal(_feature_1);
                            ArrayList<TextRegion> _editPositions_1 = it.getEditPositions();
                            int _offset_1 = context.getOffset();
                            String _proposal_1 = it.getProposal();
                            int _length_1 = _proposal_1.length();
                            TextRegion _textRegion_1 = new TextRegion(_offset_1, _length_1);
                            _editPositions_1.add(_textRegion_1);
                        }
                        String _name_1 = rule.getName();
                        it.setDescription(_name_1);
                    }
                };
                ContentAssistEntry entry = (ContentAssistEntry)ObjectExtensions.operator_doubleArrow((Object)_contentAssistEntry, (Procedures.Procedure1)_function);
                int _defaultPriority = this.proposalPriorities.getDefaultPriority(entry);
                acceptor.accept(entry, _defaultPriority);
            }
        }
    }

    protected void _createProposals(final Keyword keyword, final ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        boolean _filterKeyword = this.filterKeyword(keyword, context);
        if (_filterKeyword) {
            ContentAssistEntry _contentAssistEntry = new ContentAssistEntry();
            Procedures.Procedure1<ContentAssistEntry> _function = new Procedures.Procedure1<ContentAssistEntry>(){

                public void apply(ContentAssistEntry it) {
                    String _prefix = context.getPrefix();
                    it.setPrefix(_prefix);
                    String _value = keyword.getValue();
                    it.setProposal(_value);
                }
            };
            ContentAssistEntry entry = (ContentAssistEntry)ObjectExtensions.operator_doubleArrow((Object)_contentAssistEntry, (Procedures.Procedure1)_function);
            String _value = keyword.getValue();
            int _keywordPriority = this.proposalPriorities.getKeywordPriority(_value, entry);
            acceptor.accept(entry, _keywordPriority);
        }
    }

    protected boolean filterKeyword(Keyword keyword, ContentAssistContext context) {
        String _prefix_2;
        int _length_2;
        String _value_1;
        int _length_1;
        boolean _greaterThan;
        String _prefix_1;
        int _length;
        String _prefix;
        boolean _and = false;
        String _value = keyword.getValue();
        boolean _regionMatches = _value.regionMatches(true, 0, _prefix = context.getPrefix(), 0, _length = (_prefix_1 = context.getPrefix()).length());
        _and = !_regionMatches ? false : (_greaterThan = (_length_1 = (_value_1 = keyword.getValue()).length()) > (_length_2 = (_prefix_2 = context.getPrefix()).length()));
        return _and;
    }

    protected void _createProposals(RuleCall ruleCall, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
    }

    protected void _createProposals(CrossReference reference, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        EReference ereference;
        EClassifier type = this._currentTypeFinder.findCurrentTypeAfter((AbstractElement)reference);
        if (type instanceof EClass && (ereference = GrammarUtil.getReference((CrossReference)reference, (EClass)((EClass)type))) != null) {
            EObject _currentModel = context.getCurrentModel();
            IScope scope = this.scopeProvider.getScope(_currentModel, ereference);
            Predicate _alwaysTrue = Predicates.alwaysTrue();
            this.crossrefProposalProvider.lookupCrossReference(scope, reference, context, acceptor, (Predicate<IEObjectDescription>)_alwaysTrue);
        }
    }

    protected void createProposals(AbstractElement assignment, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        if (assignment instanceof Assignment) {
            this._createProposals((Assignment)assignment, context, acceptor);
            return;
        }
        if (assignment instanceof CrossReference) {
            this._createProposals((CrossReference)assignment, context, acceptor);
            return;
        }
        if (assignment instanceof Keyword) {
            this._createProposals((Keyword)assignment, context, acceptor);
            return;
        }
        if (assignment instanceof RuleCall) {
            this._createProposals((RuleCall)assignment, context, acceptor);
            return;
        }
        if (assignment != null) {
            this._createProposals(assignment, context, acceptor);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(assignment, context, acceptor).toString());
    }

    @Pure
    protected IScopeProvider getScopeProvider() {
        return this.scopeProvider;
    }

    @Pure
    protected IQualifiedNameConverter getQualifiedNameConverter() {
        return this.qualifiedNameConverter;
    }

    @Pure
    protected IdeCrossrefProposalProvider getCrossrefProposalProvider() {
        return this.crossrefProposalProvider;
    }

    @Pure
    protected IdeContentProposalPriorities getProposalPriorities() {
        return this.proposalPriorities;
    }
}

