/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.documentation;

import com.google.inject.Inject;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.documentation.IEObjectDocumentationProvider;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.psi.PsiEObject;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class IdeaDeclarationDocumentationProvider {
    @Inject
    private IQualifiedNameProvider qNameProvider;
    @Inject
    private IEObjectDocumentationProvider eObjectDocProvider;

    protected String getElementInfo(PsiEObject element) {
        EObject obj = element.getEObject();
        QualifiedName name = this.qNameProvider.getFullyQualifiedName(obj);
        if (name != null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"<b>");
            EClass _eClass = obj.eClass();
            String _name = _eClass.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)" '");
            _builder.append((Object)name, "");
            _builder.append((Object)"'</b>");
            return _builder.toString();
        }
        Iterable _allContainers = EcoreUtil2.getAllContainers((EObject)obj);
        Functions.Function1<EObject, QualifiedName> _function = new Functions.Function1<EObject, QualifiedName>(){

            public QualifiedName apply(EObject it) {
                return IdeaDeclarationDocumentationProvider.this.qNameProvider.getFullyQualifiedName(it);
            }
        };
        Iterable _map = IterableExtensions.map((Iterable)_allContainers, (Functions.Function1)_function);
        Functions.Function1<QualifiedName, Boolean> _function_1 = new Functions.Function1<QualifiedName, Boolean>(){

            public Boolean apply(QualifiedName it) {
                return it != null;
            }
        };
        QualifiedName container = (QualifiedName)IterableExtensions.findFirst((Iterable)_map, (Functions.Function1)_function_1);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append((Object)"<b>");
        EClass _eClass_1 = obj.eClass();
        String _name_1 = _eClass_1.getName();
        _builder_1.append((Object)_name_1, "");
        _builder_1.append((Object)" in '");
        _builder_1.append((Object)container, "");
        _builder_1.append((Object)"'</b>");
        return _builder_1.toString();
    }

    protected String getFileInfo(PsiEObject element) {
        EObject _eObject = element.getEObject();
        Resource resource = _eObject.eResource();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module != null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"[");
            String _name = module.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)"] ");
            URI _uRI = resource.getURI();
            String _lastSegment = _uRI.lastSegment();
            _builder.append((Object)_lastSegment, "");
            return _builder.toString();
        }
        URI _uRI_1 = resource.getURI();
        return _uRI_1.lastSegment();
    }

    public String getQuickNavigateInfo(PsiEObject element) {
        StringConcatenation _builder = new StringConcatenation();
        String _elementInfo = this.getElementInfo(element);
        _builder.append((Object)_elementInfo, "");
        _builder.newLineIfNotEmpty();
        String _fileInfo = this.getFileInfo(element);
        _builder.append((Object)_fileInfo, "");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public String generateDoc(PsiEObject element) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<p>");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _elementInfo = this.getElementInfo(element);
        _builder.append((Object)_elementInfo, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"</p>");
        _builder.newLine();
        _builder.append((Object)"<br/>");
        _builder.newLine();
        _builder.append((Object)"<p>");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _fileInfo = this.getFileInfo(element);
        _builder.append((Object)_fileInfo, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"</p>");
        _builder.newLine();
        _builder.append((Object)"<br/>");
        _builder.newLine();
        _builder.append((Object)"<p>");
        _builder.newLine();
        _builder.append((Object)"\t");
        EObject _eObject = element.getEObject();
        String _documentation = this.eObjectDocProvider.getDocumentation(_eObject);
        _builder.append((Object)_documentation, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"</p>");
        _builder.newLine();
        return _builder.toString();
    }
}

