/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.editorActions;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.intellij.psi.tree.TokenSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.xtext.idea.editorActions.AbstractAutoEditBlock;
import org.eclipse.xtext.idea.editorActions.AbstractIndentableAutoEditBlock;
import org.eclipse.xtext.idea.editorActions.AutoEditBlockProvider;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

public abstract class AbstractAutoEditBlockProvider
implements AutoEditBlockProvider {
    private final List<AbstractAutoEditBlock> quotes;
    private final Multimap<TokenSet, AbstractIndentableAutoEditBlock> blocks;
    @Inject
    private Injector injector;

    public AbstractAutoEditBlockProvider() {
        LinkedListMultimap _create;
        LinkedList _newLinkedList;
        this.quotes = _newLinkedList = CollectionLiterals.newLinkedList((Object[])new AbstractAutoEditBlock[0]);
        this.blocks = _create = LinkedListMultimap.create();
    }

    protected void registerQuote(AbstractAutoEditBlock quote) {
        this.injector.injectMembers((Object)quote);
        this.quotes.add(quote);
    }

    protected void registerBlock(TokenSet tokenSet, AbstractIndentableAutoEditBlock block) {
        this.injector.injectMembers((Object)block);
        this.blocks.put((Object)tokenSet, (Object)block);
    }

    @Override
    public Iterable<AbstractAutoEditBlock> getQuotes() {
        return this.quotes;
    }

    @Override
    public Iterable<AbstractIndentableAutoEditBlock> getBlocks(TokenSet tokenSet) {
        return this.blocks.get((Object)tokenSet);
    }
}

