/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.highlighting;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.xtext.idea.highlighting.IHighlightingConfiguration;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

@Singleton
@Log
public class IdeaHighlightingAttributesProvider {
    @Inject
    @Named(value="languageName")
    private String languageId;
    @Inject
    private IHighlightingConfiguration highlightingConfiguration;
    private List<AttributesDescriptor> attributesDescriptors;
    private Map<String, HighlightInfoType> name2highlightInfoType;
    private Map<String, String> xtextStyle2xtextStyleRedirectMap;
    private static final Logger LOG = Logger.getLogger(IdeaHighlightingAttributesProvider.class);

    protected void initialize() {
        boolean _equals = Objects.equal(this.attributesDescriptors, null);
        if (_equals) {
            HashMap _newHashMap_1;
            HashMap _newHashMap;
            ArrayList _newArrayList;
            this.attributesDescriptors = _newArrayList = CollectionLiterals.newArrayList((Object[])new AttributesDescriptor[0]);
            this.name2highlightInfoType = _newHashMap = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
            this.xtextStyle2xtextStyleRedirectMap = _newHashMap_1 = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
            this.highlightingConfiguration.configure(new IHighlightingConfiguration.IHighlightingStyleAcceptor(){

                @Override
                public TextAttributesKey addStyle(String xtextStyleId, String displayName, TextAttributesKey fallbackKey) {
                    HighlightInfoType _addHighlightingConfiguration = IdeaHighlightingAttributesProvider.this.addHighlightingConfiguration(xtextStyleId, displayName, fallbackKey);
                    return _addHighlightingConfiguration.getAttributesKey();
                }

                @Override
                public void addRedirect(String fromXtextStyleId, String toXtextStyleId) {
                    String _put;
                    boolean _tripleNotEquals;
                    boolean _containsKey = IdeaHighlightingAttributesProvider.this.name2highlightInfoType.containsKey(fromXtextStyleId);
                    if (_containsKey) {
                        LOG.error((Object)("Redirected highlighting style " + fromXtextStyleId + " already registered."));
                    }
                    boolean bl = _tripleNotEquals = (_put = IdeaHighlightingAttributesProvider.this.xtextStyle2xtextStyleRedirectMap.put(fromXtextStyleId, toXtextStyleId)) != null;
                    if (_tripleNotEquals) {
                        LOG.error((Object)("Duplicate redirected highlighting style " + fromXtextStyleId + "."));
                    }
                }
            });
        }
    }

    protected HighlightInfoType addHighlightingConfiguration(String simpleStyleName, String displayName, TextAttributesKey fallbackKey) {
        TextAttributesKey textAttributesKey = TextAttributesKey.createTextAttributesKey((String)(this.languageId + "." + simpleStyleName), (TextAttributesKey)fallbackKey);
        AttributesDescriptor attributeDescriptor = new AttributesDescriptor(displayName, textAttributesKey);
        this.attributesDescriptors.add(attributeDescriptor);
        HighlightInfoType.HighlightInfoTypeImpl highlightInfoType = new HighlightInfoType.HighlightInfoTypeImpl(HighlightInfoType.SYMBOL_TYPE_SEVERITY, textAttributesKey);
        this.name2highlightInfoType.put(simpleStyleName, (HighlightInfoType)highlightInfoType);
        return highlightInfoType;
    }

    public HighlightInfoType getHighlightInfoType(String xtextStyle) {
        this.initialize();
        String _elvis = null;
        String _get = this.xtextStyle2xtextStyleRedirectMap.get(xtextStyle);
        _elvis = _get != null ? _get : xtextStyle;
        String realId = _elvis;
        HighlightInfoType _elvis_1 = null;
        HighlightInfoType _get_1 = this.name2highlightInfoType.get(realId);
        if (_get_1 != null) {
            _elvis_1 = _get_1;
        } else {
            HighlightInfoType _xblockexpression = null;
            LOG.error((Object)("Highlighting style " + realId + " has not been registered."));
            _elvis_1 = _xblockexpression = this.addHighlightingConfiguration(realId, realId + " (unregistered) ", DefaultLanguageHighlighterColors.LINE_COMMENT);
        }
        return _elvis_1;
    }

    public TextAttributesKey getTextAttributesKey(String xtextStyle) {
        HighlightInfoType _highlightInfoType = this.getHighlightInfoType(xtextStyle);
        TextAttributesKey _attributesKey = null;
        if (_highlightInfoType != null) {
            _attributesKey = _highlightInfoType.getAttributesKey();
        }
        return _attributesKey;
    }

    public Map<String, TextAttributesKey> getXtextStyle2TextAttributes() {
        Set<Map.Entry<String, HighlightInfoType>> _entrySet = this.name2highlightInfoType.entrySet();
        Functions.Function1<Map.Entry<String, HighlightInfoType>, Pair<String, TextAttributesKey>> _function = new Functions.Function1<Map.Entry<String, HighlightInfoType>, Pair<String, TextAttributesKey>>(){

            public Pair<String, TextAttributesKey> apply(Map.Entry<String, HighlightInfoType> it) {
                String _key = it.getKey();
                HighlightInfoType _value = it.getValue();
                TextAttributesKey _attributesKey = _value.getAttributesKey();
                return Pair.of((Object)_key, (Object)_attributesKey);
            }
        };
        Iterable _map = IterableExtensions.map(_entrySet, (Functions.Function1)_function);
        return CollectionLiterals.newHashMap((Pair[])((Pair[])Conversions.unwrapArray((Object)_map, Pair.class)));
    }

    public Iterable<AttributesDescriptor> getAttributesDescriptors() {
        List<AttributesDescriptor> _xblockexpression = null;
        this.initialize();
        _xblockexpression = this.attributesDescriptors;
        return _xblockexpression;
    }
}

