/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.parser;

import com.google.inject.Inject;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import javax.inject.Provider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.idea.lang.IElementTypeProvider;
import org.eclipse.xtext.idea.parser.TokenTypeProvider;
import org.eclipse.xtext.psi.impl.PsiEObjectImpl;
import org.eclipse.xtext.psi.impl.PsiEObjectReference;
import org.eclipse.xtext.psi.tree.IGrammarAwareElementType;
import org.eclipse.xtext.xbase.lib.Pure;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractXtextParserDefinition
implements ParserDefinition {
    @Inject
    private Provider<Lexer> lexerProvider;
    @Inject
    private TokenTypeProvider tokenTypeProvider;
    @Inject
    private Provider<PsiParser> psiParserProvider;
    @Inject
    @Accessors(value={AccessorType.PROTECTED_GETTER})
    private IElementTypeProvider elementTypeProvider;

    @NotNull
    public Lexer createLexer(Project project) {
        return (Lexer)this.lexerProvider.get();
    }

    public IFileElementType getFileNodeType() {
        return this.elementTypeProvider.getFileType();
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        return TokenSet.EMPTY;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        return TokenSet.EMPTY;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        return this.tokenTypeProvider.getStringLiteralTokens();
    }

    @NotNull
    public PsiParser createParser(Project project) {
        return (PsiParser)this.psiParserProvider.get();
    }

    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        Lexer _get = (Lexer)this.lexerProvider.get();
        return LanguageUtil.canStickTokensTogetherByLexer((ASTNode)left, (ASTNode)right, (Lexer)_get);
    }

    public PsiElement createElement(ASTNode node) {
        PsiEObjectImpl _xblockexpression = null;
        IElementType _elementType = node.getElementType();
        boolean _isCrossReference = this.isCrossReference(_elementType);
        if (_isCrossReference) {
            return new PsiEObjectReference(node);
        }
        _xblockexpression = new PsiEObjectImpl(node);
        return _xblockexpression;
    }

    protected boolean isCrossReference(IElementType type) {
        boolean _xifexpression = false;
        if (type instanceof IGrammarAwareElementType) {
            EObject _grammarElement = ((IGrammarAwareElementType)type).getGrammarElement();
            _xifexpression = _grammarElement instanceof CrossReference;
        } else {
            _xifexpression = false;
        }
        return _xifexpression;
    }

    @Pure
    protected IElementTypeProvider getElementTypeProvider() {
        return this.elementTypeProvider;
    }
}

