/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.resource;

import com.google.common.base.Objects;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class VirtualFileURIUtil {
    public static URI getURI(VirtualFile file) {
        boolean _isDirectory = file.isDirectory();
        if (_isDirectory) {
            String _url = file.getUrl();
            String _plus = _url + "/";
            return URI.createURI((String)_plus);
        }
        String _url_1 = file.getUrl();
        return URI.createURI((String)_url_1);
    }

    public static VirtualFile getVirtualFile(URI uri) {
        String _string = uri.toString();
        String url = VfsUtil.fixURLforIDEA((String)_string);
        VirtualFileManager _instance = VirtualFileManager.getInstance();
        return _instance.findFileByUrl(url);
    }

    public static VirtualFile getOrCreateVirtualFile(URI uri) {
        return VirtualFileURIUtil.getOrCreateFile(uri, false);
    }

    private static VirtualFile getOrCreateFile(URI uri, boolean isDirectory) {
        try {
            boolean _equals;
            boolean _notEquals;
            VirtualFile file = VirtualFileURIUtil.getVirtualFile(uri);
            boolean bl = _notEquals = !Objects.equal((Object)file, null);
            if (_notEquals) {
                return file;
            }
            int _segmentCount = uri.segmentCount();
            boolean bl2 = _equals = _segmentCount == 0;
            if (_equals) {
                throw new IllegalStateException("couldn't find virtual file for " + uri);
            }
            URI _trimSegments = uri.trimSegments(1);
            VirtualFile parent = VirtualFileURIUtil.getOrCreateFile(_trimSegments, true);
            if (isDirectory) {
                String _lastSegment = uri.lastSegment();
                return VfsUtil.createDirectoryIfMissing((VirtualFile)parent, (String)_lastSegment);
            }
            String _lastSegment_1 = uri.lastSegment();
            return parent.findOrCreateChildData((Object)uri, _lastSegment_1);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

