/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.structureview;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.navigation.ItemPresentation;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.idea.presentation.ItemPresentationProvider;
import org.eclipse.xtext.idea.structureview.EObjectTreeElement;
import org.eclipse.xtext.idea.structureview.EStructuralFeatureTreeElement;
import org.eclipse.xtext.idea.structureview.IStructureViewTreeElementProvider;
import org.eclipse.xtext.idea.structureview.XtextFileTreeElement;
import org.eclipse.xtext.psi.impl.BaseXtextFile;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
public class DefaultStructureViewTreeElementProvider
implements IStructureViewTreeElementProvider {
    @Inject
    private Provider<EObjectTreeElement> objectTreeElementProvider;
    @Inject
    @Extension
    protected ItemPresentationProvider itemPresentationProvider;
    @Inject
    private Provider<EStructuralFeatureTreeElement> structuralFeatureTreeElementProvider;

    protected void _buildChildren(StructureViewTreeElement structureViewTreeElement) {
    }

    protected void _buildChildren(XtextFileTreeElement it) {
        String _presentableText;
        boolean _equals_1;
        BaseXtextFile _element = (BaseXtextFile)it.getElement();
        XtextResource _resource = _element.getResource();
        EList _contents = _resource.getContents();
        EObject modelElement = (EObject)IterableExtensions.head((Iterable)_contents);
        boolean _equals = Objects.equal((Object)modelElement, null);
        if (_equals) {
            return;
        }
        ItemPresentation _elvis = null;
        ItemPresentation _itemPresentation = this.itemPresentationProvider.getItemPresentation(modelElement);
        if (_itemPresentation != null) {
            _elvis = _itemPresentation;
        } else {
            PresentationData _presentationData = new PresentationData();
            _elvis = _presentationData;
        }
        ItemPresentation itemPresentation = _elvis;
        if (itemPresentation instanceof PresentationData && (_equals_1 = Objects.equal((Object)(_presentableText = ((PresentationData)itemPresentation).getPresentableText()), null))) {
            Resource _eResource = modelElement.eResource();
            URI _uRI = _eResource.getURI();
            URI _trimFileExtension = _uRI.trimFileExtension();
            String _lastSegment = _trimFileExtension.lastSegment();
            ((PresentationData)itemPresentation).setPresentableText(_lastSegment);
        }
        BaseXtextFile _element_1 = (BaseXtextFile)it.getElement();
        boolean _isLeaf = this.isLeaf(modelElement);
        EObjectTreeElement _createEObjectTreeElement = this.createEObjectTreeElement(modelElement, _element_1, _isLeaf, itemPresentation);
        it.addChild(_createEObjectTreeElement);
    }

    protected void _buildChildren(final EObjectTreeElement it) {
        EObject _object = it.getObject();
        EList _eContents = _object.eContents();
        Functions.Function1<EObject, StructureViewTreeElement> _function = new Functions.Function1<EObject, StructureViewTreeElement>(){

            public StructureViewTreeElement apply(EObject child) {
                return DefaultStructureViewTreeElementProvider.this.createEObjectTreeElement(child, it.xtextFile);
            }
        };
        List _map = ListExtensions.map((List)_eContents, (Functions.Function1)_function);
        it.addChildren(_map);
    }

    protected void _buildChildren(final EStructuralFeatureTreeElement it) {
        EStructuralFeature _feature;
        EObject _owner = it.getOwner();
        Object values = _owner.eGet(_feature = it.getFeature());
        if (values instanceof List) {
            EStructuralFeature _feature_1 = it.getFeature();
            boolean _isMany = _feature_1.isMany();
            if (_isMany) {
                Iterable _filter = Iterables.filter((Iterable)((Iterable)values), EObject.class);
                Functions.Function1<EObject, StructureViewTreeElement> _function = new Functions.Function1<EObject, StructureViewTreeElement>(){

                    public StructureViewTreeElement apply(EObject value) {
                        return DefaultStructureViewTreeElementProvider.this.createEObjectTreeElement(value, it.xtextFile);
                    }
                };
                Iterable _map = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function);
                it.addChildren(_map);
            }
        } else if (values instanceof EObject) {
            EObjectTreeElement _createEObjectTreeElement = this.createEObjectTreeElement((EObject)values, it.xtextFile);
            it.addChild(_createEObjectTreeElement);
        }
    }

    protected EObjectTreeElement createEObjectTreeElement(EObject modelElement, BaseXtextFile xtextFile) {
        boolean _isLeaf = this.isLeaf(modelElement);
        ItemPresentation _itemPresentation = this.itemPresentationProvider.getItemPresentation(modelElement);
        return this.createEObjectTreeElement(modelElement, xtextFile, _isLeaf, _itemPresentation);
    }

    protected EObjectTreeElement createEObjectTreeElement(final EObject modelElement, final BaseXtextFile xtextFile, final boolean leaf, final ItemPresentation itemPresentation) {
        boolean _equals;
        EObjectTreeElement _xblockexpression = null;
        boolean _and = false;
        String _presentableText = null;
        if (itemPresentation != null) {
            _presentableText = itemPresentation.getPresentableText();
        }
        if (_and = !(_equals = Objects.equal((Object)_presentableText, null)) ? false : leaf) {
            return null;
        }
        EObjectTreeElement _get = (EObjectTreeElement)this.objectTreeElementProvider.get();
        Procedures.Procedure1<EObjectTreeElement> _function = new Procedures.Procedure1<EObjectTreeElement>(){

            public void apply(EObjectTreeElement objectTreeElement) {
                objectTreeElement.setObject(modelElement);
                objectTreeElement.xtextFile = xtextFile;
                objectTreeElement.setLeaf(leaf);
                objectTreeElement.setItemPresentation(itemPresentation);
                objectTreeElement.setStructureViewTreeElementProvider(DefaultStructureViewTreeElementProvider.this);
            }
        };
        _xblockexpression = (EObjectTreeElement)ObjectExtensions.operator_doubleArrow((Object)_get, (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    protected EStructuralFeatureTreeElement createEStructuralFeatureTreeElement(final EObject modelElement, final EStructuralFeature feature, final BaseXtextFile xtextFile, final boolean leaf, final ItemPresentation itemPresentation) {
        EStructuralFeatureTreeElement _get = (EStructuralFeatureTreeElement)this.structuralFeatureTreeElementProvider.get();
        Procedures.Procedure1<EStructuralFeatureTreeElement> _function = new Procedures.Procedure1<EStructuralFeatureTreeElement>(){

            public void apply(EStructuralFeatureTreeElement structuralFeatureTreeElement) {
                structuralFeatureTreeElement.setOwner(modelElement);
                structuralFeatureTreeElement.setFeature(feature);
                structuralFeatureTreeElement.xtextFile = xtextFile;
                structuralFeatureTreeElement.setLeaf(leaf);
                structuralFeatureTreeElement.setItemPresentation(itemPresentation);
                structuralFeatureTreeElement.setStructureViewTreeElementProvider(DefaultStructureViewTreeElementProvider.this);
            }
        };
        return (EStructuralFeatureTreeElement)ObjectExtensions.operator_doubleArrow((Object)_get, (Procedures.Procedure1)_function);
    }

    protected boolean isLeaf(final EObject modelElement) {
        Functions.Function1<EReference, Boolean> _function;
        EClass _eClass = modelElement.eClass();
        EList _eAllContainments = _eClass.getEAllContainments();
        boolean _exists = IterableExtensions.exists((Iterable)_eAllContainments, (Functions.Function1)(_function = new Functions.Function1<EReference, Boolean>(){

            public Boolean apply(EReference containmentRef) {
                return modelElement.eIsSet((EStructuralFeature)containmentRef);
            }
        }));
        return !_exists;
    }

    @Override
    public void buildChildren(StructureViewTreeElement it) {
        if (it instanceof EObjectTreeElement) {
            this._buildChildren((EObjectTreeElement)it);
            return;
        }
        if (it instanceof EStructuralFeatureTreeElement) {
            this._buildChildren((EStructuralFeatureTreeElement)it);
            return;
        }
        if (it instanceof XtextFileTreeElement) {
            this._buildChildren((XtextFileTreeElement)it);
            return;
        }
        if (it != null) {
            this._buildChildren(it);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }
}

