/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.idea.framework;

import com.google.inject.Inject;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.framework.addSupport.FrameworkSupportInModuleConfigurable;
import com.intellij.framework.detection.FacetBasedFrameworkDetector;
import com.intellij.framework.detection.FileContentPattern;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModelImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.IdeaModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.util.indexing.FileContent;
import org.eclipse.xtend.core.idea.facet.XtendFacetConfiguration;
import org.eclipse.xtend.core.idea.facet.XtendFacetType;
import org.eclipse.xtend.core.idea.framework.XtendFrameworkSupportProvider;
import org.eclipse.xtend.core.idea.lang.XtendFileType;
import org.eclipse.xtend.core.idea.lang.XtendLanguage;
import org.eclipse.xtext.idea.util.ProjectLifecycleUtil;

public class XtendFrameworkDetector
extends FacetBasedFrameworkDetector<Facet<XtendFacetConfiguration>, XtendFacetConfiguration> {
    @Inject
    private XtendFrameworkSupportProvider frameworkSupport;
    @Inject
    ProjectLifecycleUtil projectUtil;

    public XtendFrameworkDetector() {
        super("xtend");
        XtendLanguage.INSTANCE.injectMembers((Object)this);
    }

    public void setupFacet(Facet<XtendFacetConfiguration> facet, ModifiableRootModel model) {
        super.setupFacet(facet, model);
        final Module module = model.getModule();
        VirtualFile[] roots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        VirtualFile baseDir = roots.length > 0 ? roots[0] : module.getProject().getBaseDir();
        String baseDirectoryForLibraries = baseDir != null ? baseDir.getPath() : "";
        LibrariesContainer librariesContainer = LibrariesContainerFactory.createContainer((Project)module.getProject());
        FrameworkSupportModelImpl frameworkModel = new FrameworkSupportModelImpl(module.getProject(), baseDirectoryForLibraries, librariesContainer);
        final FrameworkSupportInModuleConfigurable configurable = this.frameworkSupport.createConfigurable((FrameworkSupportModel)frameworkModel);
        final IdeaModifiableModelsProvider modelsProvider = new IdeaModifiableModelsProvider();
        if (this.projectUtil.isProjectReadyForPsiAccess(module.getProject())) {
            configurable.addSupport(module, model, (ModifiableModelsProvider)modelsProvider);
        } else {
            this.projectUtil.executeWritableWhenProjectReady(module.getProject(), new Runnable(){

                @Override
                public void run() {
                    ModifiableRootModel modifiableModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
                    configurable.addSupport(module, modifiableModel, (ModifiableModelsProvider)modelsProvider);
                    modelsProvider.commitModuleModifiableModel(modifiableModel);
                }
            });
        }
    }

    public FacetType<Facet<XtendFacetConfiguration>, XtendFacetConfiguration> getFacetType() {
        return FacetTypeRegistry.getInstance().findFacetType(XtendFacetType.TYPEID);
    }

    public FileType getFileType() {
        return XtendFileType.INSTANCE;
    }

    public ElementPattern<FileContent> createSuitableFilePattern() {
        return FileContentPattern.fileContent().withName(StandardPatterns.string().endsWith(".xtend"));
    }
}

