/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.idea.presentation;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.intellij.psi.PsiElement;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import javax.swing.Icon;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.core.idea.presentation.XtendJvmItemPresentationProvider;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.xtend.AnonymousClass;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendConstructor;
import org.eclipse.xtend.core.xtend.XtendEnumLiteral;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendInterface;
import org.eclipse.xtend.core.xtend.XtendParameter;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmEnumerationLiteral;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedConstructor;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedField;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedOperation;
import org.eclipse.xtext.xbase.validation.UIStrings;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XImportSection;

public class XtendItemPresentationProvider
extends XtendJvmItemPresentationProvider {
    @Inject
    private UIStrings uiStrings;
    @Inject
    @Extension
    private IXtendJvmAssociations _iXtendJvmAssociations;
    @Inject
    private OperatorMapping operatorMapping;

    protected Icon _image(XtendTypeDeclaration element) {
        JvmDeclaredType _inferredType = this._iXtendJvmAssociations.getInferredType(element);
        return this.image(_inferredType);
    }

    protected Icon _image(XtendFunction element) {
        JvmOperation _directlyInferredOperation = this._iXtendJvmAssociations.getDirectlyInferredOperation(element);
        return this.image(_directlyInferredOperation);
    }

    protected Icon _image(XtendConstructor element) {
        JvmConstructor _inferredConstructor = this._iXtendJvmAssociations.getInferredConstructor(element);
        return this.image(_inferredConstructor);
    }

    protected Icon _image(XtendField element) {
        JvmField _jvmField = this._iXtendJvmAssociations.getJvmField(element);
        return this.image(_jvmField);
    }

    protected Icon _image(XtendEnumLiteral element) {
        JvmField _jvmField = this._iXtendJvmAssociations.getJvmField(element);
        return this.image(_jvmField);
    }

    protected String _text(XtendFile element) {
        Resource _eResource = element.eResource();
        URI _uRI = _eResource.getURI();
        URI _trimFileExtension = _uRI.trimFileExtension();
        return _trimFileExtension.lastSegment();
    }

    protected String _text(XtendClass element) {
        String _name = element.getName();
        String _xifexpression = null;
        EList _typeParameters = element.getTypeParameters();
        boolean _isEmpty = _typeParameters.isEmpty();
        if (_isEmpty) {
            _xifexpression = "";
        } else {
            EList _typeParameters_1 = element.getTypeParameters();
            _xifexpression = this.uiStrings.typeParameters((Iterable)_typeParameters_1);
        }
        return _name + _xifexpression;
    }

    protected String _text(XtendInterface element) {
        String _name = element.getName();
        String _xifexpression = null;
        EList _typeParameters = element.getTypeParameters();
        boolean _isEmpty = _typeParameters.isEmpty();
        if (_isEmpty) {
            _xifexpression = "";
        } else {
            EList _typeParameters_1 = element.getTypeParameters();
            _xifexpression = this.uiStrings.typeParameters((Iterable)_typeParameters_1);
        }
        return _name + _xifexpression;
    }

    protected String _text(AnonymousClass element) {
        JvmGenericType _inferredType = this._iXtendJvmAssociations.getInferredType(element);
        return this.text(_inferredType);
    }

    protected String _text(XtendConstructor element) {
        JvmConstructor _inferredConstructor = this._iXtendJvmAssociations.getInferredConstructor(element);
        String _parameters = this.uiStrings.parameters((JvmIdentifiableElement)_inferredConstructor);
        return "new" + _parameters;
    }

    protected String _text(XtendFunction element) {
        boolean _notEquals;
        String simpleName = element.getName();
        boolean bl = _notEquals = !Objects.equal((Object)simpleName, null);
        if (_notEquals) {
            boolean _notEquals_1;
            QualifiedName qnName = QualifiedName.create((String)simpleName);
            QualifiedName operator = this.operatorMapping.getOperator(qnName);
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)operator, null);
            if (_notEquals_1) {
                String _firstSegment = operator.getFirstSegment();
                JvmOperation _directlyInferredOperation = this._iXtendJvmAssociations.getDirectlyInferredOperation(element);
                String _signature = this.signature(_firstSegment, (JvmIdentifiableElement)_directlyInferredOperation);
                String _plus = _signature + " (";
                String _plus_1 = _plus + simpleName;
                return _plus_1 + ")";
            }
        }
        String _name = element.getName();
        JvmOperation _directlyInferredOperation_1 = this._iXtendJvmAssociations.getDirectlyInferredOperation(element);
        return this.signature(_name, (JvmIdentifiableElement)_directlyInferredOperation_1);
    }

    protected String _text(XtendField element) {
        boolean _notEquals;
        boolean _isExtension;
        String _xblockexpression = null;
        boolean _and = false;
        String _name = element.getName();
        boolean _equals = Objects.equal((Object)_name, null);
        _and = !_equals ? false : (_isExtension = element.isExtension());
        if (_and) {
            JvmTypeReference _type = element.getType();
            return this.uiStrings.referenceToString(_type, "extension");
        }
        JvmTypeReference fieldType = this.getDisplayedType(element);
        boolean bl = _notEquals = !Objects.equal((Object)fieldType, null);
        if (_notEquals) {
            boolean _notEquals_1;
            String type = this.uiStrings.referenceToString(fieldType, "");
            int _length = type.length();
            boolean bl2 = _notEquals_1 = _length != 0;
            if (_notEquals_1) {
                String _name_1 = element.getName();
                String _plus = _name_1 + " : ";
                return _plus + type;
            }
        }
        _xblockexpression = element.getName();
        return _xblockexpression;
    }

    protected String _text(XtendEnumLiteral element) {
        return element.getName();
    }

    protected String _text(XtendParameter element) {
        JvmTypeReference _parameterType = element.getParameterType();
        String _simpleName = _parameterType.getSimpleName();
        String _plus = _simpleName + " ";
        String _name = element.getName();
        return _plus + _name;
    }

    protected JvmTypeReference getDisplayedType(XtendField field) {
        EObject next;
        boolean _notEquals;
        Object _xblockexpression = null;
        JvmField jvmField = this._iXtendJvmAssociations.getJvmField(field);
        boolean bl = _notEquals = !Objects.equal((Object)jvmField, null);
        if (_notEquals) {
            return jvmField.getType();
        }
        Set _jvmElements = this._iXtendJvmAssociations.getJvmElements((EObject)field);
        Iterator i = _jvmElements.iterator();
        boolean _hasNext = i.hasNext();
        if (_hasNext && (next = (EObject)i.next()) instanceof JvmOperation) {
            return ((JvmOperation)next).getReturnType();
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    public Icon image(Object element) {
        if (element instanceof XtendConstructor) {
            return this._image((XtendConstructor)element);
        }
        if (element instanceof XtendFunction) {
            return this._image((XtendFunction)element);
        }
        if (element instanceof XtendEnumLiteral) {
            return this._image((XtendEnumLiteral)element);
        }
        if (element instanceof XtendField) {
            return this._image((XtendField)element);
        }
        if (element instanceof XtendTypeDeclaration) {
            return this._image((XtendTypeDeclaration)element);
        }
        if (element instanceof IResolvedConstructor) {
            return this._image((IResolvedConstructor)element);
        }
        if (element instanceof IResolvedOperation) {
            return this._image((IResolvedOperation)element);
        }
        if (element instanceof PsiElement) {
            return this._image((PsiElement)element);
        }
        if (element instanceof EObject) {
            return this._image((EObject)element);
        }
        if (element instanceof IResolvedField) {
            return this._image((IResolvedField)element);
        }
        if (element == null) {
            return this._image(null);
        }
        if (element != null) {
            return this._image(element);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(element).toString());
    }

    @Override
    public String text(Object element) {
        if (element instanceof JvmConstructor) {
            return this._text((JvmConstructor)element);
        }
        if (element instanceof JvmEnumerationLiteral) {
            return this._text((JvmEnumerationLiteral)element);
        }
        if (element instanceof JvmOperation) {
            return this._text((JvmOperation)element);
        }
        if (element instanceof JvmField) {
            return this._text((JvmField)element);
        }
        if (element instanceof JvmGenericType) {
            return this._text((JvmGenericType)element);
        }
        if (element instanceof AnonymousClass) {
            return this._text((AnonymousClass)element);
        }
        if (element instanceof XtendClass) {
            return this._text((XtendClass)element);
        }
        if (element instanceof XtendConstructor) {
            return this._text((XtendConstructor)element);
        }
        if (element instanceof XtendFunction) {
            return this._text((XtendFunction)element);
        }
        if (element instanceof XtendInterface) {
            return this._text((XtendInterface)element);
        }
        if (element instanceof XtendEnumLiteral) {
            return this._text((XtendEnumLiteral)element);
        }
        if (element instanceof XtendField) {
            return this._text((XtendField)element);
        }
        if (element instanceof JvmFormalParameter) {
            return this._text((JvmFormalParameter)element);
        }
        if (element instanceof XtendParameter) {
            return this._text((XtendParameter)element);
        }
        if (element instanceof XVariableDeclaration) {
            return this._text((XVariableDeclaration)element);
        }
        if (element instanceof XtendFile) {
            return this._text((XtendFile)element);
        }
        if (element instanceof IResolvedConstructor) {
            return this._text((IResolvedConstructor)element);
        }
        if (element instanceof IResolvedOperation) {
            return this._text((IResolvedOperation)element);
        }
        if (element instanceof XImportDeclaration) {
            return this._text((XImportDeclaration)element);
        }
        if (element instanceof XImportSection) {
            return this._text((XImportSection)element);
        }
        if (element instanceof EObject) {
            return this._text((EObject)element);
        }
        if (element instanceof IResolvedField) {
            return this._text((IResolvedField)element);
        }
        if (element == null) {
            return this._text(null);
        }
        if (element != null) {
            return this._text(element);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(element).toString());
    }
}

