/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.idea.presentation;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.intellij.psi.PsiElement;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.idea.presentation.DefaultItemPresentationProvider;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedConstructor;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedField;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.validation.UIStrings;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XImportSection;

public class XbaseItemPresentationProvider
extends DefaultItemPresentationProvider {
    @Inject
    private UIStrings uiStrings;
    @Inject
    private CommonTypeComputationServices services;
    @Inject
    private IBatchTypeResolver typeResolver;

    @Override
    protected Icon _image(PsiElement element) {
        return element.getIcon(1);
    }

    protected Icon _image(IResolvedConstructor constructor) {
        JvmConstructor _declaration = constructor.getDeclaration();
        return this.image(_declaration);
    }

    protected Icon _image(IResolvedField field) {
        JvmField _declaration = field.getDeclaration();
        return this.image(_declaration);
    }

    protected Icon _image(IResolvedOperation operation) {
        JvmOperation _declaration = operation.getDeclaration();
        return this.image(_declaration);
    }

    protected String _text(JvmGenericType genericType) {
        return genericType.getSimpleName();
    }

    protected String _text(JvmOperation element) {
        String _simpleName = element.getSimpleName();
        return this.signature(_simpleName, (JvmIdentifiableElement)element);
    }

    protected String _text(IResolvedOperation element) {
        boolean _not;
        String _xblockexpression = null;
        LightweightTypeReference _resolvedReturnType = element.getResolvedReturnType();
        String returnTypeString = _resolvedReturnType.getSimpleName();
        String decoratedPart = " : " + returnTypeString;
        List _typeParameters = element.getTypeParameters();
        boolean _isEmpty = _typeParameters.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            String _plus_2;
            List _typeParameters_1 = element.getTypeParameters();
            String _string = this.uiStrings.toString((Iterable)_typeParameters_1);
            String _plus = " <" + _string;
            String _plus_1 = _plus + "> : ";
            decoratedPart = _plus_2 = _plus_1 + returnTypeString;
        }
        JvmOperation _declaration = element.getDeclaration();
        String _simpleName = _declaration.getSimpleName();
        String _plus_3 = _simpleName + "(";
        List _resolvedParameterTypes = element.getResolvedParameterTypes();
        Functions.Function1<LightweightTypeReference, String> _function = new Functions.Function1<LightweightTypeReference, String>(){

            public String apply(LightweightTypeReference it) {
                return it.getHumanReadableName();
            }
        };
        List _map = ListExtensions.map((List)_resolvedParameterTypes, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)", ");
        String _plus_4 = _plus_3 + _join;
        String _plus_5 = _plus_4 + ")";
        _xblockexpression = _plus_5 + decoratedPart;
        return _xblockexpression;
    }

    protected String _text(JvmConstructor constructor) {
        String _parameters = this.uiStrings.parameters((JvmIdentifiableElement)constructor);
        return "new" + _parameters;
    }

    protected String _text(IResolvedConstructor constructor) {
        List _resolvedParameterTypes = constructor.getResolvedParameterTypes();
        Functions.Function1<LightweightTypeReference, String> _function = new Functions.Function1<LightweightTypeReference, String>(){

            public String apply(LightweightTypeReference it) {
                return it.getHumanReadableName();
            }
        };
        List _map = ListExtensions.map((List)_resolvedParameterTypes, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)", ");
        String _plus = "new(" + _join;
        return _plus + ")";
    }

    protected String _text(IResolvedField field) {
        String _simpleSignature = field.getSimpleSignature();
        String _plus = _simpleSignature + " : ";
        LightweightTypeReference _resolvedType = field.getResolvedType();
        String _humanReadableName = _resolvedType.getHumanReadableName();
        return _plus + _humanReadableName;
    }

    protected String _text(JvmField field) {
        String _simpleName = field.getSimpleName();
        String _plus = _simpleName + " : ";
        JvmTypeReference _type = field.getType();
        String _simpleName_1 = _type.getSimpleName();
        return _plus + _simpleName_1;
    }

    protected String _text(JvmFormalParameter parameter) {
        String _xblockexpression = null;
        JvmTypeReference parameterType = parameter.getParameterType();
        String _xifexpression = null;
        boolean _equals = Objects.equal((Object)parameterType, null);
        if (_equals) {
            _xifexpression = parameter.getName();
        } else {
            String _simpleName = parameterType.getSimpleName();
            String _plus = _simpleName + " ";
            String _name = parameter.getName();
            _xifexpression = _plus + _name;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected String _text(XImportDeclaration it) {
        StringConcatenation _builder = new StringConcatenation();
        String _importedTypeName = it.getImportedTypeName();
        _builder.append((Object)_importedTypeName, "");
        boolean _isWildcard = it.isWildcard();
        if (_isWildcard) {
            _builder.append((Object)".*");
        } else {
            boolean _notEquals;
            String _memberName = it.getMemberName();
            boolean bl = _notEquals = !Objects.equal((Object)_memberName, null);
            if (_notEquals) {
                _builder.append((Object)".");
                String _memberName_1 = it.getMemberName();
                _builder.append((Object)_memberName_1, "");
            }
        }
        return _builder.toString();
    }

    protected String _text(XImportSection element) {
        return "import declarations";
    }

    protected String _text(XVariableDeclaration variableDeclaration) {
        boolean _notEquals;
        String _xblockexpression = null;
        IResolvedTypes resolvedTypes = this.typeResolver.resolveTypes((EObject)variableDeclaration);
        LightweightTypeReference type = resolvedTypes.getActualType((JvmIdentifiableElement)variableDeclaration);
        String _xifexpression = null;
        boolean bl = _notEquals = !Objects.equal((Object)type, null);
        if (_notEquals) {
            String _humanReadableName = type.getHumanReadableName();
            String _plus = _humanReadableName + " ";
            String _name = variableDeclaration.getName();
            _xifexpression = _plus + _name;
        } else {
            _xifexpression = variableDeclaration.getName();
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected String signature(String simpleName, JvmIdentifiableElement element) {
        boolean _notEquals;
        String _xblockexpression = null;
        JvmTypeReference _xifexpression = null;
        if (element instanceof JvmOperation) {
            _xifexpression = ((JvmOperation)element).getReturnType();
        } else {
            JvmTypeReference _xifexpression_1 = null;
            _xifexpression_1 = element instanceof JvmField ? ((JvmField)element).getType() : null;
            _xifexpression = _xifexpression_1;
        }
        JvmTypeReference returnType = _xifexpression;
        StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.services, (EObject)element);
        String _xifexpression_2 = null;
        boolean _equals = Objects.equal((Object)returnType, null);
        if (_equals) {
            _xifexpression_2 = "void";
        } else {
            LightweightTypeReference _lightweightTypeReference = owner.toLightweightTypeReference(returnType);
            _xifexpression_2 = _lightweightTypeReference.getHumanReadableName();
        }
        String returnTypeString = _xifexpression_2;
        String decoratedPart = " : " + returnTypeString;
        String _elvis = null;
        String _typeParameters = this.uiStrings.typeParameters(element);
        _elvis = _typeParameters != null ? _typeParameters : "";
        String typeParam = _elvis;
        boolean bl = _notEquals = !Objects.equal((Object)typeParam, (Object)"");
        if (_notEquals) {
            decoratedPart = " " + typeParam + " : " + returnTypeString;
        }
        String _parameters = this.uiStrings.parameters(element);
        String _plus = simpleName + _parameters;
        _xblockexpression = _plus + decoratedPart;
        return _xblockexpression;
    }

    @Override
    public Icon image(Object constructor) {
        if (constructor instanceof IResolvedConstructor) {
            return this._image((IResolvedConstructor)constructor);
        }
        if (constructor instanceof IResolvedOperation) {
            return this._image((IResolvedOperation)constructor);
        }
        if (constructor instanceof PsiElement) {
            return this._image((PsiElement)constructor);
        }
        if (constructor instanceof EObject) {
            return this._image((EObject)constructor);
        }
        if (constructor instanceof IResolvedField) {
            return this._image((IResolvedField)constructor);
        }
        if (constructor == null) {
            return this._image((Void)null);
        }
        if (constructor != null) {
            return this._image(constructor);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(constructor).toString());
    }

    @Override
    public String text(Object constructor) {
        if (constructor instanceof JvmConstructor) {
            return this._text((JvmConstructor)constructor);
        }
        if (constructor instanceof JvmOperation) {
            return this._text((JvmOperation)constructor);
        }
        if (constructor instanceof JvmField) {
            return this._text((JvmField)constructor);
        }
        if (constructor instanceof JvmGenericType) {
            return this._text((JvmGenericType)constructor);
        }
        if (constructor instanceof JvmFormalParameter) {
            return this._text((JvmFormalParameter)constructor);
        }
        if (constructor instanceof XVariableDeclaration) {
            return this._text((XVariableDeclaration)constructor);
        }
        if (constructor instanceof IResolvedConstructor) {
            return this._text((IResolvedConstructor)constructor);
        }
        if (constructor instanceof IResolvedOperation) {
            return this._text((IResolvedOperation)constructor);
        }
        if (constructor instanceof XImportDeclaration) {
            return this._text((XImportDeclaration)constructor);
        }
        if (constructor instanceof XImportSection) {
            return this._text((XImportSection)constructor);
        }
        if (constructor instanceof EObject) {
            return this._text((EObject)constructor);
        }
        if (constructor instanceof IResolvedField) {
            return this._text((IResolvedField)constructor);
        }
        if (constructor == null) {
            return this._text((Void)null);
        }
        if (constructor != null) {
            return this._text(constructor);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(constructor).toString());
    }
}

