/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.nodemodel;

import java.util.Arrays;

public class SyntaxErrorMessage {
    private final String message;
    private final String issueCode;
    private final String[] issueData;

    public SyntaxErrorMessage(String message, String issueCode) {
        this(message, issueCode, null);
    }

    public SyntaxErrorMessage(String message, String issueCode, String[] issueData) {
        if (message == null) {
            throw new NullPointerException("message may not be null");
        }
        this.message = message;
        this.issueCode = issueCode;
        this.issueData = issueData;
    }

    public String getIssueCode() {
        return this.issueCode;
    }

    public String getMessage() {
        return this.message;
    }

    public String[] getIssueData() {
        return this.issueData;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.issueCode == null ? 0 : this.issueCode.hashCode());
        result = 31 * result + Arrays.hashCode(this.issueData);
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SyntaxErrorMessage other = (SyntaxErrorMessage)obj;
        if (this.issueCode == null ? other.issueCode != null : !this.issueCode.equals(other.issueCode)) {
            return false;
        }
        if (!Arrays.equals(this.issueData, other.issueData)) {
            return false;
        }
        return !(this.message == null ? other.message != null : !this.message.equals(other.message));
    }

    public String toString() {
        return "SyntaxErrorMessage [message=" + this.message + ", issueCode=" + this.issueCode + ", issueData=" + Arrays.toString(this.issueData) + "]";
    }
}

