/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.editorActions;

import com.google.common.base.Objects;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.idea.editorActions.AutoEditContext;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Pure;

@Accessors
@FinalFieldsConstructor
public abstract class AbstractAutoEditBlock {
    private final String openingTerminal;
    private final String closingTerminal;
    private boolean shouldDeleteClosing = false;

    public abstract void open(char var1, @Extension AutoEditContext var2);

    public abstract boolean close(char var1, @Extension AutoEditContext var2);

    public boolean delete(char c, @Extension AutoEditContext context) {
        boolean _notEquals_1;
        DocumentEx _document;
        int _textLength;
        boolean _greaterThan;
        boolean _notEquals;
        if (!this.shouldDeleteClosing) {
            return false;
        }
        char _charAt = this.openingTerminal.charAt(0);
        boolean bl = _notEquals = c != _charAt;
        if (_notEquals) {
            return false;
        }
        int beginOffset = context.getCaretOffset();
        if (beginOffset < 0) {
            return false;
        }
        int _length = this.closingTerminal.length();
        int endOffset = beginOffset + _length;
        boolean bl2 = _greaterThan = endOffset > (_textLength = (_document = context.getDocument()).getTextLength());
        if (_greaterThan) {
            return false;
        }
        String s = context.getText(beginOffset, endOffset);
        boolean bl3 = _notEquals_1 = !Objects.equal((Object)s, (Object)this.closingTerminal);
        if (_notEquals_1) {
            return false;
        }
        EditorEx _editor = context.getEditor();
        DocumentEx _document_1 = _editor.getDocument();
        _document_1.deleteString(beginOffset, endOffset);
        return true;
    }

    public AbstractAutoEditBlock(String openingTerminal, String closingTerminal) {
        this.openingTerminal = openingTerminal;
        this.closingTerminal = closingTerminal;
    }

    @Pure
    public String getOpeningTerminal() {
        return this.openingTerminal;
    }

    @Pure
    public String getClosingTerminal() {
        return this.closingTerminal;
    }

    @Pure
    public boolean isShouldDeleteClosing() {
        return this.shouldDeleteClosing;
    }

    public void setShouldDeleteClosing(boolean shouldDeleteClosing) {
        this.shouldDeleteClosing = shouldDeleteClosing;
    }
}

