/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.execution;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataContextWrapper;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtext.idea.trace.IIdeaTrace;
import org.eclipse.xtext.idea.trace.ILocationInVirtualFile;
import org.eclipse.xtext.idea.trace.ITraceForVirtualFileProvider;
import org.eclipse.xtext.idea.trace.VirtualFileInProject;
import org.eclipse.xtext.psi.impl.BaseXtextFile;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurationProducerExtensions {
    @Inject
    private ITraceForVirtualFileProvider traceProvider;

    public ConfigurationContext prepareContextFor(final ConfigurationContext context, final PsiElement psiElement) {
        DataContext _dataContext = context.getDataContext();
        ConfigurationContext ctx = ConfigurationContext.getFromContext((DataContext)new DataContextWrapper(_dataContext){

            public Object getData(String dataId) {
                boolean _is = RunConfiguration.DATA_KEY.is(dataId);
                if (_is) {
                    return context.getOriginalConfiguration(null);
                }
                boolean _is_1 = LangDataKeys.MODULE.is(dataId);
                if (_is_1) {
                    return context.getModule();
                }
                boolean _is_2 = Location.DATA_KEY.is(dataId);
                if (_is_2) {
                    return PsiLocation.fromPsiElement((PsiElement)psiElement);
                }
                return super.getData(dataId);
            }
        });
        return ctx;
    }

    @Nullable
    public PsiElement tracedJavaElement(@NotNull ConfigurationContext context) {
        boolean _tripleNotEquals;
        Location _location = context.getLocation();
        PsiElement _psiElement = null;
        if (_location != null) {
            _psiElement = _location.getPsiElement();
        }
        boolean bl = _tripleNotEquals = _psiElement != null;
        if (_tripleNotEquals) {
            PsiElement psiElement;
            List<? extends PsiElement> _generatedElements;
            PsiElement javaElement;
            Location _location_1 = context.getLocation();
            PsiElement _psiElement_1 = null;
            if (_location_1 != null) {
                _psiElement_1 = _location_1.getPsiElement();
            }
            if ((javaElement = (PsiElement)IterableExtensions.head(_generatedElements = this.traceProvider.getGeneratedElements(psiElement = _psiElement_1))) == null) {
                Iterable<PsiFile> _javaFiles = this.getJavaFiles(psiElement);
                PsiFile _head = (PsiFile)IterableExtensions.head(_javaFiles);
                javaElement = _head;
            }
            return javaElement;
        }
        return null;
    }

    private Iterable<PsiFile> getJavaFiles(@NotNull PsiElement xtextElement) {
        BaseXtextFile xtextFile = (BaseXtextFile)PsiTreeUtil.getParentOfType((PsiElement)xtextElement, BaseXtextFile.class, (boolean)false);
        if (xtextFile == null) {
            return CollectionLiterals.emptySet();
        }
        VirtualFileInProject fileInProject = VirtualFileInProject.forPsiElement((PsiElement)xtextFile);
        boolean _equals = Objects.equal((Object)fileInProject, null);
        if (_equals) {
            return CollectionLiterals.emptySet();
        }
        IIdeaTrace trace = (IIdeaTrace)this.traceProvider.getTraceToTarget(fileInProject);
        if (trace != null) {
            ArrayList javaFiles = CollectionLiterals.newArrayList((Object[])new PsiFile[0]);
            Iterable _allAssociatedLocations = trace.getAllAssociatedLocations();
            for (ILocationInVirtualFile uri : _allAssociatedLocations) {
                VirtualFile _file;
                Project _project;
                PsiManager _instance;
                PsiFile javaPsiFile;
                VirtualFileInProject res = (VirtualFileInProject)uri.getPlatformResource();
                if (res == null || (javaPsiFile = (_instance = PsiManager.getInstance((Project)(_project = xtextFile.getProject()))).findFile(_file = res.getFile())) == null) continue;
                javaFiles.add(javaPsiFile);
            }
            return javaFiles;
        }
        return CollectionLiterals.emptySet();
    }
}

