/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.highlighting;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.intellij.lang.BracePair;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ide.editor.bracketmatching.IBracePairProvider;
import org.eclipse.xtext.idea.parser.TokenTypeProvider;
import org.eclipse.xtext.parser.antlr.ITokenDefProvider;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class DefaultPairedBraceMatcher
implements PairedBraceMatcher {
    private static final char KEYWORD_START_CHARACTER = '\'';
    private final BracePair[] pairs;
    private final TokenSet allowedTypes;
    private final Map<String, IElementType> tokenTypes;

    @Inject
    public DefaultPairedBraceMatcher(ITokenDefProvider tokenDefProvider, TokenTypeProvider tokenTypeProvider, IBracePairProvider bracePairProvider, IGrammarAccess grammarAccess) {
        TokenSet _createAllowedTypes;
        HashMap<String, IElementType> _createTokenTypes = this.createTokenTypes(tokenDefProvider, tokenTypeProvider);
        this.tokenTypes = _createTokenTypes;
        Iterable<BracePair> _createPairs = this.createPairs(bracePairProvider, grammarAccess);
        this.pairs = (BracePair[])Conversions.unwrapArray(_createPairs, BracePair.class);
        this.allowedTypes = _createAllowedTypes = this.createAllowedTypes(tokenTypeProvider, grammarAccess);
    }

    protected TokenSet createAllowedTypes(TokenTypeProvider tokenTypeProvider, IGrammarAccess grammarAccess) {
        TokenSet _commentTokens = tokenTypeProvider.getCommentTokens();
        TokenSet _whitespaceTokens = tokenTypeProvider.getWhitespaceTokens();
        Functions.Function1<BracePair, List<IElementType>> _function = new Functions.Function1<BracePair, List<IElementType>>(){

            public List<IElementType> apply(BracePair it) {
                IElementType _leftBraceType = it.getLeftBraceType();
                IElementType _rightBraceType = it.getRightBraceType();
                return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new IElementType[]{_leftBraceType, _rightBraceType}));
            }
        };
        List _map = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)this.pairs)), (Functions.Function1)_function);
        Iterable _flatten = Iterables.concat((Iterable)_map);
        TokenSet _create = TokenSet.create((IElementType[])((IElementType[])Conversions.unwrapArray((Object)_flatten, IElementType.class)));
        List _findKeywords = grammarAccess.findKeywords(new String[]{";", ","});
        Functions.Function1<Keyword, IElementType> _function_1 = new Functions.Function1<Keyword, IElementType>(){

            public IElementType apply(Keyword it) {
                return DefaultPairedBraceMatcher.this.getTokenType(it);
            }
        };
        List _map_1 = ListExtensions.map((List)_findKeywords, (Functions.Function1)_function_1);
        TokenSet _create_1 = TokenSet.create((IElementType[])((IElementType[])Conversions.unwrapArray((Object)_map_1, IElementType.class)));
        return TokenSet.orSet((TokenSet[])new TokenSet[]{_commentTokens, _whitespaceTokens, _create, _create_1});
    }

    protected HashMap<String, IElementType> createTokenTypes(ITokenDefProvider tokenDefProvider, TokenTypeProvider tokenTypeProvider) {
        HashMap _xblockexpression = null;
        HashMap tokenTypes = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
        Map tokenDefMap = tokenDefProvider.getTokenDefMap();
        Set _keySet = tokenDefMap.keySet();
        for (Integer antlrTokenType : _keySet) {
            String value = (String)tokenDefMap.get(antlrTokenType);
            char _charAt = value.charAt(0);
            boolean _equals = _charAt == '\'';
            if (!_equals) continue;
            IElementType tokenType = tokenTypeProvider.getIElementType(antlrTokenType);
            tokenTypes.put(value, tokenType);
        }
        _xblockexpression = tokenTypes;
        return _xblockexpression;
    }

    protected Iterable<BracePair> createPairs(IBracePairProvider bracePairProvider, final IGrammarAccess grammarAccess) {
        Set _pairs = bracePairProvider.getPairs();
        Functions.Function1<org.eclipse.xtext.ide.editor.bracketmatching.BracePair, List<BracePair>> _function = new Functions.Function1<org.eclipse.xtext.ide.editor.bracketmatching.BracePair, List<BracePair>>(){

            public List<BracePair> apply(org.eclipse.xtext.ide.editor.bracketmatching.BracePair it) {
                String _leftBrace = it.getLeftBrace();
                String _rightBrace = it.getRightBrace();
                boolean _isStructural = it.isStructural();
                return DefaultPairedBraceMatcher.this.findPairs(_leftBrace, _rightBrace, _isStructural, grammarAccess);
            }
        };
        Iterable _map = IterableExtensions.map((Iterable)_pairs, (Functions.Function1)_function);
        return Iterables.concat((Iterable)_map);
    }

    protected List<BracePair> findPairs(String leftBraceKeyword, String rightBraceKeyword, final boolean structural, IGrammarAccess grammarAccess) {
        List _findKeywordPairs = grammarAccess.findKeywordPairs(leftBraceKeyword, rightBraceKeyword);
        Functions.Function1<org.eclipse.xtext.util.Pair<Keyword, Keyword>, BracePair> _function = new Functions.Function1<org.eclipse.xtext.util.Pair<Keyword, Keyword>, BracePair>(){

            public BracePair apply(org.eclipse.xtext.util.Pair<Keyword, Keyword> it) {
                Keyword _first = (Keyword)it.getFirst();
                Keyword _second = (Keyword)it.getSecond();
                return DefaultPairedBraceMatcher.this.createPair(_first, _second, structural);
            }
        };
        return ListExtensions.map((List)_findKeywordPairs, (Functions.Function1)_function);
    }

    protected BracePair createPair(Keyword leftBraceKeyword, Keyword rightBraceKeyword, boolean structural) {
        BracePair _xblockexpression = null;
        IElementType leftBraceTokenType = this.getTokenType(leftBraceKeyword);
        IElementType rightBraceTokenType = this.getTokenType(rightBraceKeyword);
        _xblockexpression = this.createPair(leftBraceTokenType, rightBraceTokenType, structural);
        return _xblockexpression;
    }

    protected BracePair createPair(IElementType leftBraceTokenType, IElementType rightBraceTokenType, boolean structural) {
        return new BracePair(leftBraceTokenType, rightBraceTokenType, structural);
    }

    protected IElementType getTokenType(Keyword keyword) {
        String _value = keyword.getValue();
        String _plus = "'" + _value;
        String _plus_1 = _plus + "'";
        return this.tokenTypes.get(_plus_1);
    }

    public int getCodeConstructStart(PsiFile file, int openingBraceOffset) {
        return openingBraceOffset;
    }

    public BracePair[] getPairs() {
        return this.pairs;
    }

    public boolean isPairedBracesAllowedBeforeType(IElementType lbraceType, IElementType contextType) {
        return this.allowedTypes.contains(contextType);
    }
}

